/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.utils;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;

public class CSVReadUtils {
    public static Table<Integer, Integer, String> read(String inputStr, int header, String rowSep, char fieldSep) {
        HashBasedTable table = HashBasedTable.create();
        try {
            CSVFormat csvFormat = CSVFormat.EXCEL.withFirstRecordAsHeader().withRecordSeparator(rowSep).withDelimiter(fieldSep);
            CSVParser csvParser = csvFormat.parse((Reader)new StringReader(inputStr));
            Iterator iterator = csvParser.iterator();
            int rowIndex = 0;
            while (iterator.hasNext()) {
                CSVRecord csvRecord;
                int size;
                if (header <= rowIndex && (size = (csvRecord = (CSVRecord)iterator.next()).size()) > 3) {
                    for (int colIndex = 0; colIndex < size; ++colIndex) {
                        table.put((Object)rowIndex, (Object)colIndex, (Object)csvRecord.get(colIndex));
                    }
                }
                ++rowIndex;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return table;
    }
}

