/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.utils;

import com.xforceplus.account.domain.AccountTemplateDO;
import com.xforceplus.utils.FileUtil;
import com.xxl.job.core.log.XxlJobLogger;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Flags;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class MailParseUtil {
    public static String getSubject(MimeMessage msg) throws UnsupportedEncodingException, MessagingException {
        return MimeUtility.decodeText((String)msg.getSubject());
    }

    public static String getFrom(MimeMessage msg) throws MessagingException, UnsupportedEncodingException {
        String from = "";
        Address[] froms = msg.getFrom();
        if (froms.length < 1) {
            throw new MessagingException("\u6ca1\u6709\u53d1\u4ef6\u4eba!");
        }
        InternetAddress address = (InternetAddress)froms[0];
        String person = address.getPersonal();
        person = person != null ? MimeUtility.decodeText((String)person) + " " : "";
        from = person + "<" + address.getAddress() + ">";
        return from;
    }

    public static String getReceiveAddress(MimeMessage msg, Message.RecipientType type) throws MessagingException {
        StringBuffer receiveAddress = new StringBuffer();
        Address[] addresss = null;
        addresss = type == null ? msg.getAllRecipients() : msg.getRecipients(type);
        if (addresss == null || addresss.length < 1) {
            throw new MessagingException("\u6ca1\u6709\u6536\u4ef6\u4eba!");
        }
        for (Address address : addresss) {
            InternetAddress internetAddress = (InternetAddress)address;
            receiveAddress.append(internetAddress.toUnicodeString()).append(",");
        }
        receiveAddress.deleteCharAt(receiveAddress.length() - 1);
        return receiveAddress.toString();
    }

    public static String getSentDate(MimeMessage msg, String pattern) throws MessagingException {
        Date receivedDate = msg.getSentDate();
        if (receivedDate == null) {
            return "";
        }
        if (pattern == null || "".equals(pattern)) {
            pattern = "yyyy\u5e74MM\u6708dd\u65e5 E HH:mm ";
        }
        return new SimpleDateFormat(pattern).format(receivedDate);
    }

    public static boolean isContainAttachment(Part part) throws MessagingException, IOException {
        boolean flag = false;
        if (part.isMimeType("multipart/*")) {
            MimeMultipart multipart = (MimeMultipart)part.getContent();
            int partCount = multipart.getCount();
            for (int i = 0; i < partCount; ++i) {
                boolean isHasAttachment;
                BodyPart bodyPart = multipart.getBodyPart(i);
                String disp = bodyPart.getDisposition();
                boolean bl = isHasAttachment = disp != null && (disp.equalsIgnoreCase("attachment") || disp.equalsIgnoreCase("inline"));
                if (isHasAttachment) {
                    flag = true;
                } else if (bodyPart.isMimeType("multipart/*")) {
                    flag = MailParseUtil.isContainAttachment((Part)bodyPart);
                } else {
                    String contentType = bodyPart.getContentType();
                    if (contentType.contains("application")) {
                        flag = true;
                    }
                    if (contentType.contains("name")) {
                        flag = true;
                    }
                }
                if (!flag) {
                    continue;
                }
                break;
            }
        } else if (part.isMimeType("message/rfc822")) {
            flag = MailParseUtil.isContainAttachment((Part)part.getContent());
        }
        return flag;
    }

    public static boolean isSeen(MimeMessage msg) throws MessagingException {
        return msg.getFlags().contains(Flags.Flag.SEEN);
    }

    public static boolean isReplySign(MimeMessage msg) throws MessagingException {
        boolean replySign = false;
        String[] headers = msg.getHeader("Disposition-Notification-To");
        if (headers != null) {
            replySign = true;
        }
        return replySign;
    }

    public static String getPriority(MimeMessage msg) throws MessagingException {
        String priority = "\u666e\u901a";
        String[] headers = msg.getHeader("X-Priority");
        if (headers != null) {
            String headerPriority = headers[0];
            priority = headerPriority.indexOf("1") != -1 || headerPriority.indexOf("High") != -1 ? "\u7d27\u6025" : (headerPriority.indexOf("5") != -1 || headerPriority.indexOf("Low") != -1 ? "\u4f4e" : "\u666e\u901a");
        }
        return priority;
    }

    public static void getMailTextContent(Part part, StringBuffer content) throws MessagingException, IOException {
        boolean isContainTextAttach;
        boolean bl = isContainTextAttach = part.getContentType().indexOf("name") > 0;
        if (part.isMimeType("text/*") && !isContainTextAttach) {
            content.append(part.getContent().toString());
        } else if (part.isMimeType("message/rfc822")) {
            MailParseUtil.getMailTextContent((Part)part.getContent(), content);
        } else if (part.isMimeType("multipart/*")) {
            Multipart multipart = (Multipart)part.getContent();
            int partCount = multipart.getCount();
            for (int i = 0; i < partCount; ++i) {
                BodyPart bodyPart = multipart.getBodyPart(i);
                MailParseUtil.getMailTextContent((Part)bodyPart, content);
            }
        }
    }

    public static void saveAttachment(Part part, AccountTemplateDO account) throws Exception {
        if (part.isMimeType("multipart/*")) {
            Multipart multipart = (Multipart)part.getContent();
            int partCount = multipart.getCount();
            for (int i = 0; i < partCount; ++i) {
                boolean isHasAttachment;
                BodyPart bodyPart = multipart.getBodyPart(i);
                String disp = bodyPart.getDisposition();
                boolean bl = isHasAttachment = disp != null && (disp.equalsIgnoreCase("attachment") || disp.equalsIgnoreCase("inline"));
                if (isHasAttachment) {
                    InputStream inputStream = bodyPart.getInputStream();
                    FileUtil.saveFile(inputStream, account);
                    continue;
                }
                if (bodyPart.isMimeType("multipart/*")) {
                    MailParseUtil.saveAttachment((Part)bodyPart, account);
                    continue;
                }
                String contentType = bodyPart.getContentType();
                if (!contentType.contains("name") && !contentType.contains("application")) continue;
                InputStream inputStream = bodyPart.getInputStream();
                FileUtil.saveFile(inputStream, account);
            }
        } else if (part.isMimeType("message/rfc822")) {
            MailParseUtil.saveAttachment((Part)part.getContent(), account);
        }
    }

    public static void saveAttachment1(Part part, AccountTemplateDO account) throws Exception {
        boolean havaAttaName;
        Map<Object, Object> otherconfig = account.getOtherConfig();
        boolean bl = havaAttaName = otherconfig != null && otherconfig.containsKey("attachment");
        if (part.isMimeType("multipart/*")) {
            Multipart multipart = (Multipart)part.getContent();
            int partCount = multipart.getCount();
            for (int i = 0; i < partCount; ++i) {
                InputStream inputStream;
                String attachmentName;
                String fileName;
                boolean isHasAttachment;
                BodyPart bodyPart = multipart.getBodyPart(i);
                String disp = bodyPart.getDisposition();
                boolean bl2 = isHasAttachment = disp != null && (disp.equalsIgnoreCase("attachment") || disp.equalsIgnoreCase("inline"));
                if (isHasAttachment) {
                    if (havaAttaName) {
                        String attachment = otherconfig.get("attachment").toString();
                        String attachmentMsg = attachment.toLowerCase().replace(" ", "");
                        fileName = bodyPart.getFileName();
                        try {
                            fileName = MimeUtility.decodeText((String)fileName);
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            // empty catch block
                        }
                        attachmentName = StringUtils.substringBeforeLast((String)fileName, (String)"_").concat(".").concat(FilenameUtils.getExtension((String)fileName)).toLowerCase().replace(" ", "");
                        if (!StringUtils.containsIgnoreCase((CharSequence)attachmentName, (CharSequence)attachmentMsg)) continue;
                        inputStream = bodyPart.getInputStream();
                        FileUtil.saveFile(inputStream, account);
                        continue;
                    }
                    InputStream inputStream2 = bodyPart.getInputStream();
                    FileUtil.saveFile(inputStream2, account);
                    continue;
                }
                if (bodyPart.isMimeType("multipart/*")) {
                    MailParseUtil.saveAttachment((Part)bodyPart, account);
                    continue;
                }
                String contentType = bodyPart.getContentType();
                if (!contentType.contains("name") && !contentType.contains("application")) continue;
                if (havaAttaName) {
                    String attachment = otherconfig.get("attachment").toString();
                    fileName = bodyPart.getFileName();
                    attachmentName = StringUtils.substringBeforeLast((String)fileName, (String)"_").concat(".").concat(FilenameUtils.getExtension((String)fileName)).toLowerCase().replace(" ", "");
                    if (!StringUtils.containsIgnoreCase((CharSequence)attachmentName, (CharSequence)attachment)) continue;
                    inputStream = bodyPart.getInputStream();
                    FileUtil.saveFile(inputStream, account);
                    continue;
                }
                InputStream inputStream3 = bodyPart.getInputStream();
                FileUtil.saveFile(inputStream3, account);
            }
        } else if (part.isMimeType("message/rfc822")) {
            MailParseUtil.saveAttachment((Part)part.getContent(), account);
        }
    }

    public static void saveFileAndPdf(Part part, AccountTemplateDO account, List<String> paths) throws Exception {
        if (part.isMimeType("multipart/*")) {
            Multipart multipart = (Multipart)part.getContent();
            int partCount = multipart.getCount();
            for (int i = 0; i < partCount; ++i) {
                boolean isHasAttachment;
                BodyPart bodyPart = multipart.getBodyPart(i);
                String disp = bodyPart.getDisposition();
                boolean bl = isHasAttachment = disp != null && (disp.equalsIgnoreCase("attachment") || disp.equalsIgnoreCase("inline"));
                if (isHasAttachment) {
                    if (!MailParseUtil.judjeSuffix(bodyPart, account)) continue;
                    InputStream inputStream = bodyPart.getInputStream();
                    paths.add(FileUtil.saveFile(inputStream, account));
                    String fileName = FileUtil.getFileName(account);
                    String pdfFilePath = FileUtil.getPDFFilePath(account);
                    InputStream inputStream1 = bodyPart.getInputStream();
                    FileUtil.saveFile(inputStream1, pdfFilePath, fileName, account);
                    continue;
                }
                if (bodyPart.isMimeType("multipart/*")) {
                    MailParseUtil.saveFileAndPdf((Part)bodyPart, account, paths);
                    continue;
                }
                String contentType = bodyPart.getContentType();
                if (!contentType.contains("name") && !contentType.contains("application") || !MailParseUtil.judjeSuffix(bodyPart, account)) continue;
                InputStream inputStream = bodyPart.getInputStream();
                paths.add(FileUtil.saveFile(inputStream, account));
                String fileName = FileUtil.getFileName(account);
                String pdfFilePath = FileUtil.getPDFFilePath(account);
                InputStream inputStream1 = bodyPart.getInputStream();
                FileUtil.saveFile(inputStream1, pdfFilePath, fileName, account);
            }
        } else if (part.isMimeType("message/rfc822")) {
            MailParseUtil.saveFileAndPdf((Part)part.getContent(), account, paths);
        }
    }

    private static boolean judjeSuffix(BodyPart bodyPart, AccountTemplateDO account) {
        boolean flag = true;
        Map<Object, Object> siteMap = account.getSiteMap();
        if (siteMap != null) {
            String suffix = siteMap.get("suffix") + "";
            List sufList = Stream.of(suffix.toUpperCase().replace(",", ";").split(";")).collect(Collectors.toList());
            try {
                String fileName = bodyPart.getFileName();
                fileName = StringUtils.defaultString((String)FilenameUtils.getExtension((String)fileName)).toUpperCase();
                flag = sufList.contains(fileName);
            }
            catch (Exception e) {
                XxlJobLogger.log((String)("\u5224\u65ad\u9644\u4ef6\u540e\u7f00\u540d\u65f6\u51fa\u9519" + ExceptionUtils.getStackTrace((Throwable)e)), (Object[])new Object[0]);
            }
        }
        return flag;
    }
}

