/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.utils;

import com.gargoylesoftware.htmlunit.FormEncodingType;
import com.gargoylesoftware.htmlunit.HttpMethod;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.ProxyConfig;
import com.gargoylesoftware.htmlunit.StringWebResponse;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.parser.neko.HtmlUnitNekoHtmlParser;
import com.gargoylesoftware.htmlunit.util.NameValuePair;
import com.google.common.base.Splitter;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.xforceplus.account.AbstractLoginSys;
import com.xforceplus.account.domain.AccountTemplateDO;
import com.xforceplus.apollo.utils.ErrorUtil;
import com.xforceplus.janus.config.core.config.HttpConfig;
import com.xforceplus.utils.BaseUtils;
import com.xforceplus.utils.WebClientUtil;
import com.xxl.job.core.log.XxlJobLogger;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class PageUtil {
    public static Map<String, Map<String, String>> cookieMap = new HashMap<String, Map<String, String>>();
    public static Cache<String, ProxyConfig> cache = CacheBuilder.newBuilder().maximumSize(100000L).expireAfterWrite(5L, TimeUnit.MINUTES).build();
    private static final List<String> EXPS = Arrays.asList("proxy authorization invalid", "proxy authorization expired", "connection timed out", "connection refused", "remote host terminated the handshake", "err_proxy_auth_unsupported");
    private static final List<String> RETRYS = Arrays.asList("read timed out", "connect timed out", "proxy authorization invalid", "proxy authorization expired", "connection timed out", "connection refused", "remote host terminated the handshake");

    public static <P extends Page> P getPage(WebClient webClient, String url, Map<String, String> headers, HttpMethod httpMethod) {
        return PageUtil.getPage(webClient, url, headers, httpMethod, null);
    }

    public static <P extends Page> P getPage(WebClient webClient, String url, Map<String, String> headers, HttpMethod httpMethod, AccountTemplateDO accountTemplateDO) {
        Page page = null;
        WebRequest webRequest = null;
        try {
            Map<String, String> myMap;
            if (url.toLowerCase().contains("rt-mart")) {
                XxlJobLogger.log((String)"rtmart sleep 2s", (Object[])new Object[0]);
                Thread.sleep(BaseUtils.randomLong(3, 1));
            }
            webRequest = new WebRequest(new URL(url));
            if (httpMethod != null) {
                webRequest.setHttpMethod(httpMethod);
            }
            if (null != accountTemplateDO && cookieMap.containsKey(AbstractLoginSys.loginCacheKey(accountTemplateDO)) && MapUtils.isNotEmpty(myMap = cookieMap.get(AbstractLoginSys.loginCacheKey(accountTemplateDO)))) {
                if (headers == null) {
                    headers = new HashMap<String, String>();
                }
                headers.putAll(myMap);
            }
            if (headers != null) {
                webRequest.setAdditionalHeaders(headers);
            }
            PageUtil.fillProxy(webClient.hashCode() + "", webRequest);
            if (null != accountTemplateDO) {
                accountTemplateDO.setRequestUrl(url);
            }
            page = webClient.getPage(webRequest);
            XxlJobLogger.log((String)"\u8bf7\u6c42{}", (Object[])new Object[]{url});
            page = PageUtil.handleRenewIpProxy(page, accountTemplateDO, webClient, webRequest);
            return (P)page;
        }
        catch (Throwable e) {
            String eMessage = e.getMessage();
            XxlJobLogger.log((String)"\u8bf7\u6c42{}-\u62a5\u9519{}", (Object[])new Object[]{url, ErrorUtil.getStackMsg((Throwable)e)});
            try {
                if (PageUtil.isRenewIpProxy(eMessage, webClient.hashCode() + "")) {
                    WebClientUtil.ipProxyRenew(webClient, accountTemplateDO);
                    Thread.sleep(BaseUtils.randomLong(5, 3));
                    PageUtil.fillProxy(webClient.hashCode() + "", webRequest);
                }
                page = PageUtil.handleRetry(webClient, webRequest, eMessage);
                return (P)page;
            }
            catch (Exception ex) {
                XxlJobLogger.log((String)"\u91cd\u8bd5\u8bf7\u6c42{}-\u62a5\u9519{}", (Object[])new Object[]{url, ErrorUtil.getStackMsg((Exception)ex)});
                return null;
            }
        }
    }

    public static <P extends Page> P getPage(WebClient webClient, String url, HttpMethod httpMethod, String requestBody, Map<String, String> headers, Charset charset) {
        return PageUtil.getPage(webClient, url, httpMethod, requestBody, headers, charset, null);
    }

    public static <P extends Page> P getPage(WebClient webClient, String url, HttpMethod httpMethod, String requestBody, Map<String, String> headers, Charset charset, AccountTemplateDO accountTemplateDO) {
        Page page = null;
        WebRequest webRequest = null;
        try {
            Map<String, String> myMap;
            webRequest = new WebRequest(new URL(url), httpMethod);
            if (StringUtils.isNotBlank((CharSequence)requestBody)) {
                webRequest.setRequestBody(requestBody);
            }
            if (charset != null) {
                webRequest.setCharset(charset);
            } else {
                webRequest.setCharset(StandardCharsets.UTF_8);
            }
            if (null != accountTemplateDO && cookieMap.containsKey(AbstractLoginSys.loginCacheKey(accountTemplateDO)) && MapUtils.isNotEmpty(myMap = cookieMap.get(AbstractLoginSys.loginCacheKey(accountTemplateDO)))) {
                if (headers == null) {
                    headers = new HashMap<String, String>();
                }
                headers.putAll(myMap);
            }
            if (headers != null) {
                webRequest.setAdditionalHeaders(headers);
            }
            PageUtil.fillProxy(webClient.hashCode() + "", webRequest);
            if (null != accountTemplateDO) {
                accountTemplateDO.setRequestUrl(url);
            }
            page = webClient.getPage(webRequest);
            XxlJobLogger.log((String)"\u8bf7\u6c42{}", (Object[])new Object[]{url});
            page = PageUtil.handleRenewIpProxy(page, accountTemplateDO, webClient, webRequest);
            return (P)page;
        }
        catch (Throwable e) {
            String eMessage = e.getMessage();
            XxlJobLogger.log((String)"\u8bf7\u6c42{}-\u62a5\u9519{}", (Object[])new Object[]{url, ErrorUtil.getStackMsg((Throwable)e)});
            try {
                if (PageUtil.isRenewIpProxy(eMessage, webClient.hashCode() + "")) {
                    WebClientUtil.ipProxyRenew(webClient, accountTemplateDO);
                    PageUtil.fillProxy(webClient.hashCode() + "", webRequest);
                    Thread.sleep(BaseUtils.randomLong(5, 3));
                }
                page = PageUtil.handleRetry(webClient, webRequest, eMessage);
                return (P)page;
            }
            catch (Exception ex) {
                XxlJobLogger.log((String)"\u91cd\u8bd5\u8bf7\u6c42{}-\u62a5\u9519{}", (Object[])new Object[]{url, ErrorUtil.getStackMsg((Exception)ex)});
                return null;
            }
        }
    }

    public static <P extends Page> P getPage(WebClient webClient, String url, HttpMethod httpMethod, String[][] params, Map<String, String> headers, Charset charset, FormEncodingType formEncodingType) {
        return PageUtil.getPage(webClient, url, httpMethod, params, headers, charset, formEncodingType, null);
    }

    public static <P extends Page> P getPage(WebClient webClient, String url, HttpMethod httpMethod, String[][] params, Map<String, String> headers, Charset charset, FormEncodingType formEncodingType, AccountTemplateDO accountTemplateDO) {
        Page page = null;
        WebRequest webRequest = null;
        try {
            Map<String, String> myMap;
            webRequest = new WebRequest(new URL(url));
            if (httpMethod != null) {
                webRequest.setHttpMethod(httpMethod);
            }
            if (null != accountTemplateDO && cookieMap.containsKey(AbstractLoginSys.loginCacheKey(accountTemplateDO)) && MapUtils.isNotEmpty(myMap = cookieMap.get(AbstractLoginSys.loginCacheKey(accountTemplateDO)))) {
                if (headers == null) {
                    headers = new HashMap<String, String>();
                }
                headers.putAll(myMap);
            }
            if (headers != null) {
                webRequest.setAdditionalHeaders(headers);
            }
            ArrayList<NameValuePair> reqParam = new ArrayList<NameValuePair>();
            if (params != null) {
                for (String[] param : params) {
                    reqParam.add(new NameValuePair(param[0], param[1]));
                }
            }
            webRequest.setRequestParameters(reqParam);
            if (formEncodingType != null) {
                webRequest.setEncodingType(formEncodingType);
            }
            if (charset != null) {
                webRequest.setCharset(charset);
            } else {
                webRequest.setCharset(StandardCharsets.UTF_8);
            }
            PageUtil.fillProxy(webClient.hashCode() + "", webRequest);
            if (null != accountTemplateDO) {
                accountTemplateDO.setRequestUrl(url);
            }
            page = webClient.getPage(webRequest);
            XxlJobLogger.log((String)"\u8bf7\u6c42{}", (Object[])new Object[]{url});
            page = PageUtil.handleRenewIpProxy(page, accountTemplateDO, webClient, webRequest);
            return (P)page;
        }
        catch (Throwable e) {
            String eMessage = e.getMessage();
            XxlJobLogger.log((String)"\u8bf7\u6c42{}-\u62a5\u9519{}", (Object[])new Object[]{url, ErrorUtil.getStackMsg((Throwable)e)});
            try {
                if (PageUtil.isRenewIpProxy(eMessage, webClient.hashCode() + "")) {
                    WebClientUtil.ipProxyRenew(webClient, accountTemplateDO);
                    Thread.sleep(BaseUtils.randomLong(5, 3));
                    PageUtil.fillProxy(webClient.hashCode() + "", webRequest);
                }
                page = PageUtil.handleRetry(webClient, webRequest, eMessage);
                return (P)page;
            }
            catch (Exception ex) {
                XxlJobLogger.log((String)"\u91cd\u8bd5\u8bf7\u6c42{}-\u62a5\u9519{}", (Object[])new Object[]{url, ErrorUtil.getStackMsg((Exception)ex)});
                return null;
            }
        }
    }

    public static HtmlPage createHtmlPage(WebClient webClient, String content, String[] parameters) throws Exception {
        StringBuilder htmlStr = new StringBuilder("<html><head><meta charset='utf-8'/></head><body>");
        htmlStr.append(content);
        htmlStr.append("</body></html>");
        HtmlUnitNekoHtmlParser parser = new HtmlUnitNekoHtmlParser();
        HtmlPage htmlPage = parser.parseHtml((WebResponse)new StringWebResponse(htmlStr.toString(), new URL("https://www.baidu.com/")), webClient.getCurrentWindow());
        if (parameters != null && parameters.length > 0) {
            StringBuilder params = new StringBuilder("[");
            for (int i = 0; i < parameters.length; ++i) {
                params.append(parameters[i]);
                if (i == parameters.length - 1) continue;
                params.append(",");
            }
            params.append("]");
            Map additionalHeaders = htmlPage.getWebResponse().getWebRequest().getAdditionalHeaders();
            additionalHeaders.put("e2e_key", params.toString());
        }
        return htmlPage;
    }

    private static void fillProxy(String cacheKey, WebRequest webRequest) {
        ProxyConfig proxyConfig = (ProxyConfig)cache.getIfPresent((Object)cacheKey);
        if (null != proxyConfig && StringUtils.isNotBlank((CharSequence)proxyConfig.getProxyHost())) {
            webRequest.setProxyHost(proxyConfig.getProxyHost());
            webRequest.setProxyPort(proxyConfig.getProxyPort());
        }
    }

    private static Page handleRenewIpProxy(Page page, AccountTemplateDO accountTemplateDO, WebClient webClient, WebRequest webRequest) throws Exception {
        Page rePage;
        String responseStr;
        boolean flag = false;
        if (null != accountTemplateDO && accountTemplateDO.getIpProxy() != null && accountTemplateDO.getIpProxy() == 1 && null != page && null != page.getWebResponse() && StringUtils.isNotBlank((CharSequence)(responseStr = page.getWebResponse().getContentAsString())) && PageUtil.isRenewIpProxy(responseStr, webClient.hashCode() + "")) {
            WebClientUtil.ipProxyRenew(webClient, accountTemplateDO);
            Thread.sleep(BaseUtils.randomLong(5, 3));
            PageUtil.fillProxy(webClient.hashCode() + "", webRequest);
            page = webClient.getPage(webRequest);
            flag = true;
        }
        if (!flag && null != (rePage = PageUtil.handleRetry(webClient, webRequest, responseStr = page.getWebResponse().getContentAsString()))) {
            page = rePage;
        }
        return page;
    }

    public static boolean isRenewIpProxy(String responseStr, String cacheKey) {
        boolean flag = false;
        if (StringUtils.isNotBlank((CharSequence)responseStr) && null == cache.getIfPresent((Object)cacheKey)) {
            List cfs;
            responseStr = responseStr.toLowerCase();
            String txt = (String)HttpConfig.getConfig((String)"dcs_renew_ip_txt");
            ArrayList<String> txts = new ArrayList<String>();
            if (StringUtils.isNotBlank((CharSequence)txt) && CollectionUtils.isNotEmpty((Collection)(cfs = Splitter.on((String)",").splitToList((CharSequence)txt)))) {
                txts.addAll(cfs);
            }
            txts.addAll(EXPS);
            for (String exp : txts) {
                flag = responseStr.contains(exp);
                if (!flag) continue;
                XxlJobLogger.log((String)"\u8bf7\u6c42\u54cd\u5e94:{},\u53ef\u80fd\u9700\u8981\u91cd\u65b0\u83b7\u53d6\u4ee3\u7406IP", (Object[])new Object[]{responseStr});
                break;
            }
        }
        return flag;
    }

    private static Page handleRetry(WebClient webClient, WebRequest webRequest, String eMessage) throws Exception {
        Page page = null;
        if (StringUtils.isNotBlank((CharSequence)eMessage)) {
            String exp;
            List cfs;
            eMessage = eMessage.toLowerCase();
            String txt = (String)HttpConfig.getConfig((String)"dcs_retry_txt");
            ArrayList<String> txts = new ArrayList<String>();
            if (StringUtils.isNotBlank((CharSequence)txt) && CollectionUtils.isNotEmpty((Collection)(cfs = Splitter.on((String)",").splitToList((CharSequence)txt)))) {
                txts.addAll(cfs);
            }
            txts.addAll(RETRYS);
            boolean flag = false;
            Iterator iterator = txts.iterator();
            while (iterator.hasNext() && !(flag = eMessage.contains(exp = (String)iterator.next()))) {
            }
            if (flag) {
                XxlJobLogger.log((String)"\u8bf7\u6c42{} \u62a5\u9519:{},\u5f00\u59cb\u91cd\u8bd5", (Object[])new Object[]{null != webRequest.getUrl() ? webRequest.getUrl().getPath() : "", eMessage});
                Thread.sleep(BaseUtils.randomLong(5, 3));
                page = webClient.getPage(webRequest);
            }
        }
        return page;
    }
}

