/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.utils.selenium;

import com.google.common.collect.Maps;
import com.xforceplus.account.domain.AccountTemplateDO;
import com.xforceplus.apollo.utils.ErrorUtil;
import com.xforceplus.core.config.CommonConfig;
import com.xforceplus.proxy.ProxyIpFactory;
import com.xforceplus.proxy.domain.IpResponse;
import com.xforceplus.utils.BaseUtils;
import com.xforceplus.utils.FileUtil;
import com.xforceplus.utils.selenium.ChromeDriverProxy;
import com.xxl.job.core.log.XxlJobLogger;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.TreeMap;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Point;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.chrome.ChromeDriverService;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.logging.LoggingPreferences;
import sun.misc.BASE64Decoder;

public class SeleniumUtils {
    public static final String ELEMENT_BY_ID = "byId";
    public static final String ELEMENT_BY_CLASSNAME = "byClassname";
    public static final String ELEMENT_BY_XPATH = "byXpath";
    public static final String ELEMENT_BY_NAME = "byName";
    public static String WEB_DRIVER_PATH = CommonConfig.WEB_DRIVER_PATH == null ? "D:\\data\\pdp\\webdriver\\chromedriver.exe" : CommonConfig.WEB_DRIVER_PATH;
    public static String USER_DATA_DIR = CommonConfig.USER_DATA_DIR == null ? "D:\\selenum\\chromeuser" : CommonConfig.USER_DATA_DIR;
    public static String USER_DOWNLOAD_DIR = CommonConfig.USER_DOWNLOAD_DIR == null ? "D:\\selenum\\chromedownload" : CommonConfig.USER_DOWNLOAD_DIR;
    public static String ENV = CommonConfig.ENV == null ? "dev" : CommonConfig.ENV;
    private static final String PROFILE_DIR = "Default";

    public static File elementSnapshot(WebDriver driver, WebElement element) throws Exception {
        File screen = (File)((TakesScreenshot)driver).getScreenshotAs(OutputType.FILE);
        BufferedImage image = ImageIO.read(screen);
        int width = element.getSize().getWidth();
        int height = element.getSize().getHeight();
        Rectangle rect = new Rectangle(width, height);
        Point p = element.getLocation();
        int w = rect.width;
        int h = rect.height;
        int x = p.getX();
        int y = p.getY();
        int w_driver = 1920;
        int h_driver = 1080;
        try {
            if (y + h > h_driver) {
                h -= y + h - h_driver;
            }
            if (x + w > w_driver) {
                w = x - (x + w - w_driver);
            }
            BufferedImage img = image.getSubimage(x, y, w, h);
            ImageIO.write((RenderedImage)img, "png", screen);
            XxlJobLogger.log((String)"Screenshot By element success", (Object[])new Object[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return screen;
    }

    public static int getMoveDistance(String basicImgDir, String outImg, int offset) {
        try {
            String currImg = SeleniumUtils.getSimilarPath(basicImgDir, outImg);
            BufferedImage bg = ImageIO.read(new File(outImg));
            BufferedImage fullBg = ImageIO.read(new File(currImg));
            int[] tmp1 = new int[3];
            int[] tmp2 = new int[3];
            int gap = 0;
            block2: for (int i = offset; i < bg.getWidth(); ++i) {
                for (int j = offset; j < bg.getHeight(); ++j) {
                    int rgb1 = bg.getRGB(i, j);
                    int rgb2 = fullBg.getRGB(i, j);
                    tmp1[0] = rgb1 >> 16 & 0xFF;
                    tmp1[1] = rgb1 >> 8 & 0xFF;
                    tmp1[2] = rgb1 & 0xFF;
                    tmp2[0] = rgb2 >> 16 & 0xFF;
                    tmp2[1] = rgb2 >> 8 & 0xFF;
                    tmp2[2] = rgb2 & 0xFF;
                    if (Math.abs(tmp1[0] - tmp2[0]) < 60 && Math.abs(tmp1[1] - tmp2[1]) < 60 && Math.abs(tmp1[2] - tmp2[2]) < 60) continue;
                    gap = i;
                    break block2;
                }
            }
            return gap;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("\u672a\u627e\u5230\u9700\u8981\u5e73\u79fb\u7684\u4f4d\u7f6e");
        }
    }

    public static String getSimilarPath(String baseImgDic, String compareImg) {
        File file = new File(baseImgDic);
        File[] tempList = file.listFiles();
        TreeMap map = new TreeMap(Comparator.reverseOrder());
        for (File f : tempList) {
            float percent = SeleniumUtils.compare(SeleniumUtils.getData(f.getAbsolutePath()), SeleniumUtils.getData(compareImg));
            map.put(Float.valueOf(percent), f.getAbsolutePath());
        }
        Optional o = map.values().stream().findFirst();
        return o.get().toString();
    }

    private static int[] getData(String name) {
        try {
            BufferedImage img = ImageIO.read(new File(name));
            BufferedImage slt = new BufferedImage(100, 100, 1);
            slt.getGraphics().drawImage(img, 0, 0, 100, 100, null);
            int[] data = new int[256];
            for (int x = 0; x < slt.getWidth(); ++x) {
                for (int y = 0; y < slt.getHeight(); ++y) {
                    int rgb = slt.getRGB(x, y);
                    Color myColor = new Color(rgb);
                    int r = myColor.getRed();
                    int g = myColor.getGreen();
                    int b = myColor.getBlue();
                    int n = (r + g + b) / 3;
                    data[n] = data[n] + 1;
                }
            }
            return data;
        }
        catch (Exception exception) {
            XxlJobLogger.log((String)"\u6709\u6587\u4ef6\u6ca1\u6709\u627e\u5230,\u8bf7\u68c0\u67e5\u6587\u4ef6\u662f\u5426\u5b58\u5728\u6216\u8def\u5f84\u662f\u5426\u6b63\u786e", (Object[])new Object[0]);
            return null;
        }
    }

    private static float compare(int[] s, int[] t) {
        try {
            float result = 0.0f;
            for (int i = 0; i < 256; ++i) {
                int abs = Math.abs(s[i] - t[i]);
                int max = Math.max(s[i], t[i]);
                result += 1.0f - (float)abs / (float)(max == 0 ? 1 : max);
            }
            return result / 256.0f * 100.0f;
        }
        catch (Exception exception) {
            return 0.0f;
        }
    }

    public static void generateFile(String imgBase64, String filePath) throws Exception {
        imgBase64 = imgBase64.startsWith("data:image/png;base64,") ? imgBase64.substring(22) : imgBase64;
        BASE64Decoder decoder = new BASE64Decoder();
        byte[] bgBytes = decoder.decodeBuffer(imgBase64);
        File file = new File(filePath);
        boolean exists = file.exists();
        if (!exists) {
            file.getParentFile().mkdirs();
            file.createNewFile();
        }
        FileOutputStream stream = new FileOutputStream(filePath);
        stream.write(bgBytes);
        stream.flush();
        stream.close();
    }

    public static void putElementValue(String element, String value, WebDriver driver, String byType) {
        By by;
        switch (byType) {
            case "byId": {
                by = By.id((String)element);
                break;
            }
            case "byClassname": {
                by = By.className((String)element);
                break;
            }
            case "byXpath": {
                by = By.xpath((String)element);
                break;
            }
            case "byName": {
                by = By.name((String)element);
                break;
            }
            default: {
                throw new RuntimeException("\u65e0\u6548\u7684\u7c7b\u578b:" + byType);
            }
        }
        WebElement webElement = driver.findElement(by);
        webElement.clear();
        webElement.sendKeys(new CharSequence[]{value});
    }

    public static WebElement isExistElement(String element, WebDriver driver, String byType) {
        By by;
        switch (byType) {
            case "byId": {
                by = By.id((String)element);
                break;
            }
            case "byClassname": {
                by = By.className((String)element);
                break;
            }
            case "byXpath": {
                by = By.xpath((String)element);
                break;
            }
            case "byName": {
                by = By.name((String)element);
                break;
            }
            default: {
                throw new RuntimeException("\u65e0\u6548\u7684\u7c7b\u578b:" + byType);
            }
        }
        try {
            return driver.findElement(by);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static List<WebElement> isExistElements(String element, WebDriver driver, String byType) {
        By by;
        switch (byType) {
            case "byId": {
                by = By.id((String)element);
                break;
            }
            case "byClassname": {
                by = By.className((String)element);
                break;
            }
            case "byXpath": {
                by = By.xpath((String)element);
                break;
            }
            case "byName": {
                by = By.name((String)element);
                break;
            }
            default: {
                throw new RuntimeException("\u65e0\u6548\u7684\u7c7b\u578b:" + byType);
            }
        }
        try {
            return driver.findElements(by);
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ChromeDriverProxy createChromeDriverRenew(AccountTemplateDO account, ChromeDriverProxy chromeDriverProxy) {
        try {
            if (null != chromeDriverProxy) {
                Thread.sleep(BaseUtils.randomLong(5, 3));
                chromeDriverProxy.quit();
                Thread.sleep(BaseUtils.randomLong(5, 3));
            }
            account.setIpRenew(true);
            ChromeDriverProxy chromeDriverProxy2 = SeleniumUtils.createChromeDriver(account);
            return chromeDriverProxy2;
        }
        catch (Exception e) {
            XxlJobLogger.log((String)ErrorUtil.getStackMsg((Exception)e), (Object[])new Object[0]);
            ChromeDriverProxy chromeDriverProxy3 = chromeDriverProxy;
            return chromeDriverProxy3;
        }
        finally {
            account.setIpRenew(false);
        }
    }

    public static ChromeDriverProxy createChromeDriver(AccountTemplateDO account) {
        IpResponse proxyConfig;
        String projectKey = account.getProjectKey();
        String retailKey = account.getRetailKey();
        String billsType = account.getBillsType();
        String accountname = account.getAccountName();
        System.setProperty("webdriver.chrome.driver", WEB_DRIVER_PATH);
        ChromeOptions options = new ChromeOptions();
        options.addArguments(new String[]{"--disable-popup-blocking"});
        options.addArguments(new String[]{"--no-sandbox"});
        options.addArguments(new String[]{"--disable-dev-shm-usage"});
        options.addArguments(new String[]{"--disable-extensions"});
        options.addArguments(new String[]{"--remote-allow-origins=*"});
        options.addArguments(new String[]{"--no-default-browser-check"});
        options.addArguments(new String[]{"--headless"});
        options.addArguments(new String[]{"--window-size=1920,1080"});
        options.addArguments(new String[]{"--user-data-dir=" + USER_DATA_DIR + File.separator + projectKey + File.separator + retailKey + File.separator + billsType + File.separator + accountname});
        if (account.getIpProxy() != null && account.getIpProxy() == 1 && (ENV.contains("prod") || ENV.contains("sit")) && null != (proxyConfig = ProxyIpFactory.getIpProxy(account)) && StringUtils.isNotBlank((CharSequence)proxyConfig.getIp()) && StringUtils.isNotBlank((CharSequence)proxyConfig.getPort())) {
            String proxyIp = proxyConfig.getIp();
            String proxyPort = proxyConfig.getPort();
            String proxyServer = proxyIp + ":" + proxyPort;
            Proxy proxy = new Proxy().setHttpProxy(proxyServer).setSslProxy(proxyServer);
            options.setProxy(proxy);
            if (StringUtils.isNotBlank((CharSequence)proxyConfig.getBasicProxy())) {
                options.addArguments(new String[]{"--proxy-auth=" + proxyConfig.getBasicProxy()});
            }
        }
        HashMap<String, Object> prefs = new HashMap<String, Object>();
        prefs.put("profile.default_content_setting_values.automatic_downloads", true);
        prefs.put("credentials_enable_service", false);
        prefs.put("profile.password_manager_enabled", false);
        prefs.put("download.default_directory", USER_DOWNLOAD_DIR + File.separator + projectKey + File.separator + retailKey + File.separator + billsType + File.separator + accountname);
        options.setExperimentalOption("prefs", prefs);
        LoggingPreferences logPrefs = new LoggingPreferences();
        logPrefs.enable("performance", Level.ALL);
        options.setCapability("loggingPrefs", (Object)logPrefs);
        int port = new Random().nextInt(8000);
        ChromeDriverService driverService = (ChromeDriverService)((ChromeDriverService.Builder)new ChromeDriverService.Builder().usingPort(port)).build();
        ChromeDriverProxy driver = new ChromeDriverProxy(options, driverService, port);
        HashMap params = Maps.newHashMapWithExpectedSize((int)4);
        params.put("behavior", "allow");
        params.put("downloadPath", USER_DOWNLOAD_DIR + File.separator + projectKey + File.separator + retailKey + File.separator + billsType + File.separator + accountname);
        driver.executeCdpCommand("Browser.setDownloadBehavior", params);
        int requestTimeOutConfig = account.getRequestTimeOutConfig() == null ? 20 : account.getRequestTimeOutConfig();
        driver.manage().timeouts().implicitlyWait(Duration.ofSeconds(requestTimeOutConfig));
        return driver;
    }

    public static ChromeDriverProxy createChromeDriverPlus(AccountTemplateDO account, List<String> arguments, boolean isArgCover, Map<String, Object> prefsMap, boolean isPrefsCover, Map<String, Object> paramsMap, boolean isParamsCover) {
        IpResponse proxyConfig;
        String projectKey = account.getProjectKey();
        String retailKey = account.getRetailKey();
        String billsType = account.getBillsType();
        String accountname = account.getAccountName();
        System.setProperty("webdriver.chrome.driver", WEB_DRIVER_PATH);
        ChromeOptions options = new ChromeOptions();
        if (!isArgCover && CollectionUtils.isNotEmpty(arguments)) {
            arguments.forEach(xva$0 -> options.addArguments(new String[]{xva$0}));
        } else {
            options.addArguments(new String[]{"--disable-popup-blocking"});
            options.addArguments(new String[]{"no-sandbox"});
            options.addArguments(new String[]{"--disable-dev-shm-usage"});
            options.addArguments(new String[]{"disable-extensions"});
            options.addArguments(new String[]{"--remote-allow-origins=*"});
            options.addArguments(new String[]{"no-default-browser-check"});
            options.addArguments(new String[]{"--headless"});
            options.addArguments(new String[]{"--window-size=1920,1080"});
            options.addArguments(new String[]{"--user-data-dir=" + USER_DATA_DIR + File.separator + projectKey + File.separator + retailKey + File.separator + billsType + File.separator + accountname});
            if (isArgCover && CollectionUtils.isNotEmpty(arguments)) {
                arguments.forEach(xva$0 -> options.addArguments(new String[]{xva$0}));
            }
        }
        if (account.getIpProxy() != null && account.getIpProxy() == 1 && (ENV.contains("prod") || ENV.contains("sit")) && null != (proxyConfig = ProxyIpFactory.getIpProxy(account)) && StringUtils.isNotBlank((CharSequence)proxyConfig.getIp()) && StringUtils.isNotBlank((CharSequence)proxyConfig.getPort())) {
            String proxyIp = proxyConfig.getIp();
            String proxyPort = proxyConfig.getPort();
            String proxyServer = proxyIp + ":" + proxyPort;
            Proxy proxy = new Proxy().setHttpProxy(proxyServer).setSslProxy(proxyServer);
            options.setProxy(proxy);
            if (StringUtils.isNotBlank((CharSequence)proxyConfig.getBasicProxy())) {
                options.addArguments(new String[]{"--proxy-auth=" + proxyConfig.getBasicProxy()});
            }
        }
        HashMap<String, Object> prefs = new HashMap<String, Object>();
        if (!isPrefsCover && MapUtils.isNotEmpty(prefsMap)) {
            prefs.putAll(prefsMap);
        } else {
            prefs.put("profile.default_content_setting_values.automatic_downloads", true);
            prefs.put("credentials_enable_service", false);
            prefs.put("profile.password_manager_enabled", false);
            prefs.put("download.default_directory", USER_DOWNLOAD_DIR + File.separator + projectKey + File.separator + retailKey + File.separator + billsType + File.separator + accountname);
            if (isPrefsCover && MapUtils.isNotEmpty(prefsMap)) {
                prefs.putAll(prefsMap);
            }
        }
        options.setExperimentalOption("prefs", prefs);
        LoggingPreferences logPrefs = new LoggingPreferences();
        logPrefs.enable("performance", Level.ALL);
        options.setCapability("loggingPrefs", (Object)logPrefs);
        int port = new Random().nextInt(8000);
        ChromeDriverService driverService = (ChromeDriverService)((ChromeDriverService.Builder)new ChromeDriverService.Builder().usingPort(port)).build();
        ChromeDriverProxy driver = new ChromeDriverProxy(options, driverService, port);
        HashMap params = Maps.newHashMapWithExpectedSize((int)4);
        if (!isParamsCover && MapUtils.isNotEmpty(paramsMap)) {
            params.putAll(paramsMap);
        } else {
            params.put("behavior", "allow");
            params.put("downloadPath", USER_DOWNLOAD_DIR + File.separator + projectKey + File.separator + retailKey + File.separator + billsType + File.separator + accountname);
            if (isParamsCover && MapUtils.isNotEmpty(paramsMap)) {
                params.putAll(paramsMap);
            }
        }
        driver.executeCdpCommand("Browser.setDownloadBehavior", params);
        int requestTimeOutConfig = account.getRequestTimeOutConfig() == null ? 20 : account.getRequestTimeOutConfig();
        driver.manage().timeouts().implicitlyWait(Duration.ofSeconds(requestTimeOutConfig));
        return driver;
    }

    public static ChromeDriverProxy createCustomChromeDriver(AccountTemplateDO account, boolean defaultMode, Proxy proxy) {
        String projectKey = account.getProjectKey();
        String retailKey = account.getRetailKey();
        String billsType = account.getBillsType();
        String accountname = account.getAccountName();
        System.setProperty("webdriver.chrome.driver", WEB_DRIVER_PATH);
        ChromeOptions options = new ChromeOptions();
        options.addArguments(new String[]{"--disable-popup-blocking"});
        options.addArguments(new String[]{"no-sandbox"});
        options.addArguments(new String[]{"--disable-dev-shm-usage"});
        options.addArguments(new String[]{"disable-extensions"});
        options.addArguments(new String[]{"--remote-allow-origins=*"});
        options.addArguments(new String[]{"no-default-browser-check"});
        options.addArguments(new String[]{"--headless"});
        options.addArguments(new String[]{"--window-size=1920,1080"});
        options.addArguments(new String[]{"--user-data-dir=" + USER_DATA_DIR + File.separator + projectKey + File.separator + retailKey + File.separator + billsType + File.separator + accountname});
        options.addArguments(new String[]{"--disable-blink-features"});
        options.addArguments(new String[]{"--disable-blink-features=AutomationControlled"});
        options.addArguments(new String[]{"--disable-extensions"});
        options.setProxy(proxy);
        options.setAcceptInsecureCerts(true);
        HashMap<String, Object> prefs = new HashMap<String, Object>();
        prefs.put("credentials_enable_service", false);
        prefs.put("profile.password_manager_enabled", false);
        prefs.put("profile.default_content_setting_values.automatic_downloads", true);
        prefs.put("download.default_directory", USER_DOWNLOAD_DIR + File.separator + projectKey + File.separator + retailKey + File.separator + billsType + File.separator + accountname);
        options.setExperimentalOption("prefs", prefs);
        LoggingPreferences logPrefs = new LoggingPreferences();
        logPrefs.enable("performance", Level.ALL);
        int port = new Random().nextInt(8000);
        ChromeDriverService driverService = (ChromeDriverService)((ChromeDriverService.Builder)new ChromeDriverService.Builder().usingPort(port)).build();
        ChromeDriverProxy driver = new ChromeDriverProxy(options, driverService, port);
        HashMap params = Maps.newHashMapWithExpectedSize((int)4);
        params.put("behavior", "allow");
        params.put("downloadPath", USER_DOWNLOAD_DIR + File.separator + projectKey + File.separator + retailKey + File.separator + billsType + File.separator + accountname);
        driver.executeCdpCommand("Browser.setDownloadBehavior", params);
        int requestTimeOutConfig = account.getRequestTimeOutConfig() == null ? 20 : account.getRequestTimeOutConfig();
        driver.manage().timeouts().implicitlyWait(Duration.ofSeconds(requestTimeOutConfig));
        return driver;
    }

    public static ChromeDriverProxy createChromeDriver1(AccountTemplateDO account) {
        IpResponse proxyConfig;
        String projectKey = account.getProjectKey();
        String retailKey = account.getRetailKey();
        String billsType = account.getBillsType();
        String accountname = account.getAccountName();
        System.setProperty("webdriver.chrome.driver", WEB_DRIVER_PATH);
        ChromeOptions options = new ChromeOptions();
        options.addArguments(new String[]{"--disable-popup-blocking"});
        options.addArguments(new String[]{"no-sandbox"});
        options.addArguments(new String[]{"--disable-dev-shm-usage"});
        options.addArguments(new String[]{"disable-extensions"});
        options.addArguments(new String[]{"--remote-allow-origins=*"});
        options.addArguments(new String[]{"no-default-browser-check"});
        options.addArguments(new String[]{"--headless"});
        options.addArguments(new String[]{"--window-size=1920,1080"});
        options.addArguments(new String[]{"--user-data-dir=" + USER_DATA_DIR + File.separator + projectKey + File.separator + retailKey + File.separator + billsType + File.separator + accountname});
        options.addArguments(new String[]{"--disable-blink-features"});
        options.addArguments(new String[]{"--disable-blink-features=AutomationControlled"});
        options.addArguments(new String[]{"--disable-extensions"});
        if (account.getIpProxy() != null && account.getIpProxy() == 1 && (ENV.contains("prod") || ENV.contains("sit")) && null != (proxyConfig = ProxyIpFactory.getIpProxy(account)) && StringUtils.isNotBlank((CharSequence)proxyConfig.getIp()) && StringUtils.isNotBlank((CharSequence)proxyConfig.getPort())) {
            String proxyIp = proxyConfig.getIp();
            String proxyPort = proxyConfig.getPort();
            String proxyServer = proxyIp + ":" + proxyPort;
            Proxy proxy = new Proxy().setHttpProxy(proxyServer).setSslProxy(proxyServer);
            options.setProxy(proxy);
            if (StringUtils.isNotBlank((CharSequence)proxyConfig.getBasicProxy())) {
                options.addArguments(new String[]{"--proxy-auth=" + proxyConfig.getBasicProxy()});
            }
        }
        HashMap<String, Object> prefs = new HashMap<String, Object>();
        prefs.put("credentials_enable_service", false);
        prefs.put("profile.password_manager_enabled", false);
        prefs.put("profile.default_content_setting_values.automatic_downloads", true);
        prefs.put("download.default_directory", USER_DOWNLOAD_DIR + File.separator + projectKey + File.separator + retailKey + File.separator + billsType + File.separator + accountname);
        options.setExperimentalOption("prefs", prefs);
        LoggingPreferences logPrefs = new LoggingPreferences();
        logPrefs.enable("performance", Level.ALL);
        int port = new Random().nextInt(8000);
        ChromeDriverService driverService = (ChromeDriverService)((ChromeDriverService.Builder)new ChromeDriverService.Builder().usingPort(port)).build();
        ChromeDriverProxy driver = new ChromeDriverProxy(options, driverService, port);
        HashMap params = Maps.newHashMapWithExpectedSize((int)4);
        params.put("behavior", "allow");
        params.put("downloadPath", USER_DOWNLOAD_DIR + File.separator + projectKey + File.separator + retailKey + File.separator + billsType + File.separator + accountname);
        driver.executeCdpCommand("Browser.setDownloadBehavior", params);
        int requestTimeOutConfig = account.getRequestTimeOutConfig() == null ? 20 : account.getRequestTimeOutConfig();
        driver.manage().timeouts().implicitlyWait(Duration.ofSeconds(requestTimeOutConfig));
        return driver;
    }

    public static ChromeDriverProxy createChromeDriverHasView(AccountTemplateDO account) {
        IpResponse proxyConfig;
        String projectKey = account.getProjectKey();
        String retailKey = account.getRetailKey();
        String billsType = account.getBillsType();
        String accountname = account.getAccountName();
        System.setProperty("webdriver.chrome.driver", WEB_DRIVER_PATH);
        ChromeOptions options = new ChromeOptions();
        options.addArguments(new String[]{"--disable-popup-blocking"});
        options.addArguments(new String[]{"no-sandbox"});
        options.addArguments(new String[]{"--disable-dev-shm-usage"});
        options.addArguments(new String[]{"disable-extensions"});
        options.addArguments(new String[]{"--remote-allow-origins=*"});
        options.addArguments(new String[]{"no-default-browser-check"});
        options.addArguments(new String[]{"--window-size=1920,1080"});
        options.addArguments(new String[]{"--user-data-dir=" + USER_DATA_DIR + File.separator + projectKey + File.separator + retailKey + File.separator + billsType + File.separator + accountname});
        options.addArguments(new String[]{"--disable-blink-features"});
        options.addArguments(new String[]{"--disable-blink-features=AutomationControlled"});
        options.addArguments(new String[]{"--disable-extensions"});
        if (account.getIpProxy() != null && account.getIpProxy() == 1 && (ENV.contains("prod") || ENV.contains("sit")) && null != (proxyConfig = ProxyIpFactory.getIpProxy(account)) && StringUtils.isNotBlank((CharSequence)proxyConfig.getIp()) && StringUtils.isNotBlank((CharSequence)proxyConfig.getPort())) {
            String proxyIp = proxyConfig.getIp();
            String proxyPort = proxyConfig.getPort();
            String proxyServer = proxyIp + ":" + proxyPort;
            Proxy proxy = new Proxy().setHttpProxy(proxyServer).setSslProxy(proxyServer);
            options.setProxy(proxy);
            if (StringUtils.isNotBlank((CharSequence)proxyConfig.getBasicProxy())) {
                options.addArguments(new String[]{"--proxy-auth=" + proxyConfig.getBasicProxy()});
            }
        }
        HashMap<String, Object> prefs = new HashMap<String, Object>();
        prefs.put("credentials_enable_service", false);
        prefs.put("profile.password_manager_enabled", false);
        prefs.put("profile.default_content_setting_values.automatic_downloads", true);
        prefs.put("download.default_directory", USER_DOWNLOAD_DIR + File.separator + projectKey + File.separator + retailKey + File.separator + billsType + File.separator + accountname);
        options.setExperimentalOption("prefs", prefs);
        LoggingPreferences logPrefs = new LoggingPreferences();
        logPrefs.enable("performance", Level.ALL);
        int port = new Random().nextInt(8000);
        ChromeDriverService driverService = (ChromeDriverService)((ChromeDriverService.Builder)new ChromeDriverService.Builder().usingPort(port)).build();
        ChromeDriverProxy driver = new ChromeDriverProxy(options, driverService, port);
        HashMap params = Maps.newHashMapWithExpectedSize((int)4);
        params.put("behavior", "allow");
        params.put("downloadPath", USER_DOWNLOAD_DIR + File.separator + projectKey + File.separator + retailKey + File.separator + billsType + File.separator + accountname);
        driver.executeCdpCommand("Browser.setDownloadBehavior", params);
        int requestTimeOutConfig = account.getRequestTimeOutConfig() == null ? 20 : account.getRequestTimeOutConfig();
        driver.manage().timeouts().implicitlyWait(Duration.ofSeconds(requestTimeOutConfig));
        return driver;
    }

    public static ChromeDriverProxy createChromeDriver2(AccountTemplateDO account) {
        IpResponse proxyConfig;
        String projectKey = account.getProjectKey();
        String retailKey = account.getRetailKey();
        String billsType = account.getBillsType();
        String accountname = account.getAccountName();
        System.setProperty("webdriver.chrome.driver", WEB_DRIVER_PATH);
        ChromeOptions options = new ChromeOptions();
        options.addArguments(new String[]{"--disable-popup-blocking"});
        options.addArguments(new String[]{"--no-sandbox"});
        options.addArguments(new String[]{"--disable-dev-shm-usage"});
        options.addArguments(new String[]{"disable-extensions"});
        options.addArguments(new String[]{"--remote-allow-origins=*"});
        options.addArguments(new String[]{"no-default-browser-check"});
        options.addArguments(new String[]{"--headless=new"});
        options.addArguments(new String[]{"--enable-local-storage"});
        options.addArguments(new String[]{"--enable-offline-pages"});
        options.addArguments(new String[]{"--window-size=1920,1080"});
        options.addArguments(new String[]{"--user-data-dir=" + USER_DATA_DIR + File.separator + projectKey + File.separator + retailKey + File.separator + billsType + File.separator + accountname});
        options.addArguments(new String[]{"--disable-blink-features"});
        options.addArguments(new String[]{"--disable-blink-features=AutomationControlled"});
        options.addArguments(new String[]{"--disable-extensions"});
        options.addArguments(new String[]{"--enable-networking"});
        options.addArguments(new String[]{"--disable-features=VizDisplayCompositor"});
        options.addArguments(new String[]{"--disable-gpu"});
        if (account.getIpProxy() != null && account.getIpProxy() == 1 && (ENV.contains("prod") || ENV.contains("sit")) && null != (proxyConfig = ProxyIpFactory.getIpProxy(account)) && StringUtils.isNotBlank((CharSequence)proxyConfig.getIp()) && StringUtils.isNotBlank((CharSequence)proxyConfig.getPort())) {
            String proxyIp = proxyConfig.getIp();
            String proxyPort = proxyConfig.getPort();
            String proxyServer = proxyIp + ":" + proxyPort;
            Proxy proxy = new Proxy().setHttpProxy(proxyServer).setSslProxy(proxyServer);
            options.setProxy(proxy);
            if (StringUtils.isNotBlank((CharSequence)proxyConfig.getBasicProxy())) {
                options.addArguments(new String[]{"--proxy-auth=" + proxyConfig.getBasicProxy()});
            }
        }
        HashMap<String, Object> prefs = new HashMap<String, Object>();
        prefs.put("credentials_enable_service", false);
        prefs.put("profile.password_manager_enabled", false);
        prefs.put("profile.default_content_setting_values.automatic_downloads", true);
        prefs.put("download.default_directory", USER_DOWNLOAD_DIR + File.separator + projectKey + File.separator + retailKey + File.separator + billsType + File.separator + accountname);
        options.setExperimentalOption("prefs", prefs);
        LoggingPreferences logPrefs = new LoggingPreferences();
        logPrefs.enable("performance", Level.ALL);
        int port = new Random().nextInt(8000);
        ChromeDriverService driverService = (ChromeDriverService)((ChromeDriverService.Builder)new ChromeDriverService.Builder().usingPort(port)).build();
        ChromeDriverProxy driver = new ChromeDriverProxy(options, driverService, port);
        HashMap params = Maps.newHashMapWithExpectedSize((int)4);
        params.put("behavior", "allow");
        params.put("downloadPath", USER_DOWNLOAD_DIR + File.separator + projectKey + File.separator + retailKey + File.separator + billsType + File.separator + accountname);
        driver.executeCdpCommand("Browser.setDownloadBehavior", params);
        int requestTimeOutConfig = account.getRequestTimeOutConfig() == null ? 20 : account.getRequestTimeOutConfig();
        driver.manage().timeouts().implicitlyWait(Duration.ofSeconds(requestTimeOutConfig));
        return driver;
    }

    public static boolean doesWebElementExist(WebDriver driver, By selector) {
        try {
            driver.findElement(selector);
            return true;
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    public static void screenshot(WebDriver driver, String filePath, AccountTemplateDO account) throws Exception {
        FileUtil.createDir(filePath);
        String fileName = account.getAccountName() + "-" + account.getBillsType() + "-" + System.currentTimeMillis();
        File screen = (File)((TakesScreenshot)driver).getScreenshotAs(OutputType.FILE);
        FileUtils.copyFile((File)screen, (File)new File(filePath, fileName + ".png"));
        SeleniumUtils.saveFile(driver.getPageSource(), filePath, fileName + ".html", StandardCharsets.UTF_8);
    }

    public static void saveFile(String fileData, String filePath, String fileName, Charset charset) {
        File file = new File(filePath, fileName);
        try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(file), charset);){
            out.write(fileData);
            out.flush();
        }
        catch (Exception e) {
            XxlJobLogger.log((String)("\u6587\u4ef6\u751f\u6210\u5f02\u5e38:" + ExceptionUtils.getMessage((Throwable)e)), (Object[])new Object[0]);
        }
    }

    public static ChromeDriverProxy createChromeDriver3(AccountTemplateDO account) {
        IpResponse proxyConfig;
        String projectKey = account.getProjectKey();
        String retailKey = account.getRetailKey();
        String billsType = account.getBillsType();
        String accountname = account.getAccountName();
        System.setProperty("webdriver.chrome.driver", WEB_DRIVER_PATH);
        ChromeOptions options = new ChromeOptions();
        options.addArguments(new String[]{"--disable-popup-blocking"});
        options.addArguments(new String[]{"no-sandbox"});
        options.addArguments(new String[]{"--disable-dev-shm-usage"});
        options.addArguments(new String[]{"disable-extensions"});
        options.addArguments(new String[]{"--remote-allow-origins=*"});
        options.addArguments(new String[]{"no-default-browser-check"});
        options.addArguments(new String[]{"--headless"});
        options.addArguments(new String[]{"--window-size=1920,1080"});
        options.addArguments(new String[]{"--user-data-dir=" + USER_DATA_DIR + File.separator + projectKey + File.separator + retailKey + File.separator + accountname});
        options.addArguments(new String[]{"--disable-blink-features"});
        options.addArguments(new String[]{"--disable-blink-features=AutomationControlled"});
        options.addArguments(new String[]{"--disable-extensions"});
        if (account.getIpProxy() != null && account.getIpProxy() == 1 && (ENV.contains("prod") || ENV.contains("sit")) && null != (proxyConfig = ProxyIpFactory.getIpProxy(account)) && StringUtils.isNotBlank((CharSequence)proxyConfig.getIp()) && StringUtils.isNotBlank((CharSequence)proxyConfig.getPort())) {
            String proxyIp = proxyConfig.getIp();
            String proxyPort = proxyConfig.getPort();
            String proxyServer = proxyIp + ":" + proxyPort;
            Proxy proxy = new Proxy().setHttpProxy(proxyServer).setSslProxy(proxyServer);
            options.setProxy(proxy);
            if (StringUtils.isNotBlank((CharSequence)proxyConfig.getBasicProxy())) {
                options.addArguments(new String[]{"--proxy-auth=" + proxyConfig.getBasicProxy()});
            }
        }
        HashMap<String, Object> prefs = new HashMap<String, Object>();
        prefs.put("credentials_enable_service", false);
        prefs.put("profile.password_manager_enabled", false);
        prefs.put("profile.default_content_setting_values.automatic_downloads", true);
        prefs.put("download.default_directory", USER_DOWNLOAD_DIR + File.separator + projectKey + File.separator + retailKey + File.separator + accountname);
        options.setExperimentalOption("prefs", prefs);
        LoggingPreferences logPrefs = new LoggingPreferences();
        logPrefs.enable("performance", Level.ALL);
        int port = new Random().nextInt(8000);
        ChromeDriverService driverService = (ChromeDriverService)((ChromeDriverService.Builder)new ChromeDriverService.Builder().usingPort(port)).build();
        ChromeDriverProxy driver = new ChromeDriverProxy(options, driverService, port);
        HashMap params = Maps.newHashMapWithExpectedSize((int)4);
        params.put("behavior", "allow");
        params.put("downloadPath", USER_DOWNLOAD_DIR + File.separator + projectKey + File.separator + retailKey + File.separator + accountname);
        driver.executeCdpCommand("Browser.setDownloadBehavior", params);
        int requestTimeOutConfig = account.getRequestTimeOutConfig() == null ? 20 : account.getRequestTimeOutConfig();
        driver.manage().timeouts().implicitlyWait(Duration.ofSeconds(requestTimeOutConfig));
        return driver;
    }
}

