/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.core.aop;

import com.alibaba.fastjson.JSON;
import com.xforceplus.account.domain.AccountTemplateDO;
import com.xforceplus.core.aop.AOPUtil;
import com.xforceplus.utils.DateUtils;
import com.xforceplus.utils.logincheck.LoginCheck;
import com.xxl.job.core.log.XxlJobLogger;
import java.net.InetAddress;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class AOPLogin {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String LOGIN_CHECK_MSG = "loginCheckMsg";
    @Autowired
    Environment environment;
    private final ThreadLocal<Long> startTime = new ThreadLocal();
    private final ThreadLocal<Map<String, Long>> invokeCountMap = new ThreadLocal();
    private static final String loginCutPoint = "@annotation(com.xforceplus.utils.annotation.LoginDesc)";

    @Pointcut(value="@annotation(com.xforceplus.utils.annotation.LoginDesc)")
    public void loginCutPoint() {
    }

    @Around(value="loginCutPoint()")
    public Object doAround(ProceedingJoinPoint joinPoint) throws Throwable {
        if (this.invokeCountMap.get() == null) {
            this.invokeCountMap.set(new HashMap());
        }
        String loginDesc = AOPUtil.getLoginDesc((JoinPoint)joinPoint);
        XxlJobLogger.log((String)">>>>>>>>>>> {} login : ip={} port={}", (Object[])new Object[]{loginDesc, InetAddress.getLocalHost(), this.environment.getProperty("server.port")});
        this.logger.info(">>>>>>>>>>> {} login : ip={} port={}", new Object[]{loginDesc, InetAddress.getLocalHost(), this.environment.getProperty("server.port")});
        long start = System.currentTimeMillis();
        Date startDate = new Date(start);
        XxlJobLogger.log((String)">>>>>>>>>>> {} login : start time = {}", (Object[])new Object[]{loginDesc, DateUtils.dateToLongString(startDate)});
        this.logger.info(">>>>>>>>>>> {} login : start time = {}", (Object)loginDesc, (Object)DateUtils.dateToLongString(startDate));
        this.startTime.set(start);
        String methodName = AOPUtil.getMethodName((JoinPoint)joinPoint);
        if (this.invokeCountMap.get().containsKey(methodName)) {
            Long count = this.invokeCountMap.get().get(methodName);
            this.invokeCountMap.get().remove(methodName);
            this.invokeCountMap.get().put(methodName, count + 1L);
        } else {
            this.invokeCountMap.get().put(methodName, 1L);
        }
        XxlJobLogger.log((String)">>>>>>>>>>> {} login : count = {}", (Object[])new Object[]{loginDesc, this.invokeCountMap.get().get(methodName)});
        this.logger.info(">>>>>>>>>>> {} login : count = {}", (Object)loginDesc, (Object)this.invokeCountMap.get().get(methodName));
        Object result = joinPoint.proceed();
        long end = System.currentTimeMillis();
        long total = end - this.startTime.get();
        XxlJobLogger.log((String)">>>>>>>>>>> {} login : end time = {}", (Object[])new Object[]{loginDesc, DateUtils.dateToLongString(new Date(end))});
        this.logger.info(">>>>>>>>>>> {} login : end time = {}", (Object)loginDesc, (Object)DateUtils.dateToLongString(new Date(end)));
        XxlJobLogger.log((String)">>>>>>>>>>> {} login : total = {} s", (Object[])new Object[]{loginDesc, Math.round(total / 1000L)});
        this.logger.info(">>>>>>>>>>> {} login : total = {} s", (Object)loginDesc, (Object)Math.round(total / 1000L));
        if (result == null) {
            XxlJobLogger.log((String)">>>>>>>>>>> {} {}", (Object[])new Object[]{loginDesc, "failure\uff01\uff01\uff01"});
            this.logger.info(">>>>>>>>>>> {} login : result = {}", (Object)loginDesc, (Object)"failure\uff01\uff01\uff01");
        } else {
            XxlJobLogger.log((String)">>>>>>>>>>> {} login : result = {}", (Object[])new Object[]{loginDesc, "success\uff01\uff01\uff01"});
            this.logger.info(">>>>>>>>>>> {} login : result = {}", (Object)loginDesc, (Object)"success\uff01\uff01\uff01");
        }
        return result;
    }

    private void sendDcsLoginErrorMessage(ProceedingJoinPoint joinPoint, Date startDate, Throwable e) {
        block6: {
            try {
                String loginClass = joinPoint.getTarget().getClass().getSimpleName();
                AccountTemplateDO account = (AccountTemplateDO)joinPoint.getArgs()[0];
                Map contextMap = (Map)joinPoint.getArgs()[1];
                LoginCheck loginCheck = new LoginCheck(account, contextMap);
                try {
                    LoginCheck t = (LoginCheck)JSON.parseObject((String)(contextMap.get(LOGIN_CHECK_MSG) + ""), LoginCheck.class);
                    if (t != null) {
                        loginCheck = t;
                        break block6;
                    }
                    t.setMsg("\u672a\u8fd4\u56de\u767b\u5f55\u5f02\u5e38\u4fe1\u606f");
                }
                catch (Exception ignore) {
                    this.logger.info(">>>>>>>>>>> {}({}) \u672a\u8fd4\u56de\u767b\u5f55\u5f02\u5e38\u4fe1\u606f\uff01\uff01\uff01", (Object)loginClass, (Object)AOPUtil.getCollectionDesc((JoinPoint)joinPoint));
                    if (e != null) {
                        loginCheck.setMsg(ExceptionUtils.getStackTrace((Throwable)e));
                    }
                }
            }
            catch (Exception exception) {
                this.logger.info(">>>>>>>>>>> \u767b\u5f55\u5f02\u5e38\u6d88\u606f\u53d1\u9001\u5931\u8d25" + exception.getMessage());
            }
        }
    }
}

