/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.proxy;

import com.xforceplus.lock.redisson.RedissonLock;
import com.xforceplus.proxy.IpTracker;
import com.xforceplus.proxy.ProxyIpFactory;
import com.xforceplus.proxy.domain.IpTrackerDo;
import com.xforceplus.proxy.service.IpPoolProxyConfigService;
import com.xforceplus.utils.DateUtils;
import com.xforceplus.utils.SpringContext;
import com.xxl.job.core.log.XxlJobLogger;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.redisson.api.RBucket;

public class IpPoolProxyConfigHandler {
    public static final String PROXY_IP_POOL_ALL_KEY = "job:ipproxy:pool:ip_cache_all";
    private static final IpPoolProxyConfigService ipPoolProxyConfigService = SpringContext.getBean(IpPoolProxyConfigService.class);
    private static final RedissonLock redissonLock = SpringContext.getBean(RedissonLock.class);
    public static final String OK_IP_LIST = "proxyIpSuccessList";

    private static Map<String, String> getSuccessIpProxyMap(String accountKey) {
        String proxyPort;
        String proxyIp;
        List<IpTrackerDo> list = IpTracker.getInstance().getRecentIps(accountKey);
        List<IpTrackerDo> oks = IpTracker.getInstance().getRecentIps(OK_IP_LIST);
        HashSet successSet = new HashSet();
        if (CollectionUtils.isNotEmpty(oks)) {
            oks.forEach(it -> successSet.add(it.getIpPort()));
        }
        if (CollectionUtils.isNotEmpty(list)) {
            list.sort(Comparator.comparing(IpTrackerDo::getScore).reversed());
            for (IpTrackerDo ipDo : list) {
                proxyIp = ipDo.getIpPort().split(",")[0];
                proxyPort = ipDo.getIpPort().split(",")[1];
                if (!successSet.contains(ipDo.getIpPort())) continue;
                if (ProxyIpFactory.validateProxy(proxyIp, proxyPort, "")) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("proxyIp", proxyIp);
                    map.put("proxyPort", proxyPort);
                    IpPoolProxyConfigHandler.setProxyConfigCache(proxyIp, proxyPort, accountKey);
                    IpTracker.getInstance().addOrUpdateIp(accountKey, ipDo.getIpPort());
                    IpTracker.getInstance().removeIp(OK_IP_LIST, ipDo.getIpPort());
                    return map;
                }
                IpTracker.getInstance().removeIp(accountKey, ipDo.getIpPort());
            }
        }
        for (String key : successSet) {
            proxyIp = key.split(",")[0];
            if (ProxyIpFactory.validateProxy(proxyIp, proxyPort = key.split(",")[1], "")) {
                XxlJobLogger.log((String)"\u4ece\u4ee3\u7406IP\u6c60\u4e2d\u53d6\u5230\u6709\u6548ip\uff1aproxyIp:{},proxyPort:{}", (Object[])new Object[]{proxyIp, proxyPort});
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("proxyIp", proxyIp);
                map.put("proxyPort", proxyPort);
                IpPoolProxyConfigHandler.setProxyConfigCache(proxyIp, proxyPort, accountKey);
                IpTracker.getInstance().addOrUpdateIp(accountKey, key);
                IpTracker.getInstance().removeIp(OK_IP_LIST, key);
                return map;
            }
            IpTracker.getInstance().removeIp(OK_IP_LIST, key);
        }
        return null;
    }

    public static void setProxyConfigCache(String proxyIp, String proxyPort, String accountKey) {
        XxlJobLogger.log((String)"\u7f13\u5b58\u516c\u53f8\u4ee3\u7406IP\u3010{}:{}\u3011", (Object[])new Object[]{proxyIp, proxyPort});
        RBucket keyObject = redissonLock.getRedissonManager().getRedisson().getBucket("job:ipproxy:map_cache:" + accountKey);
        HashMap proxyConfigMap = new HashMap();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("proxyIp", proxyIp);
        map.put("proxyPort", proxyPort);
        map.put("createTime", DateUtils.getNowTime());
        map.put("expire", "180");
        proxyConfigMap.put("proxyConfig", map);
        keyObject.delete();
        keyObject.set(proxyConfigMap);
        keyObject.expire(15L, TimeUnit.MINUTES);
    }

    public static Map<String, String> getProxy(String accountKey) {
        RBucket ipPoolRBucket;
        Map ipPoolMap;
        Map<String, String> successIpProxyMap = null;
        successIpProxyMap = IpPoolProxyConfigHandler.getSuccessIpProxyMap(accountKey);
        if (successIpProxyMap == null && (ipPoolMap = (Map)(ipPoolRBucket = redissonLock.getRedissonManager().getRedisson().getBucket(PROXY_IP_POOL_ALL_KEY)).get()) != null && ipPoolMap.size() >= 5) {
            XxlJobLogger.log((String)"\u89e6\u53d1ip\u7f13\u5b58\u6c60\u56de\u6536\u5229\u7528ipPoolMap:{}", (Object[])new Object[]{ipPoolMap.size()});
            ipPoolProxyConfigService.recoveryIpPool();
        }
        return successIpProxyMap;
    }

    public static void addIpPoolProxy(Map<String, String> proxyMap) {
        try {
            RBucket ipPoolRBucket = redissonLock.getRedissonManager().getRedisson().getBucket(PROXY_IP_POOL_ALL_KEY);
            HashMap<String, Map<String, String>> ipPoolMap = (HashMap<String, Map<String, String>>)ipPoolRBucket.get();
            if (ipPoolMap == null) {
                ipPoolMap = new HashMap<String, Map<String, String>>();
                ipPoolRBucket.set(ipPoolMap);
            }
            String proxyIp = proxyMap.get("proxyIp");
            String proxyPort = proxyMap.get("proxyPort");
            XxlJobLogger.log((String)"\u52a0\u5165ip\u7f13\u5b58\u6c60 ip:{},port:{}", (Object[])new Object[]{proxyIp, proxyPort});
            if (proxyMap != null && ipPoolMap != null) {
                String key = proxyIp + "," + proxyPort;
                ipPoolMap.put(key, proxyMap);
                ipPoolRBucket.set(ipPoolMap);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

