/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.utils.mail.service.impl;

import com.xforceplus.utils.mail.service.SendMailService;
import com.xxl.job.core.log.XxlJobLogger;
import java.io.File;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.InputStreamSource;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Component;

@Component
public class SendMailServiceImpl
implements SendMailService {
    private static Logger logger = LoggerFactory.getLogger(SendMailServiceImpl.class);
    @Autowired
    private JavaMailSender javaMailSender;
    @Value(value="${spring.mail.username}")
    private String from;

    @Override
    public void sendSimpleMail(String[] to, String[] cc, String title, String content) {
        System.setProperty("mail.mime.splitlongparameters", "false");
        SimpleMailMessage message = this.getSimpleMailMessage(to, cc, title, content);
        this.javaMailSender.send(message);
    }

    private SimpleMailMessage getSimpleMailMessage(String[] to, String[] cc, String title, String content) {
        SimpleMailMessage message = new SimpleMailMessage();
        message.setFrom(this.from);
        message.setTo(to);
        message.setCc(cc);
        message.setSubject(title);
        message.setText(content);
        logger.info("\u90ae\u4ef6\u53d1\u9001\u4fe1\u606f\u5b9e\u4f53\u7c7b" + message);
        XxlJobLogger.log((String)"---------------\u90ae\u4ef6\u53d1\u9001\u6210\u529f---------------", (Object[])new Object[0]);
        return message;
    }

    @Override
    public boolean sendComplexMailToUsers(String[] to, String[] cc, String title, String content, String zipFileName) {
        System.setProperty("mail.mime.splitlongparameters", "false");
        try {
            this.commSendComplexMailToUsers(to, cc, title, content, zipFileName);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private void commSendComplexMailToUsers(String[] to, String[] cc, String title, String content, String zipFileName) throws Exception {
        MimeMessage mimeMessage = this.javaMailSender.createMimeMessage();
        MimeMessageHelper mimeMessageHelper = new MimeMessageHelper(mimeMessage, true);
        mimeMessageHelper.setFrom(this.from);
        mimeMessageHelper.setTo(to);
        mimeMessageHelper.setCc(cc);
        mimeMessageHelper.setSubject(title);
        mimeMessageHelper.setText(content);
        File newFile = new File(zipFileName);
        FileSystemResource fileSystemResource = new FileSystemResource(newFile);
        String fileName = fileSystemResource.getFilename();
        mimeMessageHelper.addAttachment(fileName, (InputStreamSource)fileSystemResource);
        this.javaMailSender.send(mimeMessage);
    }
}

