/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.captcha;

import com.alibaba.fastjson.JSONObject;
import com.gargoylesoftware.htmlunit.FailingHttpStatusCodeException;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.WebClient;
import com.xforceplus.apollo.utils.ErrorUtil;
import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.captcha.CaptchaResponse;
import com.xforceplus.captcha.ChaoJiYing;
import com.xforceplus.core.config.CommonConfig;
import com.xforceplus.core.enums.IntConstant;
import com.xforceplus.janus.config.core.config.HttpConfig;
import com.xforceplus.janus.config.core.util.JanusHttpUtil;
import com.xforceplus.utils.BaseUtils;
import com.xforceplus.utils.CommonDataHelper;
import com.xforceplus.utils.Config;
import com.xforceplus.utils.HtmlStrUtil;
import com.xforceplus.utils.RedisUtil;
import com.xxl.job.core.log.XxlJobLogger;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.ThreadContext;

public class CaptchaUtil {
    public static String ORIGIN_URL = CommonConfig.ORIGIN_URL;
    public static String SLIDER_URL = CommonConfig.SLIDER_URL;
    private static int POWERE2E_RETRY = CommonConfig.POWERE2E_RETRY;
    private static int CHAOJIYING_RETRY = CommonConfig.CHAOJIYING_RETRY;
    static Map<String, String> lenMinMap = new HashMap<String, String>();
    public static final String CAPTCHA_INNER_TYPE = "inner";
    public static final String CAPTCHA_CJY_TYPE = "chaojiying";
    public static final String CAPTCHA_SMS = "SMS";

    public static String getVcodeByDama2(Page page, int type, int timeout) {
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        try {
            if (page != null) {
                File file = new File(FileUtils.getTempDirectory(), UUID.randomUUID().toString());
                InputStream inputStream = page.getWebResponse().getContentAsStream();
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                IOUtils.copy((InputStream)inputStream, (OutputStream)byteArrayOutputStream);
                byte[] data = byteArrayOutputStream.toByteArray();
                FileUtils.writeByteArrayToFile((File)file, (byte[])data);
                String pluginName = ThreadContext.get((String)"pluginName");
                ThreadContext.put((String)(pluginName + "_vcodePath"), (String)file.getAbsolutePath());
                HashMap<String, String> codetypeMap = new HashMap<String, String>();
                codetypeMap.put("42", "1902");
                codetypeMap.put("53", "1005");
                codetypeMap.put("54", "1006");
                codetypeMap.put("55", "6001");
                codetypeMap.put("50", "5000");
                HashMap<String, String> lenMinMap = new HashMap<String, String>();
                lenMinMap.put("42", "4");
                lenMinMap.put("53", "5");
                lenMinMap.put("54", "6");
                lenMinMap.put("55", "0");
                lenMinMap.put("50", "5");
                String msg = ChaoJiYing.PostPic(Config.UNAME, Config.UPASS, Config.APPID, (String)codetypeMap.get(String.valueOf(type)), (String)lenMinMap.get(String.valueOf(type)), data);
                RedisUtil.cjyTotalAdd();
                JSONObject jsonObject = JSONObject.parseObject((String)msg);
                String err_str = jsonObject.getString("err_str");
                String code = jsonObject.getString("pic_str");
                XxlJobLogger.log((String)file.getAbsolutePath(), (Object[])new Object[0]);
                XxlJobLogger.log((String)(code + "=" + err_str), (Object[])new Object[0]);
                ThreadContext.put((String)(pluginName + "_vcodeValue"), (String)code);
                return code;
            }
        }
        catch (Throwable e) {
            XxlJobLogger.log((String)"get vcode error by datam2", (Object[])new Object[]{e});
        }
        return null;
    }

    public static String getVcodeByDama2(WebClient webClient, int type, int timeout, String url) {
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        try {
            Page page = webClient.getPage(url);
            if (page != null) {
                File file = new File(FileUtils.getTempDirectory(), UUID.randomUUID().toString());
                InputStream inputStream = page.getWebResponse().getContentAsStream();
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                IOUtils.copy((InputStream)inputStream, (OutputStream)byteArrayOutputStream);
                byte[] data = byteArrayOutputStream.toByteArray();
                FileUtils.writeByteArrayToFile((File)file, (byte[])data);
                String pluginName = ThreadContext.get((String)"pluginName");
                ThreadContext.put((String)(pluginName + "_vcodePath"), (String)file.getAbsolutePath());
                HashMap<String, String> codetypeMap = new HashMap<String, String>();
                codetypeMap.put("42", "1902");
                codetypeMap.put("53", "1005");
                codetypeMap.put("54", "1006");
                codetypeMap.put("55", "6001");
                HashMap<String, String> lenMinMap = new HashMap<String, String>();
                lenMinMap.put("42", "4");
                lenMinMap.put("53", "5");
                lenMinMap.put("54", "6");
                lenMinMap.put("55", "0");
                String msg = ChaoJiYing.PostPic(Config.UNAME, Config.UPASS, Config.APPID, (String)codetypeMap.get(String.valueOf(type)), (String)lenMinMap.get(String.valueOf(type)), data);
                RedisUtil.cjyTotalAdd();
                JSONObject jsonObject = JSONObject.parseObject((String)msg);
                String err_str = jsonObject.getString("err_str");
                String code = jsonObject.getString("pic_str");
                XxlJobLogger.log((String)file.getAbsolutePath(), (Object[])new Object[0]);
                XxlJobLogger.log((String)(code + "=" + err_str), (Object[])new Object[0]);
                ThreadContext.put((String)(pluginName + "_vcodeValue"), (String)code);
                return code;
            }
        }
        catch (Throwable e) {
            XxlJobLogger.log((String)"get vcode error by datam2", (Object[])new Object[]{e});
        }
        return null;
    }

    public static String decode(WebClient webClient, String type, String url) {
        String captcha = CaptchaUtil.getString(webClient, type, url, "");
        if (StringUtils.isEmpty((CharSequence)captcha)) {
            for (int index = IntConstant.ZERO; index < IntConstant.FIVE; ++index) {
                if ((captcha = CaptchaUtil.getString(webClient, type, url, captcha)) == null || captcha.length() <= 0) continue;
                return captcha;
            }
        }
        assert (captcha != null);
        if (captcha.contains("#")) {
            CaptchaUtil.decode(webClient, type, url);
        }
        return captcha;
    }

    private static String getString(WebClient webClient, String type, String url, String captcha) {
        int count = IntConstant.ZERO;
        int i = IntConstant.ZERO;
        Page page = null;
        try {
            page = webClient.getPage(url);
            while (count == IntConstant.ZERO) {
                Thread.sleep(IntConstant.ONE_THOUSAND);
                count = page.getWebResponse().getContentAsStream().available();
                if (i >= IntConstant.THREE && count == IntConstant.ZERO) {
                    XxlJobLogger.log((String)"\u7b2c{}\u6b21\u9a8c\u8bc1\u7801\u56fe\u7247\u8bf7\u6c42{}", (Object[])new Object[]{i, url});
                    page = webClient.getPage(url);
                    break;
                }
                ++i;
            }
            XxlJobLogger.log((String)"\u9a8c\u8bc1\u7801\u56fe\u7247\u8bf7\u6c42{} \u56fe\u7247Size={}/Bit", (Object[])new Object[]{url, count});
            captcha = CaptchaUtil.decode(page, type);
        }
        catch (FailingHttpStatusCodeException e) {
            XxlJobLogger.log((String)"\u8bc1\u7801\u56fe\u7247\u8bf7\u6c42{},FailingHttpStatusCodeException-\u5f02\u5e38{}", (Object[])new Object[]{url, e.getMessage()});
            captcha = "";
        }
        catch (MalformedURLException e) {
            XxlJobLogger.log((String)"\u8bc1\u7801\u56fe\u7247\u8bf7\u6c42{},MalformedURLException-\u5f02\u5e38{}", (Object[])new Object[]{url, e.getMessage()});
            captcha = "";
        }
        catch (IOException e) {
            XxlJobLogger.log((String)"\u91cd\u8bd5\u9a8c\u8bc1\u7801\u56fe\u7247\u8bf7\u6c42{}\uff0cIOException-\u5f02\u5e38{},", (Object[])new Object[]{url, e.getMessage()});
            try {
                Thread.sleep(IntConstant.TWO_THOUSAND);
                captcha = "";
            }
            catch (InterruptedException e2) {
                XxlJobLogger.log((String)"\u91cd\u8bd5\u9a8c\u8bc1\u7801\u56fe\u7247\u8bf7\u6c42{} InterruptedException-\u5f02\u5e38{},", (Object[])new Object[]{url, e2.getMessage()});
            }
        }
        catch (InterruptedException e) {
            captcha = "";
            e.printStackTrace();
        }
        return captcha;
    }

    public static String decode(Page page, String type) {
        try {
            for (int i = IntConstant.ZERO; i < POWERE2E_RETRY; ++i) {
                InputStream inputStream = page.getWebResponse().getContentAsStream();
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                IOUtils.copy((InputStream)inputStream, (OutputStream)byteArrayOutputStream);
                byte[] imgByteArr = byteArrayOutputStream.toByteArray();
                OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder();
                clientBuilder.readTimeout((long)IntConstant.FOUR_HUNDRED, TimeUnit.SECONDS);
                clientBuilder.connectTimeout((long)IntConstant.SIXTY, TimeUnit.SECONDS);
                clientBuilder.writeTimeout((long)IntConstant.SIXTY, TimeUnit.SECONDS);
                OkHttpClient client = clientBuilder.build();
                MultipartBody requestBody = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("file", type, RequestBody.create((MediaType)MediaType.parse((String)"text/plain; charset=utf-8"), (byte[])imgByteArr)).build();
                Request request = new Request.Builder().url(ORIGIN_URL).post((RequestBody)requestBody).build();
                Response response = client.newCall(request).execute();
                RedisUtil.e2eTotalAdd();
                assert (response.body() != null);
                JSONObject jsonObject = JSONObject.parseObject((String)response.body().string());
                if (jsonObject.get((Object)"value") != null) {
                    XxlJobLogger.log((String)"\u5546\u8054\u8bc6\u522b\u9a8c\u8bc1\u7801=".concat(jsonObject.get((Object)"value").toString()), (Object[])new Object[0]);
                    return jsonObject.get((Object)"value").toString();
                }
                try {
                    Thread.sleep(IntConstant.ONE_THOUSAND);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            if (e.getMessage().contains("<html>")) {
                XxlJobLogger.log((String)"\u5546\u8054\u9a8c\u8bc1\u7801\u670d\u52a1\u5f02\u5e38\uff01{}", (Object[])new Object[]{HtmlStrUtil.html2Text(e.getMessage(), "<[^>]+>")});
            }
            XxlJobLogger.log((String)"\u5546\u8054\u9a8c\u8bc1\u7801\u670d\u52a1\u5f02\u5e38\uff01{}", (Object[])new Object[]{e.getMessage()});
        }
        try {
            for (int j = IntConstant.ZERO; j < CHAOJIYING_RETRY; ++j) {
                String code_ = CaptchaUtil.getVcodeByDama2(page, 42, 60000);
                if (StringUtils.isNotBlank((CharSequence)code_)) {
                    XxlJobLogger.log((String)"\u8d85\u7ea7\u9e70\u8bc6\u522b\u9a8c\u8bc1\u7801=".concat(code_), (Object[])new Object[0]);
                    return code_;
                }
                try {
                    Thread.sleep(IntConstant.ONE_THOUSAND);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            XxlJobLogger.log((String)"\u8d85\u7ea7\u9e70\u9a8c\u8bc1\u7801\u670d\u52a1\u5f02\u5e38\uff01", (Object[])new Object[0]);
        }
        return null;
    }

    public static String sliderDecode(String accountName, String accountPassword, String customer, String url) {
        for (int i = 0; i < 1; ++i) {
            XxlJobLogger.log((String)"\u9a8c\u8bc1\u7801\u91cd\u8bd5{}", (Object[])new Object[]{i + 1});
            try {
                OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder();
                clientBuilder.readTimeout((long)IntConstant.FOUR_HUNDRED, TimeUnit.SECONDS);
                clientBuilder.connectTimeout((long)IntConstant.SIXTY, TimeUnit.SECONDS);
                clientBuilder.writeTimeout((long)IntConstant.SIXTY, TimeUnit.SECONDS);
                OkHttpClient okHttpClient = clientBuilder.build();
                JSONObject jsonBody = new JSONObject();
                JSONObject data = new JSONObject();
                jsonBody.put("username", (Object)accountName);
                jsonBody.put("password", (Object)accountPassword);
                jsonBody.put("customer", (Object)customer);
                jsonBody.put("url", (Object)url);
                data.put("data", (Object)jsonBody);
                XxlJobLogger.log((String)data.toJSONString(), (Object[])new Object[0]);
                RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)data.toJSONString());
                Request request = new Request.Builder().url(SLIDER_URL).post(requestBody).build();
                Response response = okHttpClient.newCall(request).execute();
                RedisUtil.e2eTotalAdd();
                assert (response.body() != null);
                String result = response.body().string();
                XxlJobLogger.log((String)"\u9a8c\u8bc1\u7801:{}", (Object[])new Object[]{result});
                return result;
            }
            catch (Exception e) {
                XxlJobLogger.log((String)"\u9a8c\u8bc1\u7801\u670d\u52a1\u5f02\u5e38\uff01{}", (Object[])new Object[]{e.getMessage()});
                continue;
            }
        }
        return null;
    }

    public static String decode(InputStream inputStream, String type) {
        try {
            for (int i = 0; i < 3; ++i) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                IOUtils.copy((InputStream)inputStream, (OutputStream)byteArrayOutputStream);
                byte[] imgByteArr = byteArrayOutputStream.toByteArray();
                OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder();
                clientBuilder.readTimeout((long)IntConstant.FOUR_HUNDRED, TimeUnit.SECONDS);
                clientBuilder.connectTimeout((long)IntConstant.SIXTY, TimeUnit.SECONDS);
                clientBuilder.writeTimeout((long)IntConstant.SIXTY, TimeUnit.SECONDS);
                OkHttpClient client = clientBuilder.build();
                MultipartBody requestBody = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("file", type, RequestBody.create((MediaType)MediaType.parse((String)"text/plain; charset=utf-8"), (byte[])imgByteArr)).build();
                Request request = new Request.Builder().url(ORIGIN_URL).post((RequestBody)requestBody).build();
                Response response = client.newCall(request).execute();
                RedisUtil.e2eTotalAdd();
                assert (response.body() != null);
                JSONObject jsonObject = JSONObject.parseObject((String)response.body().string());
                if (jsonObject.get((Object)"value") != null) {
                    XxlJobLogger.log((String)"\u5546\u8054\u8bc6\u522b\u9a8c\u8bc1\u7801=".concat(jsonObject.get((Object)"value").toString()), (Object[])new Object[0]);
                    return jsonObject.get((Object)"value").toString();
                }
                try {
                    Thread.sleep(IntConstant.ONE_THOUSAND);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            if (e.getMessage().contains("<html>")) {
                XxlJobLogger.log((String)"\u5546\u8054\u9a8c\u8bc1\u7801\u670d\u52a1\u5f02\u5e38\uff01{}", (Object[])new Object[]{HtmlStrUtil.html2Text(e.getMessage(), "<[^>]+>")});
            }
            XxlJobLogger.log((String)"\u5546\u8054\u9a8c\u8bc1\u7801\u670d\u52a1\u5f02\u5e38\uff01{}", (Object[])new Object[]{e.getMessage()});
        }
        try {
            for (int j = IntConstant.ZERO; j < CHAOJIYING_RETRY; ++j) {
                String code_ = CaptchaUtil.getVcodeByDama2(inputStream, 42, 60000);
                if (StringUtils.isNotBlank((CharSequence)code_)) {
                    XxlJobLogger.log((String)"\u8d85\u7ea7\u9e70\u8bc6\u522b\u9a8c\u8bc1\u7801=".concat(code_), (Object[])new Object[0]);
                    return code_;
                }
                try {
                    Thread.sleep(IntConstant.ONE_THOUSAND);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            XxlJobLogger.log((String)"\u8d85\u7ea7\u9e70\u9a8c\u8bc1\u7801\u670d\u52a1\u5f02\u5e38\uff01", (Object[])new Object[0]);
        }
        return null;
    }

    public static String getVcodeByDama2(InputStream inputStream, int type, int timeout) {
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        try {
            File file = new File(FileUtils.getTempDirectory(), UUID.randomUUID().toString());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)inputStream, (OutputStream)byteArrayOutputStream);
            byte[] data = byteArrayOutputStream.toByteArray();
            FileUtils.writeByteArrayToFile((File)file, (byte[])data);
            String pluginName = ThreadContext.get((String)"pluginName");
            ThreadContext.put((String)(pluginName + "_vcodePath"), (String)file.getAbsolutePath());
            HashMap<String, String> codetypeMap = new HashMap<String, String>();
            codetypeMap.put("42", "1902");
            codetypeMap.put("53", "1005");
            codetypeMap.put("54", "1006");
            codetypeMap.put("55", "6001");
            codetypeMap.put("50", "5000");
            HashMap<String, String> lenMinMap = new HashMap<String, String>();
            lenMinMap.put("42", "4");
            lenMinMap.put("53", "5");
            lenMinMap.put("54", "6");
            lenMinMap.put("55", "0");
            lenMinMap.put("50", "5");
            String msg = ChaoJiYing.PostPic(Config.UNAME, Config.UPASS, Config.APPID, (String)codetypeMap.get(String.valueOf(type)), (String)lenMinMap.get(String.valueOf(type)), data);
            RedisUtil.cjyTotalAdd();
            JSONObject jsonObject = JSONObject.parseObject((String)msg);
            String err_str = jsonObject.getString("err_str");
            String code = jsonObject.getString("pic_str");
            XxlJobLogger.log((String)file.getAbsolutePath(), (Object[])new Object[0]);
            XxlJobLogger.log((String)(code + "=" + err_str), (Object[])new Object[0]);
            ThreadContext.put((String)(pluginName + "_vcodeValue"), (String)code);
            return code;
        }
        catch (Throwable e) {
            XxlJobLogger.log((String)"get vcode error by datam2", (Object[])new Object[]{e});
            return null;
        }
    }

    public static String captchaPlus(String fileBase64, String codeType, String accountId, String captchaType) {
        String result = null;
        try {
            CaptchaResponse captchaResponse;
            HashMap<String, Object> headers = new HashMap<String, Object>();
            headers.put("Authentication", HttpConfig.getConfig((String)"common.authentication"));
            headers.put("action", HttpConfig.getConfig((String)"captcha.action"));
            headers.put("serialNo", CommonDataHelper.ACCOUNT_NAME_MAP.getOrDefault(accountId, accountId));
            captchaType = StringUtils.isBlank((CharSequence)captchaType) ? CAPTCHA_INNER_TYPE : captchaType;
            HashMap<String, String> bodyMap = new HashMap<String, String>();
            bodyMap.put("fileBase64", fileBase64);
            bodyMap.put("codeType", codeType);
            bodyMap.put("preProcess", "false");
            bodyMap.put("type", captchaType);
            bodyMap.put("accountId", accountId);
            bodyMap.put("lenMin", lenMinMap.getOrDefault(codeType, "0"));
            JanusHttpUtil.ResponseCus responseCus = JanusHttpUtil.doPostJsonEntire((String)BaseUtils.JANUS_URL, (String)JacksonUtil.getInstance().toJson(bodyMap), headers, new HashMap());
            if (null == responseCus || !Objects.equals(responseCus.getStatus(), 200)) {
                return result;
            }
            result = responseCus.getBody();
            if (StringUtils.isNotBlank((CharSequence)result) && null != (captchaResponse = (CaptchaResponse)JacksonUtil.getInstance().fromJson(result, CaptchaResponse.class))) {
                String discernResult = captchaResponse.getDiscernResult();
                if (StringUtils.isNotBlank((CharSequence)discernResult)) {
                    JSONObject codeObject = JSONObject.parseObject((String)(discernResult = StringEscapeUtils.unescapeJava((String)discernResult)));
                    if (null == codeObject || !codeObject.containsKey((Object)"pic_str")) {
                        return result;
                    }
                    return codeObject.getString("pic_str");
                }
                return captchaResponse.getDiscernResult();
            }
        }
        catch (Exception e) {
            XxlJobLogger.log((String)("\u83b7\u53d6\u9a8c\u8bc1\u7801\u5f02\u5e38:" + ErrorUtil.getStackMsg((Exception)e)), (Object[])new Object[0]);
        }
        return result;
    }

    public static String captchaPlus(String fileBase64, String codeType, String accountId, String captchaType, int lenMin) {
        String result = null;
        try {
            CaptchaResponse captchaResponse;
            HashMap<String, Object> headers = new HashMap<String, Object>();
            headers.put("Authentication", HttpConfig.getConfig((String)"common.authentication"));
            headers.put("action", HttpConfig.getConfig((String)"captcha.action"));
            headers.put("serialNo", CommonDataHelper.ACCOUNT_NAME_MAP.getOrDefault(accountId, accountId));
            captchaType = StringUtils.isBlank((CharSequence)captchaType) ? CAPTCHA_INNER_TYPE : captchaType;
            HashMap<String, String> bodyMap = new HashMap<String, String>();
            bodyMap.put("fileBase64", fileBase64);
            bodyMap.put("codeType", codeType);
            bodyMap.put("preProcess", "false");
            bodyMap.put("type", captchaType);
            bodyMap.put("accountId", accountId);
            bodyMap.put("lenMin", lenMin + "");
            JanusHttpUtil.ResponseCus responseCus = JanusHttpUtil.doPostJsonEntire((String)BaseUtils.JANUS_URL, (String)JacksonUtil.getInstance().toJson(bodyMap), headers, new HashMap());
            if (null == responseCus || !Objects.equals(responseCus.getStatus(), 200)) {
                return result;
            }
            result = responseCus.getBody();
            if (StringUtils.isNotBlank((CharSequence)result) && null != (captchaResponse = (CaptchaResponse)JacksonUtil.getInstance().fromJson(result, CaptchaResponse.class))) {
                String discernResult = captchaResponse.getDiscernResult();
                if (StringUtils.isNotBlank((CharSequence)discernResult)) {
                    JSONObject codeObject = JSONObject.parseObject((String)(discernResult = StringEscapeUtils.unescapeJava((String)discernResult)));
                    if (null == codeObject || !codeObject.containsKey((Object)"pic_str")) {
                        return result;
                    }
                    return codeObject.getString("pic_str");
                }
                return captchaResponse.getDiscernResult();
            }
        }
        catch (Exception e) {
            XxlJobLogger.log((String)("\u83b7\u53d6\u9a8c\u8bc1\u7801\u5f02\u5e38:" + ErrorUtil.getStackMsg((Exception)e)), (Object[])new Object[0]);
        }
        return result;
    }

    public static String captchaHandle(String accountId, String marketAccountId, String startTime, String captchaType) {
        String result = null;
        try {
            CaptchaResponse captchaResponse;
            HashMap<String, Object> headers = new HashMap<String, Object>();
            headers.put("Authentication", HttpConfig.getConfig((String)"common.authentication"));
            headers.put("action", HttpConfig.getConfig((String)"captcha.action"));
            headers.put("serialNo", "sms" + accountId);
            HashMap<String, String> bodyMap = new HashMap<String, String>();
            bodyMap.put("preProcess", "false");
            bodyMap.put("fileBase64", captchaType);
            bodyMap.put("type", "handle");
            bodyMap.put("captchaType", captchaType);
            bodyMap.put("accountId", accountId);
            bodyMap.put("marketAccountId", marketAccountId);
            bodyMap.put("startTime", startTime);
            JanusHttpUtil.ResponseCus responseCus = JanusHttpUtil.doPostJsonEntire((String)BaseUtils.JANUS_URL, (String)JacksonUtil.getInstance().toJson(bodyMap), headers, new HashMap());
            if (null == responseCus || !Objects.equals(responseCus.getStatus(), 200)) {
                return result;
            }
            result = responseCus.getBody();
            if (StringUtils.isNotBlank((CharSequence)result) && null != (captchaResponse = (CaptchaResponse)JacksonUtil.getInstance().fromJson(result, CaptchaResponse.class))) {
                return captchaResponse.getDiscernResult();
            }
        }
        catch (Exception e) {
            XxlJobLogger.log((String)("\u83b7\u53d6\u9a8c\u8bc1\u7801\u5f02\u5e38:" + ErrorUtil.getStackMsg((Exception)e)), (Object[])new Object[0]);
        }
        return "";
    }

    public static String convertToBase64(InputStream inputStream) throws IOException {
        int bytesRead;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[8192];
        while ((bytesRead = inputStream.read(buffer)) != -1) {
            outputStream.write(buffer, 0, bytesRead);
        }
        return Base64.getEncoder().encodeToString(outputStream.toByteArray());
    }

    public static void main(String[] args) {
        String imageData = "R0lGODdhZAAyANUAAP+ZzP///5mZZjMzAAAAAP///39/f////39/f/+y2P/Y6/+/3//M5f/l8v+l0v/y+L+/v6+Im7+Mpb+fr6+SoN/V2d+SuN/B0O+304+CiM+Pr6+vr8/Pz4+KjJ+Fku+Vwu/v79/L1c+vvr+lsp+SmI+Pj4+Fit/f38+etp+fnwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACwAAAAAZAAyAAAG/sCAcEgsGo/IpHLJbCIFAYB0Sq1ar9isdsvtXgdRr3hMLpPB5rR6PUaz33C4O06vi+f2vL6K3/vtfX+Cb4GDhmaFh4peiYuOWY2PklSRk5NoCQWam5sKUpycDlYOD5oMUw4KpQUNC5aQUZmgnQAOs5qiVQ2bpwCyoL2vfLGcEAbHyMnKyBFSCgUgy9LHzV0eyhpYHxoRGcgZHhEWW4ES0+cGzQyaIejK1VsRy9lW5ugZ41iBE+7SEQumRPRjxsUeNivyBuaz0seBsYHJKGjyNAJiui0aptGbkhFiBn1hpih4aNFAhQKeAJCwCO+KhXMbpXhLhg/Ah2vKFlIKWWtT/i4pCRYscPBS2QVQJZRVIWVKS1GNVDom+zDlw7wvPAGyopLgQSkMM5FpeMZJmQmvBVwxRZnlQ1gDbw3EtGlBQgQPHqpcZchzV4FgUlZtUEYBAFlNJ96tmuUKy1sPUo/N1RL5GFW+VFY1npKJg7IOVypHQJEiqYESG040yILzWIZtB7nAfgcS1aYEozrkvGLQXUsqCZFRrTzZStxjeWt36W0gOUKLzqcwz0eciz8tlaRY3X3lOLqW1aWE1zKtJtblyqJXieth3AfmlqU8pRY1dlt0xbMDWKbTygcLGkggQRXwDbgdMuqNp417lcU3DBeVfZTGgQQ1CFFx9ey1Exet5NGnBnsAWDgQhlVQ6OGGW/C3xjLNiNhPNv8F2I16+9H2IGXLUGbXXRlIWNUyA7roTjbBCUeFiQYMeGMWRTanRZMG6ATfcCUlk818xygpBXz9AVBJh0k6JY0GH7zHohcKAnCcBGXC5yOKWWiIBZTnvIamffKV1KWXPPmn4hZgnrMnFmmGCJGWS4a2zGVbwJceo10UCoAF3n0zKJ9awCfGNt3MBI44ZUgqXjc0RUCiFPoJc0iqqg7Caqt/vArrHrLOmketttaBa65x7MorIX3+uqoAAxRr7LHIJqvsssw26+yz0C4bBAA7";
        byte[] imageBytes = Base64.getDecoder().decode(imageData);
        try (ByteArrayInputStream bis = new ByteArrayInputStream(imageBytes);){
            BufferedImage image = ImageIO.read(bis);
            File outputfile = new File("/Users/gongjianfeng/Downloads/FLDownload/output6.png");
            ImageIO.write((RenderedImage)image, "png", outputfile);
            System.out.println("\u56fe\u7247\u5df2\u4fdd\u5b58\u5230 " + outputfile.getAbsolutePath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        lenMinMap.put("1902", "4");
        lenMinMap.put("1005", "5");
        lenMinMap.put("1006", "6");
        lenMinMap.put("6001", "0");
        lenMinMap.put("5000", "5");
    }
}

