/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.core.process;

import com.xforceplus.apollo.utils.ErrorUtil;
import com.xforceplus.janus.config.core.config.HttpConfig;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XxlJobLogHandler {
    private static final Logger log = LoggerFactory.getLogger(XxlJobLogHandler.class);
    private static volatile XxlJobLogHandler xxlJobLogHandler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static XxlJobLogHandler getInstance() {
        if (null != xxlJobLogHandler) return xxlJobLogHandler;
        Class<XxlJobLogHandler> clazz = XxlJobLogHandler.class;
        synchronized (XxlJobLogHandler.class) {
            if (null != xxlJobLogHandler) return xxlJobLogHandler;
            xxlJobLogHandler = new XxlJobLogHandler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return xxlJobLogHandler;
        }
    }

    private XxlJobLogHandler() {
        new Thread(() -> {
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(900000L);
                        this.doHandler();
                    }
                }
                catch (Exception e) {
                    log.error(ErrorUtil.getStackMsg((Exception)e));
                    continue;
                }
                catch (Error error) {
                    log.error(ErrorUtil.getStackMsg((Throwable)error));
                    continue;
                }
                break;
            }
        }).start();
    }

    protected void doHandler() throws IOException {
        String appLogsPath = "/data/applogs/xforceplus-job/jobhandler";
        long maxSizeBytes = 0x5A00000L;
        long targetSizeBytes = 0x3200000L;
        String maxSizeCfg = (String)HttpConfig.getConfig((String)"log.max.size");
        String targetSizeCfg = (String)HttpConfig.getConfig((String)"log.target.size");
        String appLogsPathCfg = (String)HttpConfig.getConfig((String)"xxl.job.log.dir");
        if (StringUtils.isNotBlank((CharSequence)appLogsPathCfg)) {
            appLogsPath = appLogsPathCfg;
        }
        try {
            if (StringUtils.isNotBlank((CharSequence)maxSizeCfg) && StringUtils.isNumeric((CharSequence)maxSizeCfg)) {
                maxSizeBytes = Math.max(maxSizeBytes, Long.parseLong(maxSizeCfg) * 1024L * 1024L);
            }
            if (StringUtils.isNotBlank((CharSequence)targetSizeCfg) && StringUtils.isNumeric((CharSequence)targetSizeCfg)) {
                targetSizeBytes = Math.max(targetSizeBytes, Long.parseLong(targetSizeCfg) * 1024L * 1024L);
            }
        }
        catch (Exception e) {
            log.error(ErrorUtil.getStackMsg((Exception)e));
        }
        List<Path> dateFolders = XxlJobLogHandler.getSortedDateFolders(appLogsPath);
        long totalSizeBytes = XxlJobLogHandler.calculateTotalSize(dateFolders);
        if (totalSizeBytes > maxSizeBytes) {
            log.info(String.format("\u5f53\u524d\u5927\u5c0f: %.2f MB (\u8d85\u8fc7\u9608\u503c %.2f MB)\uff0c\u5f00\u59cb\u6e05\u7406...", XxlJobLogHandler.bytesToMB(totalSizeBytes), XxlJobLogHandler.bytesToMB(maxSizeBytes)));
            for (Path folder : dateFolders) {
                if (totalSizeBytes <= targetSizeBytes) break;
                long folderSize = XxlJobLogHandler.calculateFolderSize(folder);
                XxlJobLogHandler.deleteFolder(folder);
                log.info(String.format("\u5df2\u5220\u9664: %s (%.2f MB)\uff0c\u5269\u4f59: %.2f MB", folder.getFileName(), XxlJobLogHandler.bytesToMB(folderSize), XxlJobLogHandler.bytesToMB(totalSizeBytes -= folderSize)));
            }
            log.info(String.format("\u6e05\u7406\u5b8c\u6210\uff0c\u6700\u7ec8\u5927\u5c0f: %.2f MB", XxlJobLogHandler.bytesToMB(totalSizeBytes)));
        } else {
            log.info(String.format("\u5f53\u524d\u5927\u5c0f: %.2f MB (\u672a\u8d85\u8fc7\u9608\u503c %.2f MB)\uff0c\u65e0\u9700\u6e05\u7406", XxlJobLogHandler.bytesToMB(totalSizeBytes), XxlJobLogHandler.bytesToMB(maxSizeBytes)));
        }
    }

    private static List<Path> getSortedDateFolders(String basePath) throws IOException {
        try (Stream<Path> folders = Files.list(Paths.get(basePath, new String[0]));){
            List<Path> list = folders.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).sorted(Comparator.comparing(Path::getFileName)).collect(Collectors.toList());
            return list;
        }
    }

    private static long calculateTotalSize(List<Path> folders) throws IOException {
        long totalSize = 0L;
        for (Path folder : folders) {
            totalSize += XxlJobLogHandler.calculateFolderSize(folder);
        }
        return totalSize;
    }

    private static long calculateFolderSize(Path path) throws IOException {
        return Files.walk(path, new FileVisitOption[0]).filter(p -> p.toFile().isFile()).mapToLong(p -> p.toFile().length()).sum();
    }

    private static void deleteFolder(Path path) throws IOException {
        Files.walk(path, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).forEach(p -> {
            try {
                Files.deleteIfExists(p);
            }
            catch (IOException e) {
                System.err.println("\u5220\u9664\u5931\u8d25: " + p);
            }
        });
    }

    private static double bytesToMB(long bytes) {
        return (double)bytes / 1048576.0;
    }

    public static void main(String[] args) {
        XxlJobLogHandler.getInstance();
    }
}

