/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.utils.warn.sender;

import com.alibaba.fastjson.JSONArray;
import com.xforceplus.account.domain.AccountTemplateDO;
import com.xforceplus.core.enums.RetailConstantEnum;
import com.xforceplus.core.enums.SupplierConstantEnum;
import com.xforceplus.core.message.WarningMessageBo;
import com.xforceplus.core.message.constant.Developer;
import com.xforceplus.core.message.constant.Platform;
import com.xforceplus.core.message.constant.PlatformMenu;
import com.xforceplus.core.message.constant.PlatformModules;
import com.xforceplus.core.message.constant.PlatformService;
import com.xforceplus.core.message.constant.SendChannel;
import com.xforceplus.core.message.constant.WarnType;
import com.xforceplus.lock.redisson.RedissonLock;
import com.xforceplus.utils.DateUtils;
import com.xforceplus.utils.Sha256Utils;
import com.xforceplus.utils.warn.sender.SendWarnMessage;
import com.xxl.job.core.log.XxlJobLogger;
import com.xxl.rpc.util.IpUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.redisson.api.RBucket;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class QueryCodeProcesser {
    private static final String QUERY_PHONECODE_SUFFIX = "job:queryphonecode:";
    private static final String QUERY_PHONECODE_TOKEN_SUFFIX = "job:querycodetoken:";
    @Autowired
    SendWarnMessage sendWarnMessage;
    @Autowired
    RedissonLock redissonLock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void queryCode(AccountTemplateDO account) {
        String key;
        boolean lock;
        block20: {
            block19: {
                block18: {
                    XxlJobLogger.log((String)"\u89e6\u53d1\u83b7\u53d6\u5ba2\u6237\u9a8c\u8bc1\u7801", (Object[])new Object[0]);
                    lock = false;
                    key = null;
                    String projectKey = account.getProjectKey();
                    String retailKey = account.getRetailKey();
                    String accountName = account.getAccountName();
                    int sendCountLimit = 9999;
                    int sendSpace = 10;
                    int expireTime = 60;
                    try {
                        int count;
                        Map<String, String> postParam = account.getPostParam();
                        if (postParam != null && !postParam.isEmpty()) {
                            if (postParam.containsKey("sendCountLimit")) {
                                sendCountLimit = Integer.parseInt(postParam.get("sendCountLimit"));
                            }
                            if (postParam.containsKey("sendSpace")) {
                                sendSpace = Integer.parseInt(postParam.get("sendSpace"));
                            }
                            if (postParam.containsKey("expireTime")) {
                                expireTime = Integer.parseInt(postParam.get("expireTime"));
                            }
                        }
                        key = QUERY_PHONECODE_SUFFIX + projectKey + "-" + retailKey + "-" + accountName;
                        lock = this.redissonLock.lock(key);
                        XxlJobLogger.log((String)"\u9a8c\u8bc1\u7801\u52a0\u9501\uff0cRedissonKey={},Status={}.", (Object[])new Object[]{key, lock});
                        if (!lock) {
                            if (!lock) return;
                            this.redissonLock.release(key);
                            return;
                        }
                        Map<String, Object> tokenMap = new HashMap<String, Object>();
                        tokenMap.put("projectKey", projectKey);
                        tokenMap.put("retailKey", retailKey);
                        tokenMap.put("accountName", accountName);
                        String token = Sha256Utils.getSignCommon(tokenMap, null);
                        RBucket cacheKey = this.redissonLock.getRedissonManager().getRedisson().getBucket(QUERY_PHONECODE_TOKEN_SUFFIX + token);
                        if (cacheKey.get() == null) {
                            count = 1;
                            tokenMap.put("sendCount", count);
                            tokenMap.put("lastSendTime", System.currentTimeMillis());
                            tokenMap.put("updateStatus", 0);
                            cacheKey.set(tokenMap);
                            cacheKey.expire((long)expireTime, TimeUnit.MINUTES);
                        } else {
                            tokenMap = (Map)cacheKey.get();
                            count = (Integer)tokenMap.get("sendCount");
                            if (count >= sendCountLimit) {
                                XxlJobLogger.log((String)"\u5f53\u5929\u53d1\u9001\u6b21\u6570\u5df2\u8d85\u8fc7{}\u6b21", (Object[])new Object[]{sendCountLimit});
                                if (!lock) return;
                                break block18;
                            }
                            long lastSendTime = (Long)tokenMap.get("lastSendTime");
                            long secondTime = sendSpace * 60 * 1000;
                            long differ = System.currentTimeMillis() - lastSendTime;
                            if (secondTime > differ) {
                                XxlJobLogger.log((String)"\u53d1\u9001\u65f6\u95f4\u95f4\u9694\u4e0d\u6ee1{}\u5206\u949f\u6216\u521d\u59cb\u5316\u767b\u9646\uff0c\u4e0d\u53d1\u9001\u5546\u8054\u77ed\u4fe1,\u9000\u51fa", (Object[])new Object[]{sendSpace});
                                if (!lock) return;
                                break block19;
                            }
                            tokenMap.put("updateStatus", 0);
                            tokenMap.put("sendCount", ++count);
                            tokenMap.put("lastSendTime", System.currentTimeMillis());
                            cacheKey.set(tokenMap);
                        }
                        WarningMessageBo warningMessage = new WarningMessageBo();
                        warningMessage.setPlatform(Platform.DCS.getIndex());
                        warningMessage.setIp(IpUtil.getIp());
                        warningMessage.setService(PlatformService.BILLS.getIndex());
                        warningMessage.setModules(PlatformModules.ORDERCONTER.getIndex());
                        warningMessage.setMenuOrButton(PlatformMenu.ZZ.getIndex());
                        warningMessage.setSendChannel(SendChannel.SMS.getIndex());
                        warningMessage.setDeveloper(Developer.LIZEHENG.getIndex());
                        warningMessage.setWarnType(WarnType.CERTIFICATION_CODE.getIndex());
                        warningMessage.setSupplier(SupplierConstantEnum.OTHER.getIndex());
                        String storeName = RetailConstantEnum.geLabelByKey(retailKey);
                        Long mobilePhone = account.getMobilePhone();
                        String codeUrl = "powere2e-job-admin/query_code?token=" + token + "&phonecode=";
                        XxlJobLogger.log((String)"\u9a8c\u8bc1\u7801\u94fe\u63a5\u4e3a:{}", (Object[])new Object[]{codeUrl});
                        JSONArray array = new JSONArray();
                        array.add((Object)storeName);
                        array.add((Object)accountName);
                        array.add((Object)codeUrl);
                        array.add((Object)(mobilePhone + ""));
                        warningMessage.setMsgText(array.toJSONString());
                        warningMessage.setMsgCreateTime(DateUtils.dateToLongString(new Date()));
                        warningMessage.setMessageAccepter(9999);
                        warningMessage.setCustomAccepter(mobilePhone + "");
                        this.sendWarnMessage.sendMessage(warningMessage);
                        if (!lock) return;
                        break block20;
                    }
                    catch (Exception e) {
                        XxlJobLogger.log((String)("\u51fa\u73b0\u5f02\u5e38" + ExceptionUtils.getMessage((Throwable)e)), (Object[])new Object[0]);
                        return;
                    }
                }
                this.redissonLock.release(key);
                return;
            }
            this.redissonLock.release(key);
            return;
        }
        this.redissonLock.release(key);
        return;
        finally {
            if (lock) {
                this.redissonLock.release(key);
            }
        }
    }

    private Object formatPwd(String pswd) {
        int length = pswd.length();
        if (length == 1) {
            return pswd;
        }
        if (length == 2) {
            return pswd.substring(0, 1) + "*";
        }
        if (length == 3) {
            return pswd.substring(0, 1) + "*" + pswd.substring(2);
        }
        int len = pswd.length() / 2;
        pswd = pswd.substring(0, len - 1) + "**" + pswd.substring(len + 1);
        return pswd;
    }
}

