/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.utils;

import com.xforceplus.core.enums.CharSetEnum;
import com.xxl.job.core.log.XxlJobLogger;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import org.mozilla.intl.chardet.nsDetector;
import org.mozilla.intl.chardet.nsICharsetDetectionObserver;

public class CodepageDetector {
    private boolean found = false;
    private String encoding = null;

    public static void main(String[] argv) throws Exception {
        File file1 = new File("C:\\Users\\easton\\Desktop\\YLF\u865a\u62df\u673a\u901a\u7528web-3\\iso-8859-1.html");
    }

    public String guessFileEncoding(File file) throws FileNotFoundException, IOException {
        return this.guessFileEncoding(file, new nsDetector());
    }

    private String guessFileEncoding(File file, nsDetector det) throws FileNotFoundException, IOException {
        int len;
        det.Init(new nsICharsetDetectionObserver(){

            public void Notify(String charset) {
                CodepageDetector.this.encoding = charset;
                CodepageDetector.this.found = true;
            }
        });
        BufferedInputStream imp = new BufferedInputStream(new FileInputStream(file));
        byte[] buf = new byte[1024];
        boolean done = false;
        boolean isAscii = false;
        while ((len = imp.read(buf, 0, buf.length)) != -1 && !(isAscii = det.isAscii(buf, len)) && !(done = det.DoIt(buf, len, false))) {
        }
        imp.close();
        det.DataEnd();
        if (isAscii) {
            this.encoding = "ASCII";
            this.found = true;
        }
        if (!this.found) {
            String[] prob = det.getProbableCharsets();
            for (int i = 0; i < prob.length; ++i) {
                this.encoding = i == 0 ? prob[i] : this.encoding + "," + prob[i];
            }
            if (prob.length > 0) {
                return this.encoding;
            }
            return null;
        }
        return this.encoding;
    }

    public static boolean ChineseToUTF8(String filePath, String charSet) {
        try {
            try (FileInputStream fis = new FileInputStream(filePath);
                 InputStreamReader isr = new InputStreamReader((InputStream)fis, charSet);
                 BufferedReader br = new BufferedReader(isr);){
                String str;
                StringBuilder sb = new StringBuilder();
                while ((str = br.readLine()) != null) {
                    str = str + "\n";
                    sb.append(str);
                }
                String str2 = sb.toString();
                File file = new File(filePath);
                try (FileOutputStream fos = new FileOutputStream(file.getAbsolutePath(), false);
                     OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, CharSetEnum.UTF8.getCharSet());){
                    osw.write(str2);
                    osw.flush();
                }
            }
            return true;
        }
        catch (FileNotFoundException e) {
            XxlJobLogger.log((String)("FileNotFoundException:" + e.toString()), (Object[])new Object[0]);
            return false;
        }
        catch (UnsupportedEncodingException e) {
            XxlJobLogger.log((String)("UnsupportedEncodingException:" + e.toString()), (Object[])new Object[0]);
            return false;
        }
        catch (IOException e) {
            XxlJobLogger.log((String)("IOException:" + e.toString()), (Object[])new Object[0]);
            return false;
        }
    }
}

