/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.utils;

import com.xforceplus.core.enums.CharSetEnum;
import com.xxl.job.core.log.XxlJobLogger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class HtmlStrUtil {
    public static final String REGEX_SCRIPT = "(^(<script ([\\s\\S]*) />)?)|(<script ([\\s\\S]*?)>([\\s\\S]*?)</script>)|(<script>([\\s\\S]*?)</script>)";
    public static final String REGEX_STYLE = "(<style ([\\s\\S]*?)>([\\s\\S]*?)</style>)|(<style>([\\s\\S]*?)</style>)";
    public static final String REGEX_LINK = "(<link ([^>]*)>)|(<link ([^>]*)>.*</link>)";
    public static final String REGEX_IMG = "<((img)|(\\/?img .*?))>";
    public static final String REGEX_META = "<(meta(([\\s\\S]?)|(.*)).*?)>";
    public static final String REGEX_HEAD = "(^(<head ([\\s\\S]*) />)?)|(<head ([\\s\\S]*?)>([\\s\\S]*?)</head>)|(<head>([\\s\\S]*?)</head>)";
    public static final String HEAD_FLAG = "<head>";
    public static final String REGEX_SELECT = "(<select\\b[^<]*(?:(?!<\\/select>)<[^<]*)*<\\/select>)|(<((select)|(\\/?select .*?))>)|";
    public static final String REGEX_NOTE = "<!--(.|[\\r\\n])*?-->";
    public static final String[] CHARSET_FLAG = new String[]{CharSetEnum.UTF8.getCharSet(), CharSetEnum.GBK.getCharSet(), CharSetEnum.GB2312.getCharSet()};
    public static final String DEFAULT_CHARSET = CharSetEnum.UTF8.getCharSet();

    public static String replaceStyAndScrAndLinkAndImg(String htmlStr) {
        if (StringUtils.isBlank((CharSequence)htmlStr)) {
            return htmlStr;
        }
        String[] pattern = new String[]{REGEX_SCRIPT, REGEX_STYLE, REGEX_LINK, REGEX_IMG, REGEX_META};
        return HtmlStrUtil.html2Text(htmlStr, pattern);
    }

    public static String replaceLabelAndAddMeta(String htmlStr) {
        String str = HtmlStrUtil.replaceStyAndScrAndLinkAndImg(htmlStr);
        return HtmlStrUtil.checkHtmlEncoding(str);
    }

    public static String html2Text(String htmlStr, String ... pattern) {
        if (StringUtils.isBlank((CharSequence)htmlStr) || pattern == null) {
            return htmlStr;
        }
        String textStr = htmlStr;
        for (String pat : pattern) {
            textStr = HtmlStrUtil.patternStr(textStr, pat);
        }
        return textStr;
    }

    public static String checkHtmlEncoding(String htmlStr) {
        if (StringUtils.isBlank((CharSequence)htmlStr)) {
            return htmlStr;
        }
        Pattern pattern = Pattern.compile(REGEX_META, 2);
        Matcher match = pattern.matcher(htmlStr);
        boolean encoding = false;
        boolean b = match.find();
        while (b) {
            String text = match.group().replace(" ", "").replace("'", "\"").toLowerCase();
            for (String charset : CHARSET_FLAG) {
                boolean contains = text.contains("=\"".concat(charset.toLowerCase()).concat("\""));
                if (!contains) continue;
                encoding = true;
                break;
            }
            b = !encoding && match.find();
        }
        return HtmlStrUtil.addEncoding(htmlStr, encoding);
    }

    private static String addEncoding(String htmlStr, boolean encoding) {
        String text = "<meta charset=\"" + DEFAULT_CHARSET + "\">";
        if (!encoding) {
            int idx = htmlStr.toLowerCase().indexOf(HEAD_FLAG);
            if (idx >= 0) {
                text = htmlStr.substring(0, HEAD_FLAG.length() + idx).concat(text).concat(htmlStr.substring(HEAD_FLAG.length() + idx));
            } else {
                XxlJobLogger.log((String)"\u672a\u627e\u5230<head>\u6807\u7b7e\u6dfb\u52a0<head>\u7f16\u7801", (Object[])new Object[0]);
                String regex = "<html.*?>";
                Pattern patt = Pattern.compile(regex);
                Matcher match = patt.matcher(htmlStr);
                if (match.find()) {
                    String firstMatch = match.group();
                    text = htmlStr.replace(firstMatch, firstMatch + "<head><meta http-equiv=Content-Type content=\"text/html;charset=utf-8\"></head>");
                } else {
                    text = HEAD_FLAG.concat(text).concat("</head>").concat(htmlStr);
                }
            }
        } else {
            text = htmlStr;
        }
        return text;
    }

    public static String patternStr(String htmlStr, String patt) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{htmlStr, patt})) {
            return htmlStr;
        }
        Pattern pattern = Pattern.compile(patt, 2);
        Matcher match = pattern.matcher(htmlStr);
        return match.replaceAll("");
    }

    public static void main(String[] args) {
    }
}

