/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.gargoylesoftware.htmlunit.ProxyConfig;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.xforceplus.core.enums.IntConstant;
import com.xforceplus.lock.redisson.RedissonLock;
import com.xforceplus.utils.DateUtils;
import com.xforceplus.utils.WebClientUtil;
import com.xxl.job.core.log.XxlJobLogger;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.redisson.api.RBucket;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProxyConfigApi {
    @Autowired
    RedissonLock redissonLock;
    final String VALIDTOTAL_KEY = "job:ipproxy:valid_total";
    final String REQUESTTOTAL_KEY = "job:ipproxy:request_total";
    final String PROXYCONFIGMAP_KEY = "job:ipproxy:map_cache";
    final String CONCURRENCY_KEY = "job:ipproxy:concurrency";
    private String ip;
    private String port;

    public String getProxyIp() {
        this.getProxyIp(WebClientUtil.getWebClient(""));
        return this.ip + ":" + this.port;
    }

    public synchronized WebClient getProxyIp(WebClient webClient) {
        XxlJobLogger.log((String)"\u6839\u636eDCS\u91c7\u96c6\u914d\u7f6e,\u4f7f\u7528\u4ee3\u7406........", (Object[])new Object[0]);
        String proxyIp = "10.206.10.132";
        String proxyPort = "808";
        webClient.getOptions().setProxyConfig(new ProxyConfig(proxyIp, Integer.parseInt(proxyPort)));
        return webClient;
    }

    Map<String, Map<String, String>> setProxyConfig(WebClient webClient) throws Exception {
        boolean validCheck;
        boolean lock = this.redissonLock.lock("job:ipproxy:concurrency", IntConstant.SIXTY);
        XxlJobLogger.log((String)"\u52a0\u9501\uff0c\u9632\u6b62\u5e76\u53d1\u8bf7\u6c42\u6781\u5149IP\u4ee3\u7406,status={}", (Object[])new Object[]{lock});
        RBucket keyObject = this.redissonLock.getRedissonManager().getRedisson().getBucket("job:ipproxy:map_cache");
        if (!lock) {
            return (Map)keyObject.get();
        }
        HtmlPage proxyPage = (HtmlPage)webClient.getPage("http://d.jghttp.golangapi.com/getip?num=1&type=2&pro=0&city=0&yys=0&port=2&time=3&ts=1&ys=1&cs=1&lb=1&sb=0&pb=5&mr=1&regions=310000,320000,330000,340000");
        String proxyData = proxyPage.getWebResponse().getContentAsString();
        JSONObject jsonObject = JSONObject.parseObject((String)proxyData);
        XxlJobLogger.log((String)"\u91cd\u65b0\u83b7\u53d6\u4ee3\u7406IP\uff1a{}", (Object[])new Object[]{jsonObject.toJSONString()});
        JSONArray jsonArray = jsonObject.getJSONArray("data");
        JSONObject jsonData = jsonArray.getJSONObject(0);
        String proxyIp = jsonData.getString("ip");
        String proxyPort = jsonData.getString("port");
        String expireTime = jsonData.getString("expire_time");
        if (!proxyIp.isEmpty() && !proxyPort.isEmpty()) {
            long requestCount = this.redissonLock.incr("job:ipproxy:request_total");
            XxlJobLogger.log((String)"\u5171\u8bf7\u6c42\u6781\u5149\u4ee3\u7406IP {}\u6b21\uff01", (Object[])new Object[]{requestCount});
        }
        if (validCheck = this.retryProxy(proxyIp, proxyPort)) {
            long valid = this.redissonLock.incr("job:ipproxy:valid_total");
            XxlJobLogger.log((String)"\u5176\u4e2d\u3010\u6709\u6548\u3011IP\u4ee3\u7406{}\u4e2a\uff01", (Object[])new Object[]{valid});
        }
        HashMap<String, Map<String, String>> proxyConfigMap = new HashMap<String, Map<String, String>>();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("proxyIp", proxyIp);
        map.put("proxyPort", proxyPort);
        map.put("createTime", DateUtils.getNowTime());
        map.put("expireTime", expireTime);
        proxyConfigMap.put("proxyConfig", map);
        keyObject.delete();
        keyObject.set(proxyConfigMap);
        keyObject.expire(3L, TimeUnit.HOURS);
        this.redissonLock.release("job:ipproxy:concurrency");
        return proxyConfigMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean retryProxy(String proxyIp, String proxyPort) {
        WebClient webClient_tmp = WebClientUtil.getWebClient("");
        if (StringUtils.isNotBlank((CharSequence)proxyIp) && StringUtils.isNotBlank((CharSequence)proxyPort)) {
            webClient_tmp.getOptions().setProxyConfig(new ProxyConfig(proxyIp, Integer.parseInt(proxyPort)));
            try {
                HtmlPage testProxyPage = (HtmlPage)webClient_tmp.getPage("https://news.qq.com/");
                String htmlString = testProxyPage.getWebResponse().getContentAsString();
                if (htmlString.contains("script")) {
                    XxlJobLogger.log((String)"\u4ee3\u7406IP\u3010{}:{}\u3011\u6709\u6548\uff01", (Object[])new Object[]{proxyIp, proxyPort});
                    boolean bl = true;
                    return bl;
                }
            }
            catch (Exception e) {
                XxlJobLogger.log((String)"\u4ee3\u7406IP\u3010{}:{}\u3011\u6709\u6548\u6027\u68c0\u67e5\u8d85\u65f6\uff01msg={}", (Object[])new Object[]{proxyIp, proxyPort, e.getMessage()});
                boolean bl = false;
                return bl;
            }
            finally {
                webClient_tmp.close();
            }
        }
        webClient_tmp.close();
        return false;
    }
}

