/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.utils.collection;

import com.alibaba.fastjson.annotation.JSONField;
import com.xforceplus.account.domain.AccountTemplateDO;
import com.xforceplus.core.config.MessageDO;
import com.xforceplus.core.enums.RetailConstantEnum;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class CollectionResult
extends MessageDO
implements Serializable {
    private String belongKa;
    private String retailerId;
    private String retailerName;
    private String regionCode;
    private String supplierCode;
    private String siteUrl;
    @JSONField(format="yyyy-MM-dd HH:mm:ssSSS")
    private Date collectionStartDate;
    @JSONField(format="yyyy-MM-dd HH:mm:ssSSS")
    private Date collectionEndDate;
    private BigDecimal collectionCost;
    private String collectionStatus;
    private String msg;
    private String detailMsg;
    private String collectionClass;

    public CollectionResult() {
    }

    public CollectionResult(AccountTemplateDO account, Map<String, String> contextMap) {
        this.belongKa = account.getProjectKey();
        super.setProjectKey(account.getProjectKey());
        super.setRetailKey(account.getRetailKey());
        this.retailerId = account.getRetailKey();
        this.retailerName = RetailConstantEnum.geLabelByKey(super.getRetailKey());
        this.regionCode = account.getArea();
        this.supplierCode = account.getSupplierCode();
        this.siteUrl = contextMap.get("protocolName") + account.getSiteUrl();
        super.setAccountName(account.getAccountName());
    }

    public String getBelongKa() {
        return this.belongKa;
    }

    public void setBelongKa(String belongKa) {
        this.belongKa = belongKa;
    }

    public String getRetailerId() {
        return this.retailerId;
    }

    public void setRetailerId(String retailerId) {
        this.retailerId = retailerId;
    }

    public String getRetailerName() {
        return this.retailerName;
    }

    public void setRetailerName(String retailerName) {
        this.retailerName = retailerName;
    }

    public String getRegionCode() {
        return this.regionCode;
    }

    public void setRegionCode(String regionCode) {
        this.regionCode = regionCode;
    }

    public String getSupplierCode() {
        return this.supplierCode;
    }

    public void setSupplierCode(String supplierCode) {
        this.supplierCode = supplierCode;
    }

    public String getSiteUrl() {
        return this.siteUrl;
    }

    public void setSiteUrl(String siteUrl) {
        this.siteUrl = siteUrl;
    }

    public BigDecimal getCollectionCost() {
        BigDecimal loginCost = null;
        try {
            loginCost = BigDecimal.valueOf(this.collectionEndDate.getTime() - this.collectionStartDate.getTime()).divide(BigDecimal.valueOf(1000L), 3, 4);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return loginCost;
    }

    public void setCollectionCost(BigDecimal collectionCost) {
        this.collectionCost = collectionCost;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public String getDetailMsg() {
        return this.detailMsg;
    }

    public void setDetailMsg(String detailMsg) {
        this.detailMsg = detailMsg;
    }

    public void setDetailMsg(Exception e) {
        if (e != null) {
            this.detailMsg = ExceptionUtils.getStackTrace((Throwable)e);
        }
    }

    public void setDetailMsg(Throwable e) {
        if (e != null) {
            this.detailMsg = ExceptionUtils.getStackTrace((Throwable)e);
        }
    }

    public Date getCollectionStartDate() {
        return this.collectionStartDate;
    }

    public void setCollectionStartDate(Date collectionStartDate) {
        this.collectionStartDate = collectionStartDate;
    }

    public Date getCollectionEndDate() {
        return this.collectionEndDate;
    }

    public void setCollectionEndDate(Date collectionEndDate) {
        this.collectionEndDate = collectionEndDate;
    }

    public String getCollectionStatus() {
        return this.collectionStatus;
    }

    public void setCollectionStatus(String collectionStatus) {
        this.collectionStatus = collectionStatus;
    }

    public String getCollectionClass() {
        return this.collectionClass;
    }

    public void setCollectionClass(String collectionClass) {
        this.collectionClass = collectionClass;
    }
}

