/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.proxy;

import com.google.common.base.Splitter;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.xforceplus.account.AbstractLoginSys;
import com.xforceplus.account.domain.AccountTemplateDO;
import com.xforceplus.apollo.utils.ErrorUtil;
import com.xforceplus.apollo.utils.MD5Util;
import com.xforceplus.core.notice.ExceptionDdNoticer;
import com.xforceplus.janus.config.core.config.HttpConfig;
import com.xforceplus.janus.config.core.util.JanusHttpUtil;
import com.xforceplus.proxy.domain.IpBaseResponse;
import com.xforceplus.proxy.domain.IpResponse;
import com.xforceplus.utils.BaseUtils;
import com.xforceplus.utils.JsonUtils;
import com.xxl.job.core.log.XxlJobLogger;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyIpFactory {
    private static final Logger log = LoggerFactory.getLogger(ProxyIpFactory.class);
    public static final String CACHE_KEY_PRE = "local_ip_proxy_key_";
    private static Cache<String, IpResponse> cache = CacheBuilder.newBuilder().maximumSize(2000L).expireAfterWrite(15L, TimeUnit.MINUTES).build();
    private static List<String> status = Arrays.asList("408");

    public static IpResponse getIpProxy(AccountTemplateDO account) {
        String ipProxyCacheKey = CACHE_KEY_PRE + AbstractLoginSys.loginCacheKey(account);
        IpResponse ipResponse = (IpResponse)cache.getIfPresent((Object)ipProxyCacheKey);
        if (null == ipResponse || StringUtils.isBlank((CharSequence)ipResponse.getIp())) {
            ipResponse = account.isIpRenew() ? ProxyIpFactory.getRemoteIpProxyWithRenew(account.getAccountId(), account.getProxyArea(), MD5Util.getHexMD5Str((String)(StringUtils.isNotBlank((CharSequence)account.getRetailKey()) ? account.getRetailKey() : account.getSiteUrl()), (int)32), account.getProxyForm(), ipProxyCacheKey) : ProxyIpFactory.getRemoteIpProxy(account.getAccountId(), account.getProxyArea(), MD5Util.getHexMD5Str((String)(StringUtils.isNotBlank((CharSequence)account.getRetailKey()) ? account.getRetailKey() : account.getSiteUrl()), (int)32), account.getProxyForm(), ipProxyCacheKey);
        } else if (account.isIpRenew()) {
            ipResponse = ProxyIpFactory.getRemoteIpProxyWithRenew(account.getAccountId(), account.getProxyArea(), MD5Util.getHexMD5Str((String)(StringUtils.isNotBlank((CharSequence)account.getRetailKey()) ? account.getRetailKey() : account.getSiteUrl()), (int)32), account.getProxyForm(), ipProxyCacheKey);
        }
        return ipResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean validateProxy(String proxyIp, String proxyPort, String basicProxy) {
        CloseableHttpClient httpClient = null;
        CloseableHttpResponse response = null;
        String baseurl = "https://www.baidu.com/";
        try {
            HttpHost proxy = new HttpHost(proxyIp, Integer.parseInt(proxyPort));
            RequestConfig config = RequestConfig.custom().setProxy(proxy).setConnectTimeout(3000).setSocketTimeout(10000).setConnectionRequestTimeout(10000).build();
            httpClient = HttpClients.custom().setDefaultRequestConfig(config).build();
            HttpGet httpGet = new HttpGet(baseurl);
            httpGet.setConfig(config);
            httpGet.addHeader("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36");
            httpGet.addHeader("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
            if (StringUtils.isNotBlank((CharSequence)basicProxy)) {
                httpGet.addHeader("Proxy-Authorization", basicProxy);
            }
            response = httpClient.execute((HttpUriRequest)httpGet);
            int statusCode = response.getStatusLine().getStatusCode();
            XxlJobLogger.log((String)("statusCode:" + statusCode), (Object[])new Object[0]);
            String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            XxlJobLogger.log((String)ErrorUtil.getStackMsg((Exception)e), (Object[])new Object[0]);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
                if (httpClient != null) {
                    httpClient.close();
                }
            }
            catch (IOException e) {
                XxlJobLogger.log((String)ErrorUtil.getStackMsg((Exception)e), (Object[])new Object[0]);
            }
        }
    }

    public static IpResponse getRemoteIpProxy(String accountKey, String area, String businessPlatform, String ipProxyPlatform, String ipProxyCacheKey) {
        boolean flag;
        IpResponse ipResponse = (IpResponse)cache.getIfPresent((Object)ipProxyCacheKey);
        if (null != ipResponse && (flag = ProxyIpFactory.validateProxy(ipResponse.getIp(), ipResponse.getPort(), ipResponse.getBasicProxy()))) {
            return ipResponse;
        }
        if (StringUtils.isBlank((CharSequence)BaseUtils.JANUS_TOKEN) || StringUtils.isBlank((CharSequence)BaseUtils.JANUS_URL) || StringUtils.isBlank((CharSequence)BaseUtils.IP_PROXY_ACTION)) {
            throw new RuntimeException("ip\u4ee3\u7406\u914d\u7f6e\u5f02\u5e38");
        }
        if (StringUtils.isBlank((CharSequence)ipProxyPlatform)) {
            ipProxyPlatform = BaseUtils.JANUS_IP_PROXY_PLAT;
        }
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("authentication", BaseUtils.JANUS_TOKEN);
        header.put("serialNo", accountKey);
        header.put("accountKey", accountKey);
        header.put("action", BaseUtils.IP_PROXY_ACTION);
        try {
            for (int i = 0; i < 5; ++i) {
                boolean flag2;
                IpBaseResponse ipBaseResponse;
                JanusHttpUtil.ResponseCus responseCus;
                HashMap<String, String> params = new HashMap<String, String>();
                if (i > 0) {
                    params.put("retry", "true");
                }
                if (StringUtils.isNotBlank((CharSequence)area)) {
                    params.put("area", area);
                }
                if (StringUtils.isNotBlank((CharSequence)ipProxyPlatform)) {
                    params.put("platform", ipProxyPlatform);
                }
                if (StringUtils.isNotBlank((CharSequence)businessPlatform)) {
                    params.put("businessPlatform", businessPlatform);
                }
                if (null != (responseCus = JanusHttpUtil.doGetEntire((String)BaseUtils.JANUS_URL, params, (boolean)false, header)) && Objects.equals(responseCus.getStatus(), 200) && StringUtils.isNotBlank((CharSequence)responseCus.getBody()) && null != (ipBaseResponse = JsonUtils.toBean(responseCus.getBody(), IpBaseResponse.class)) && Objects.equals(ipBaseResponse.getCode(), "200") && null != ipBaseResponse.getResult() && (flag2 = ProxyIpFactory.validateProxy((ipResponse = ipBaseResponse.getResult()).getIp(), ipResponse.getPort(), ipResponse.getBasicProxy()))) {
                    cache.put((Object)ipProxyCacheKey, (Object)ipResponse);
                    return ipResponse;
                }
                Thread.sleep(3000L);
            }
        }
        catch (Exception e) {
            ExceptionDdNoticer.loggerError(log, ErrorUtil.getStackMsg((Exception)e));
        }
        XxlJobLogger.log((String)("\u672a\u83b7\u53d6\u5230\u6709\u6548\u5230\u4ee3\u7406IP,\u8d26\u53f7\u6807\u8bc6:" + accountKey), (Object[])new Object[0]);
        return null;
    }

    public static IpResponse getRemoteIpProxyWithRenew(String accountKey, String area, String businessPlatform, String ipProxyPlatform, String ipProxyCacheKey) {
        if (StringUtils.isBlank((CharSequence)BaseUtils.JANUS_TOKEN) || StringUtils.isBlank((CharSequence)BaseUtils.JANUS_URL) || StringUtils.isBlank((CharSequence)BaseUtils.IP_PROXY_ACTION)) {
            throw new RuntimeException("ip\u4ee3\u7406\u914d\u7f6e\u5f02\u5e38");
        }
        if (StringUtils.isBlank((CharSequence)ipProxyPlatform)) {
            ipProxyPlatform = BaseUtils.JANUS_IP_PROXY_PLAT;
        }
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("authentication", BaseUtils.JANUS_TOKEN);
        header.put("serialNo", accountKey);
        header.put("accountKey", accountKey);
        header.put("action", BaseUtils.IP_PROXY_ACTION);
        try {
            for (int i = 0; i < 5; ++i) {
                IpResponse ipResponse;
                boolean flag;
                IpBaseResponse ipBaseResponse;
                JanusHttpUtil.ResponseCus responseCus;
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("retry", "true");
                if (StringUtils.isNotBlank((CharSequence)area)) {
                    params.put("area", area);
                }
                if (StringUtils.isNotBlank((CharSequence)ipProxyPlatform)) {
                    params.put("platform", ipProxyPlatform);
                }
                if (StringUtils.isNotBlank((CharSequence)businessPlatform)) {
                    params.put("businessPlatform", businessPlatform);
                }
                if (null != (responseCus = JanusHttpUtil.doGetEntire((String)BaseUtils.JANUS_URL, params, (boolean)false, header)) && Objects.equals(responseCus.getStatus(), 200) && StringUtils.isNotBlank((CharSequence)responseCus.getBody()) && null != (ipBaseResponse = JsonUtils.toBean(responseCus.getBody(), IpBaseResponse.class)) && Objects.equals(ipBaseResponse.getCode(), "200") && null != ipBaseResponse.getResult() && (flag = ProxyIpFactory.validateProxy((ipResponse = ipBaseResponse.getResult()).getIp(), ipResponse.getPort(), ipResponse.getBasicProxy()))) {
                    cache.put((Object)ipProxyCacheKey, (Object)ipResponse);
                    return ipResponse;
                }
                Thread.sleep(3000L);
            }
        }
        catch (Exception e) {
            ExceptionDdNoticer.loggerError(log, ErrorUtil.getStackMsg((Exception)e));
        }
        XxlJobLogger.log((String)("\u672a\u83b7\u53d6\u5230\u6709\u6548\u5230\u4ee3\u7406IP,\u8d26\u53f7\u6807\u8bc6:" + accountKey), (Object[])new Object[0]);
        return null;
    }

    public static boolean validateSiteUrl(AccountTemplateDO templateDO) {
        try {
            if (StringUtils.isBlank((CharSequence)templateDO.getCheckSiteUrl())) {
                String checkSiteUrl = (String)HttpConfig.getConfig((String)"checkSiteUrl");
                templateDO.setCheckSiteUrl(checkSiteUrl);
            }
            if (StringUtils.isBlank((CharSequence)templateDO.getCheckSiteUrl())) {
                XxlJobLogger.log((String)"\u4e0d\u9700\u8981\u68c0\u9a8c\u7f51\u7ad9\u5730\u5740", (Object[])new Object[0]);
                return true;
            }
            if (templateDO.getIpProxy() != null && templateDO.getIpProxy() == 1) {
                String ipProxyCacheKey = CACHE_KEY_PRE + AbstractLoginSys.loginCacheKey(templateDO);
                IpResponse ipResponse = ProxyIpFactory.getRemoteIpProxyWithRenew(templateDO.getAccountId(), templateDO.getProxyArea(), MD5Util.getHexMD5Str((String)(StringUtils.isNotBlank((CharSequence)templateDO.getRetailKey()) ? templateDO.getRetailKey() : templateDO.getSiteUrl()), (int)32), templateDO.getProxyForm(), ipProxyCacheKey);
                if (null == ipResponse || StringUtils.isBlank((CharSequence)ipResponse.getIp())) {
                    return true;
                }
                return ProxyIpFactory.checkUrlWithProxy(templateDO.getCheckSiteUrl(), ipResponse.getIp(), Integer.parseInt(ipResponse.getPort()));
            }
            return ProxyIpFactory.isUrlAvailable(templateDO.getCheckSiteUrl());
        }
        catch (Exception e) {
            XxlJobLogger.log((String)ErrorUtil.getStackMsg((Exception)e), (Object[])new Object[0]);
            return true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isUrlAvailable(String url) {
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(20000).setSocketTimeout(30000).build();
            HttpHead request = new HttpHead(url);
            request.setConfig(requestConfig);
            request.setHeader("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36");
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);
            int statusCode = response.getStatusLine().getStatusCode();
            XxlJobLogger.log((String)"url:{},\u68c0\u6d4b\u72b6\u6001\u7801:{}", (Object[])new Object[]{url, statusCode});
            boolean bl = ProxyIpFactory.checkStatus(statusCode);
            return bl;
        }
        catch (Exception e) {
            XxlJobLogger.log((String)ErrorUtil.getStackMsg((Exception)e), (Object[])new Object[0]);
            return false;
        }
    }

    private static boolean checkStatus(int statusCode) {
        List cks;
        if (statusCode >= 500) {
            return false;
        }
        if (status.contains(statusCode + "")) {
            return false;
        }
        String ck = (String)HttpConfig.getConfig((String)"collect_checkStatus");
        return !StringUtils.isNotBlank((CharSequence)ck) || !(cks = Splitter.on((String)",").splitToList((CharSequence)ck)).contains(statusCode + "");
    }

    /*
     * Exception decompiling
     */
    public static boolean checkUrlWithProxy(String url, String proxyHost, int proxyPort) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void main(String[] args) {
        System.out.println(ProxyIpFactory.isUrlAvailable("http://gyl.nhd-mart.com/Login.aspx"));
        System.out.println(ProxyIpFactory.isUrlAvailable("http://gyl.nhd-mart.com/Login.aspx"));
        System.out.println(ProxyIpFactory.isUrlAvailable("http://gyl.nhd-mart.com/Login.aspx"));
    }
}

