/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.utils;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class DateUtils
extends org.apache.commons.lang3.time.DateUtils {
    private static final ThreadLocal<Map<String, DateFormat>> dateFormatThreadLocal = new ThreadLocal();
    public static String[] parsePatterns = new String[]{"yyyy-MM-dd", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm", "yyyy/MM/dd", "yyyy/MM/dd HH:mm:ss", "yyyy-MM-dd HH:mm:ss.SSS", "yyyy/MM/dd HH:mm", "yyyyMMddHHmmss"};

    public static String getNowDate() {
        return DateUtils.dateToStringWithPattern(new Date(), "yyyy-MM-dd");
    }

    public static String getNowTime() {
        return DateUtils.dateToStringWithPattern(new Date(), "yyyy-MM-dd HH:mm:ss:SSS");
    }

    public static String dateToString(Date date) {
        return DateUtils.dateToStringWithPattern(date, "yyyy-MM-dd HH:mm");
    }

    public static String dateToShortString(Date date) {
        return DateUtils.dateToStringWithPattern(date, "yyyy-MM-dd");
    }

    public static String dateToLongString(Date date) {
        return DateUtils.dateToStringWithPattern(date, "yyyy-MM-dd HH:mm:ss");
    }

    public static String dateToTimeString(Date date) {
        return DateUtils.dateToStringWithPattern(date, "HH:mm:ss");
    }

    public static String dateToStringWithPattern(Date date, String pattern) {
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
            return simpleDateFormat.format(date);
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String[] SplitDate(Date date) {
        String s = DateUtils.dateToShortString(date);
        String[] temp = new String[3];
        StringTokenizer stringTokenizer = new StringTokenizer(s, "-");
        int i = 0;
        while (stringTokenizer.hasMoreTokens()) {
            temp[i] = stringTokenizer.nextToken();
            ++i;
        }
        return temp;
    }

    public static String dateToBOMCStringDate(Date date) {
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String string = simpleDateFormat.format(date);
            string = DateUtils.StringToBOMCStringDate(string);
            return string;
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String StringToBOMCStringDate(String date) {
        return date.replace(" ", "T");
    }

    public static Date stringToDate(String string, String pattern) {
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
            return simpleDateFormat.parse(string);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Date stringToDate(String string) {
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return simpleDateFormat.parse(string);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Date timeStringToDate(String string) {
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss");
            return simpleDateFormat.parse(string);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Date stringToShortDate(String string) {
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            ParsePosition parsePosition = new ParsePosition(0);
            return simpleDateFormat.parse(string, parsePosition);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Date stringToShortNoDate(String string) {
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
            ParsePosition parsePosition = new ParsePosition(0);
            return simpleDateFormat.parse(string, parsePosition);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Date getNow() {
        return new Date();
    }

    public static long getCurrentTimestamp() {
        return new Date().getTime();
    }

    public static long getTimestamp(String string) {
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            ParsePosition parsePosition = new ParsePosition(0);
            Date date = simpleDateFormat.parse(string, parsePosition);
            return date.getTime();
        }
        catch (Exception e) {
            return -1L;
        }
    }

    public static long getStringToTimestamp(String string) {
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            ParsePosition parsePosition = new ParsePosition(0);
            Date date = simpleDateFormat.parse(string, parsePosition);
            return date.getTime();
        }
        catch (Exception e) {
            return -1L;
        }
    }

    public static long getOffMinutes(long timestamp) {
        return DateUtils.getOffMinutes(timestamp, System.currentTimeMillis());
    }

    public static long getOffMinutes(long left, long right) {
        return (left - right) / 60000L;
    }

    public static String LongToDateString(long timestamp) {
        Date date;
        DateFormat dateFormat;
        try {
            dateFormat = DateFormat.getDateTimeInstance();
            String dateString = String.valueOf(timestamp);
            date = new Date(Long.parseLong(dateString));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
        return dateFormat.format(date);
    }

    public static Date getWeekDay(String dateString, int weekDay) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date date = null;
        try {
            date = simpleDateFormat.parse(dateString);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Calendar calendar = Calendar.getInstance();
        if (date != null) {
            calendar.setTime(date);
        }
        calendar.set(7, weekDay);
        calendar.add(5, 1);
        return calendar.getTime();
    }

    public static Date getMonthFirstDay(String dateString) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM");
        Date date = null;
        try {
            date = simpleDateFormat.parse(dateString);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Calendar calendar = Calendar.getInstance();
        if (date != null) {
            calendar.setTime(date);
        }
        calendar.add(5, 0);
        return calendar.getTime();
    }

    public static Date getMonthLastDay(String dateString) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM");
        Date date = null;
        try {
            date = simpleDateFormat.parse(dateString);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Calendar calendar = Calendar.getInstance();
        if (date != null) {
            calendar.setTime(date);
        }
        calendar.add(2, 1);
        calendar.add(5, -1);
        return calendar.getTime();
    }

    public static Date getYearFirstDay(String dateString) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy");
        Date date = null;
        try {
            date = simpleDateFormat.parse(dateString);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Calendar calendar = Calendar.getInstance();
        if (date != null) {
            calendar.setTime(date);
        }
        calendar.add(6, 0);
        return calendar.getTime();
    }

    public static Date getYearLastDay(String dateString) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy");
        Date date = null;
        try {
            date = simpleDateFormat.parse(dateString);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Calendar calendar = Calendar.getInstance();
        if (date != null) {
            calendar.setTime(date);
        }
        calendar.add(1, 1);
        calendar.add(5, -1);
        return calendar.getTime();
    }

    public static Date getDate(Date date, int field, int amount) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(field, amount);
        return calendar.getTime();
    }

    public static String getDateTime(int space) {
        String dateStr = DateUtils.dateToTimeString(new Date());
        String[] sp = dateStr.split(":");
        int i = Integer.parseInt(sp[1]) - Integer.parseInt(sp[1]) % space;
        if (i < 10) {
            String minute = "0" + i;
            return sp[0] + minute;
        }
        return sp[0] + i;
    }

    public static String format(Date date, String patten) {
        return DateUtils.getDateFormat(patten).format(date);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DateFormat getDateFormat(String pattern) {
        if (pattern != null && pattern.trim().length() != 0) {
            Map<String, DateFormat> dateFormatMap = dateFormatThreadLocal.get();
            if (dateFormatMap != null && dateFormatMap.containsKey(pattern)) {
                return dateFormatMap.get(pattern);
            }
            ThreadLocal<Map<String, DateFormat>> threadLocal = dateFormatThreadLocal;
            synchronized (threadLocal) {
                if (dateFormatMap == null) {
                    dateFormatMap = new HashMap<String, DateFormat>();
                }
                dateFormatMap.put(pattern, new SimpleDateFormat(pattern));
                dateFormatThreadLocal.set(dateFormatMap);
            }
            return dateFormatMap.get(pattern);
        }
        throw new IllegalArgumentException("pattern cannot be empty.");
    }

    public static String dateTimeSub(String dateTime, int space) {
        String m = "";
        int house = Integer.valueOf(dateTime.substring(0, 2));
        int minute = Integer.valueOf(dateTime.substring(2, 4));
        if (minute < space) {
            minute = 60 + minute - space;
            house = house == 0 ? 23 : --house;
        } else {
            minute -= space;
        }
        String h = house < 10 ? "0" + house : String.valueOf(house);
        m = minute < 10 ? "0" + minute : String.valueOf(minute);
        return h + m;
    }

    public static boolean isNull(Date date) {
        return date == null;
    }

    public static Date parseDate(Object str) {
        if (str == null) {
            return null;
        }
        try {
            return DateUtils.parseDate((String)str.toString(), (String[])parsePatterns);
        }
        catch (ParseException var2) {
            return null;
        }
    }
}

