/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.core.aop;

import com.alibaba.fastjson.JSON;
import com.xforceplus.account.domain.AccountTemplateDO;
import com.xforceplus.core.aop.AOPUtil;
import com.xforceplus.utils.DateUtils;
import com.xforceplus.utils.collection.CollectionResult;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.log.XxlJobLogger;
import java.net.InetAddress;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class AOPCollection {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String COLLECTION_SERVICE_MSG = "collectionServiceMsg";
    @Autowired
    Environment environment;
    private final ThreadLocal<Long> startTime = new ThreadLocal();
    private final ThreadLocal<Map<String, Long>> invokeCountMap = new ThreadLocal();
    private static final String collectionCutPoint = "@annotation(com.xforceplus.utils.annotation.CollectionDesc)";

    @Pointcut(value="@annotation(com.xforceplus.utils.annotation.CollectionDesc)")
    public void collectionCutPoint() {
    }

    @Around(value="collectionCutPoint()")
    public Object doAround(ProceedingJoinPoint joinPoint) throws Throwable {
        if (this.invokeCountMap.get() == null) {
            this.invokeCountMap.set(new HashMap());
        }
        String collectionDesc = AOPUtil.getCollectionDesc((JoinPoint)joinPoint);
        XxlJobLogger.log((String)">>>>>>>>>>> {} collection : ip={} port={}", (Object[])new Object[]{collectionDesc, InetAddress.getLocalHost(), this.environment.getProperty("server.port")});
        this.logger.info(">>>>>>>>>>> {} collection : ip={} port={}", new Object[]{collectionDesc, InetAddress.getLocalHost(), this.environment.getProperty("server.port")});
        long start = System.currentTimeMillis();
        Date startDate = new Date(start);
        XxlJobLogger.log((String)">>>>>>>>>>> {} collection : start time = {}", (Object[])new Object[]{collectionDesc, DateUtils.dateToLongString(startDate)});
        this.logger.info(">>>>>>>>>>> {} collection : start time = {}", (Object)collectionDesc, (Object)DateUtils.dateToLongString(startDate));
        this.startTime.set(start);
        Object result = joinPoint.proceed();
        long end = System.currentTimeMillis();
        long total = end - this.startTime.get();
        XxlJobLogger.log((String)">>>>>>>>>>> {} collection : end time = {}", (Object[])new Object[]{collectionDesc, DateUtils.dateToLongString(new Date(end))});
        this.logger.info(">>>>>>>>>>> {} collection : end time = {}", (Object)collectionDesc, (Object)DateUtils.dateToLongString(new Date(end)));
        XxlJobLogger.log((String)">>>>>>>>>>> {} collection : total = {} s", (Object[])new Object[]{collectionDesc, Math.round(total / 1000L)});
        this.logger.info(">>>>>>>>>>> {} collection : total = {} s", (Object)collectionDesc, (Object)Math.round(total / 1000L));
        ReturnT returnT = (ReturnT)result;
        if (returnT != null && returnT.getCode() == 500) {
            XxlJobLogger.log((String)">>>>>>>>>>> {} {}", (Object[])new Object[]{collectionDesc, "failure\uff01\uff01\uff01"});
            this.logger.info(">>>>>>>>>>> {} collection : result = {}", (Object)collectionDesc, (Object)"failure\uff01\uff01\uff01");
        } else {
            XxlJobLogger.log((String)">>>>>>>>>>> {} collection : result = {}", (Object[])new Object[]{collectionDesc, "success\uff01\uff01\uff01"});
            this.logger.info(">>>>>>>>>>> {} collection : result = {}", (Object)collectionDesc, (Object)"success\uff01\uff01\uff01");
        }
        return result;
    }

    private void sendDcsGatherErrorMessage(ProceedingJoinPoint joinPoint, Date startDate, Throwable e) {
        block6: {
            try {
                String loginClass = joinPoint.getTarget().getClass().getSimpleName();
                AccountTemplateDO account = (AccountTemplateDO)joinPoint.getArgs()[1];
                Map contextMap = (Map)joinPoint.getArgs()[2];
                CollectionResult collectionResult = new CollectionResult(account, contextMap);
                try {
                    CollectionResult t = (CollectionResult)JSON.parseObject((String)(contextMap.get(COLLECTION_SERVICE_MSG) + ""), CollectionResult.class);
                    if (t != null) {
                        collectionResult = t;
                        break block6;
                    }
                    collectionResult.setMsg("\u672a\u8fd4\u56de\u91c7\u96c6\u5f02\u5e38\u4fe1\u606f");
                }
                catch (Exception ignore) {
                    this.logger.info(">>>>>>>>>>> {}({}) \u672a\u8fd4\u56de\u91c7\u96c6\u5f02\u5e38\u4fe1\u606f\uff01\uff01\uff01", (Object)loginClass, (Object)AOPUtil.getCollectionDesc((JoinPoint)joinPoint));
                    if (e != null) {
                        collectionResult.setDetailMsg(ExceptionUtils.getStackTrace((Throwable)e));
                    }
                }
            }
            catch (Exception exception) {
                this.logger.info(">>>>>>>>>>> \u91c7\u96c6\u5f02\u5e38\u6d88\u606f\u53d1\u9001\u5931\u8d25" + exception.getMessage());
            }
        }
    }
}

