/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.core.resolve;

import com.xforceplus.bean.JobBillTypeBean;
import com.xforceplus.core.annotation.DcsJobHandler;
import com.xforceplus.core.resolve.ResolveTask;
import com.xforceplus.service.handler.DcsHandlerReporter;
import com.xxl.job.core.log.XxlJobLogger;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class TaskQueueManager {
    private final Map<JobBillTypeBean, BlockingDeque<ResolveTask>> queues = new HashMap<JobBillTypeBean, BlockingDeque<ResolveTask>>(8);
    @Resource
    private DcsHandlerReporter reporter;

    @PostConstruct
    public void init() {
        for (DcsJobHandler handler : this.reporter.getHandlerList()) {
            JobBillTypeBean bean = new JobBillTypeBean(handler.billType(), handler.version());
            this.queues.put(bean, new LinkedBlockingDeque(30000));
        }
    }

    public void addTask(ResolveTask task) throws InterruptedException {
        if (null == task || null == task.getJobBillType() || null == task.getJobBillType().getBillType()) {
            XxlJobLogger.log((String)"\u89e3\u6790\u57fa\u7840\u6570\u636e\u7f3a\u5931", (Object[])new Object[0]);
            return;
        }
        if (null == this.queues.get(task.getJobBillType())) {
            for (JobBillTypeBean queueKey : this.queues.keySet()) {
                if (!Objects.equals(queueKey.getBillType().getKey(), task.getJobBillType().getBillType().getKey())) continue;
                this.queues.get(queueKey).add(task);
                break;
            }
        } else {
            this.queues.get(task.getJobBillType()).put(task);
        }
    }

    public Map<JobBillTypeBean, BlockingDeque<ResolveTask>> getQueueMap() {
        return this.queues;
    }

    public Collection<BlockingDeque<ResolveTask>> getQueues() {
        return this.queues.values();
    }
}

