/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.proxy;

import com.google.common.base.Splitter;
import com.xforceplus.account.AbstractLoginSys;
import com.xforceplus.account.domain.AccountTemplateDO;
import com.xforceplus.apollo.utils.ErrorUtil;
import com.xforceplus.apollo.utils.MD5Util;
import com.xforceplus.janus.config.core.config.HttpConfig;
import com.xforceplus.proxy.ProxyIpFactory;
import com.xforceplus.proxy.domain.IpResponse;
import com.xxl.job.core.log.XxlJobLogger;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

public class ValidateSiteHelper {
    private static List<String> status = Arrays.asList("408");

    public static boolean validateSiteUrlRobustly(AccountTemplateDO templateDO) {
        try {
            if (StringUtils.isBlank((CharSequence)templateDO.getCheckSiteUrl())) {
                String checkSiteUrl = (String)HttpConfig.getConfig((String)"checkSiteUrl");
                templateDO.setCheckSiteUrl(checkSiteUrl);
            }
            if (StringUtils.isBlank((CharSequence)templateDO.getCheckSiteUrl()) || Objects.equals(templateDO.getCheckSiteUrl(), "no")) {
                XxlJobLogger.log((String)"\u4e0d\u9700\u8981\u68c0\u9a8c\u7f51\u7ad9\u5730\u5740", (Object[])new Object[0]);
                return true;
            }
            XxlJobLogger.log((String)("\u5f00\u59cb\u5065\u58ee\u6027\u68c0\u67e5\u7ad9\u70b9: " + templateDO.getCheckSiteUrl()), (Object[])new Object[0]);
            if (templateDO.getIpProxy() != null && templateDO.getIpProxy() == 1) {
                String ipProxyCacheKey = "local_ip_proxy_key_" + AbstractLoginSys.loginCacheKey(templateDO);
                IpResponse ipResponse = ProxyIpFactory.getRemoteIpProxy(templateDO.getAccountId(), templateDO.getProxyArea(), MD5Util.getHexMD5Str((String)(StringUtils.isNotBlank((CharSequence)templateDO.getRetailKey()) ? templateDO.getRetailKey() : templateDO.getSiteUrl()), (int)32), templateDO.getProxyForm(), ipProxyCacheKey);
                if (null == ipResponse || StringUtils.isBlank((CharSequence)ipResponse.getIp())) {
                    XxlJobLogger.log((String)"\u672a\u83b7\u53d6\u5230\u4ee3\u7406IP\uff0c\u76f4\u63a5\u68c0\u67e5URL", (Object[])new Object[0]);
                    return ValidateSiteHelper.checkUrlRobustly(templateDO.getCheckSiteUrl(), null, null, null);
                }
                XxlJobLogger.log((String)("\u4f7f\u7528\u4ee3\u7406\u68c0\u67e5: " + ipResponse.getIp() + ":" + ipResponse.getPort()), (Object[])new Object[0]);
                return ValidateSiteHelper.checkUrlRobustly(templateDO.getCheckSiteUrl(), ipResponse.getIp(), Integer.parseInt(ipResponse.getPort()), ipResponse.getBasicProxy());
            }
            return ValidateSiteHelper.checkUrlRobustly(templateDO.getCheckSiteUrl(), null, null, null);
        }
        catch (Exception e) {
            XxlJobLogger.log((String)("validateSiteUrlRobustly \u5f02\u5e38: " + ErrorUtil.getStackMsg((Exception)e)), (Object[])new Object[0]);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkUrlRobustly(String url, String proxyHost, Integer proxyPort, String basicProxy) {
        CloseableHttpClient httpClient = null;
        CloseableHttpResponse response = null;
        try {
            RequestConfig.Builder configBuilder = RequestConfig.custom().setConnectTimeout(10000).setSocketTimeout(15000).setConnectionRequestTimeout(10000).setRedirectsEnabled(false);
            if (StringUtils.isNotBlank((CharSequence)proxyHost) && proxyPort != null) {
                HttpHost proxy = new HttpHost(proxyHost, proxyPort.intValue());
                configBuilder.setProxy(proxy);
            }
            RequestConfig config = configBuilder.build();
            httpClient = HttpClients.custom().setDefaultRequestConfig(config).setMaxConnTotal(20).setMaxConnPerRoute(10).setConnectionTimeToLive(30L, TimeUnit.SECONDS).evictIdleConnections(30L, TimeUnit.SECONDS).build();
            HttpHead request = new HttpHead(url);
            request.setConfig(config);
            ValidateSiteHelper.setCommonHeaders((HttpRequestBase)request);
            if (StringUtils.isNotBlank((CharSequence)basicProxy)) {
                request.addHeader("Proxy-Authorization", basicProxy);
            }
            XxlJobLogger.log((String)("\u5f00\u59cb\u68c0\u67e5URL: " + url + (proxyHost != null ? " \u901a\u8fc7\u4ee3\u7406: " + proxyHost + ":" + proxyPort : "")), (Object[])new Object[0]);
            boolean bl = ValidateSiteHelper.executeWithOverallTimeout(httpClient, request, url, 20000L);
            ValidateSiteHelper.closeResources(response, httpClient);
            return bl;
        }
        catch (Exception e) {
            XxlJobLogger.log((String)("checkUrlRobustly \u68c0\u67e5\u5f02\u5e38: " + e.getMessage()), (Object[])new Object[0]);
            boolean bl = false;
            return bl;
        }
        finally {
            ValidateSiteHelper.closeResources(response, httpClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean executeWithOverallTimeout(CloseableHttpClient httpClient, HttpHead request, String url, long timeoutMs) {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<Boolean> future = null;
        try {
            future = executor.submit(() -> {
                try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);){
                    int statusCode = response.getStatusLine().getStatusCode();
                    XxlJobLogger.log((String)("URL\u68c0\u67e5\u5b8c\u6210: " + url + " \u72b6\u6001\u7801: " + statusCode), (Object[])new Object[0]);
                    Boolean bl = ValidateSiteHelper.checkStatus(statusCode);
                    return bl;
                }
                catch (Exception e) {
                    XxlJobLogger.log((String)("HTTP\u6267\u884c\u5f02\u5e38: " + e.getMessage()), (Object[])new Object[0]);
                    return false;
                }
            });
            boolean bl = future.get(timeoutMs, TimeUnit.MILLISECONDS);
            return bl;
        }
        catch (TimeoutException e) {
            XxlJobLogger.log((String)("URL\u68c0\u67e5\u8d85\u65f6: " + url + " \u8d85\u8fc7 " + timeoutMs + "ms"), (Object[])new Object[0]);
            future.cancel(true);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            XxlJobLogger.log((String)("\u603b\u4f53\u6267\u884c\u5f02\u5e38: " + e.getMessage()), (Object[])new Object[0]);
            boolean bl = false;
            return bl;
        }
        finally {
            executor.shutdown();
            try {
                if (!executor.awaitTermination(2L, TimeUnit.SECONDS)) {
                    executor.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                executor.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
    }

    private static void setCommonHeaders(HttpRequestBase request) {
        request.setHeader("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36");
        request.setHeader("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
        request.setHeader("Accept-Language", "zh-CN,zh;q=0.9,en;q=0.8");
        request.setHeader("Accept-Encoding", "gzip, deflate, br");
        request.setHeader("Connection", "close");
    }

    private static void closeResources(CloseableHttpResponse response, CloseableHttpClient httpClient) {
        if (response != null) {
            try {
                response.close();
            }
            catch (IOException e) {
                XxlJobLogger.log((String)("\u5173\u95edresponse\u5f02\u5e38: " + e.getMessage()), (Object[])new Object[0]);
            }
        }
        if (httpClient != null) {
            try {
                httpClient.close();
            }
            catch (IOException e) {
                XxlJobLogger.log((String)("\u5173\u95edhttpClient\u5f02\u5e38: " + e.getMessage()), (Object[])new Object[0]);
            }
        }
    }

    private static boolean checkStatus(int statusCode) {
        List cks;
        if (statusCode >= 500) {
            return false;
        }
        if (status.contains(statusCode + "")) {
            return false;
        }
        String ck = (String)HttpConfig.getConfig((String)"collect_checkStatus");
        return !StringUtils.isNotBlank((CharSequence)ck) || !(cks = Splitter.on((String)",").splitToList((CharSequence)ck)).contains(statusCode + "");
    }

    public static void main(String[] args) {
    }
}

