/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.utils;

import com.xforceplus.core.enums.CharSetEnum;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadUtils {
    protected static final Logger logger = LoggerFactory.getLogger(DownloadUtils.class);

    public static String getContentFromUrl(String urlStr, int timeout) {
        InputStream inputStream = DownloadUtils.getInputStreamFromUrl(urlStr, timeout);
        byte[] bytes = new byte[]{};
        try {
            bytes = DownloadUtils.readInputStream(inputStream);
        }
        catch (IOException e) {
            logger.error("\u8bfb\u53d6\u5f02\u5e38\uff01", (Throwable)e);
            e.printStackTrace();
        }
        if (bytes == null) {
            return "";
        }
        String data = null;
        try {
            data = new String(bytes, CharSetEnum.UTF8.getCharSet());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
        logger.info("[" + urlStr + "] \u8bfb\u53d6\u6210\u529f\uff01");
        return data;
    }

    public static InputStream getInputStreaFromUrl(String urlStr) {
        return DownloadUtils.getInputStreamFromUrl(urlStr, 3000);
    }

    public static InputStream getInputStreamFromUrl(String urlStr, int timeout) {
        logger.info("\u4e0b\u8f7d\u6587\u4ef6\uff1a{}", (Object)urlStr);
        URL url = null;
        try {
            url = new URL(urlStr);
        }
        catch (MalformedURLException e) {
            logger.error("\u5730\u5740\u65e0\u6548\uff01", (Throwable)e);
            e.printStackTrace();
            return null;
        }
        HttpURLConnection conn = null;
        try {
            conn = (HttpURLConnection)url.openConnection();
        }
        catch (IOException e) {
            logger.error("\u8fde\u63a5\u5f02\u5e38\uff01", (Throwable)e);
            e.printStackTrace();
            return null;
        }
        conn.setConnectTimeout(timeout);
        conn.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt)");
        InputStream inputStream = null;
        try {
            inputStream = conn.getInputStream();
        }
        catch (IOException e) {
            logger.error("\u7f51\u7edc\u5f02\u5e38\uff01", (Throwable)e);
            e.printStackTrace();
        }
        return inputStream;
    }

    public static byte[] readInputStream(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            return null;
        }
        byte[] buffer = new byte[1024];
        int len = 0;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while ((len = inputStream.read(buffer)) != -1) {
            bos.write(buffer, 0, len);
        }
        bos.close();
        return bos.toByteArray();
    }

    public static void downLoadFileByHttp(String fileUrl, String filePath, String fileName) throws IOException {
        URL url = new URL(fileUrl);
        HttpURLConnection httpURLConnection = (HttpURLConnection)url.openConnection();
        httpURLConnection.setRequestMethod("GET");
        InputStream in = httpURLConnection.getInputStream();
        Files.copy(in, new File(filePath + File.separator + fileName).toPath(), StandardCopyOption.REPLACE_EXISTING);
        File file = new File(System.getProperty("user.dir") + File.separator + fileName);
        if (file.exists()) {
            file.delete();
        }
    }
}

