/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.utils;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class NumberLib
extends NumberUtils {
    private static DecimalFormat moneyFormater = new DecimalFormat("##,###0.00");
    private static DecimalFormat doubleFormater0 = new DecimalFormat("##0");
    private static DecimalFormat doubleFormater1 = new DecimalFormat("##0.0");
    private static DecimalFormat doubleFormater2 = new DecimalFormat("##0.00");
    private static DecimalFormat doubleFormater3 = new DecimalFormat("##0.000");
    private static DecimalFormat doubleFormater4 = new DecimalFormat("##0.0000");
    private static DecimalFormat doubleFormater5 = new DecimalFormat("##0.00000");
    private static DecimalFormat doubleFormater6 = new DecimalFormat("##0.000000");
    private static DecimalFormat doubleFormater7 = new DecimalFormat("##0.0000000");
    private static DecimalFormat doubleFormater8 = new DecimalFormat("##0.00000000");
    private static DecimalFormat doubleFormater9 = new DecimalFormat("##0.000000000");
    private static DecimalFormat doubleFormater10 = new DecimalFormat("##0.0000000000");

    public static String formatMoney(Number value) {
        if (value == null) {
            return "";
        }
        return moneyFormater.format(value);
    }

    public static String formatDouble(Number value) {
        if (value == null) {
            return "";
        }
        return NumberLib.formatDouble(value, 2);
    }

    public static String formatDouble(Number value, int decimal) {
        if (decimal == 0) {
            return doubleFormater0.format(value);
        }
        if (decimal == 1) {
            return doubleFormater1.format(value);
        }
        if (decimal == 2) {
            return doubleFormater2.format(value);
        }
        if (decimal == 3) {
            return doubleFormater3.format(value);
        }
        if (decimal == 4) {
            return doubleFormater4.format(value);
        }
        if (decimal == 5) {
            return doubleFormater5.format(value);
        }
        if (decimal == 6) {
            return doubleFormater6.format(value);
        }
        if (decimal == 7) {
            return doubleFormater7.format(value);
        }
        if (decimal == 8) {
            return doubleFormater8.format(value);
        }
        if (decimal == 9) {
            return doubleFormater9.format(value);
        }
        if (decimal == 10) {
            return doubleFormater10.format(value);
        }
        return doubleFormater2.format(value);
    }

    public static String formatInteger(Long value) {
        if (value == null) {
            return "";
        }
        DecimalFormat formatter = (DecimalFormat)NumberFormat.getInstance(Locale.US);
        formatter.setMinimumFractionDigits(0);
        formatter.setMaximumFractionDigits(0);
        return formatter.format(value);
    }

    public static boolean isNull(Long id) {
        return id == null || id <= 0L;
    }

    public static Float mul(Float num1, Float num2) {
        if (num1 == null || num2 == null) {
            return Float.valueOf(0.0f);
        }
        return Float.valueOf(num1.floatValue() * num2.floatValue());
    }

    public static float mul_percent(Float num, Float percent) {
        if (num == null || percent == null) {
            return 0.0f;
        }
        Float amount = Float.valueOf(num.floatValue() * percent.floatValue() / 100.0f);
        if (Float.isNaN(amount.floatValue())) {
            return 0.0f;
        }
        return amount.floatValue();
    }

    public static float add(float ... values) {
        if (ArrayUtils.isNotEmpty((float[])values)) {
            float total = 0.0f;
            for (float value : values) {
                total += value;
            }
            return total;
        }
        return 0.0f;
    }
}

