/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.account.cache;

import com.xforceplus.account.domain.LoginTokenInfo;
import com.xforceplus.apollo.utils.ErrorUtil;
import com.xforceplus.core.enums.IntConstant;
import com.xforceplus.lock.redisson.RedissonLock;
import com.xforceplus.utils.BaseUtils;
import com.xforceplus.utils.Constant;
import com.xforceplus.utils.SpringContext;
import com.xxl.job.core.log.XxlJobLogger;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RBucket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginCache {
    private static final Logger log = LoggerFactory.getLogger(LoginCache.class);
    private static RedissonLock redissonLock = null;
    private static volatile LoginCache instance = null;

    private LoginCache() {
        redissonLock = SpringContext.getBean(RedissonLock.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LoginCache getInstance() {
        if (instance != null) return instance;
        Class<LoginCache> clazz = LoginCache.class;
        synchronized (LoginCache.class) {
            if (instance != null) return instance;
            instance = new LoginCache();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public LoginTokenInfo getCacheToken(String tokenKey) {
        try {
            boolean bool = redissonLock.isLock("dcs:common:login:lock:" + tokenKey);
            for (int i = IntConstant.ZERO; i < Constant.WAIT_TOKEN_WAIT_TIMES && bool; ++i) {
                try {
                    Thread.sleep(BaseUtils.randomLong(15, 10));
                    bool = redissonLock.isLock("dcs:common:login:lock:" + tokenKey);
                    continue;
                }
                catch (InterruptedException e) {
                    XxlJobLogger.log((String)"\u91c7\u96c6\u767b\u5f55\u7f13\u5b58\u52a0\u9501\u51fa\u73b0\u95ee\u9898\uff0c\u8bf7\u68c0\u67e5\u9501{}\u60c5\u51b5", (Object[])new Object[]{"dcs:common:login:lock:" + tokenKey});
                    return null;
                }
            }
            RBucket tokenRb = redissonLock.getRedissonManager().getRedisson().getBucket("dcs:login:cache:login:token:" + tokenKey);
            if (null != tokenRb) {
                return (LoginTokenInfo)tokenRb.get();
            }
        }
        catch (Exception e) {
            log.error(ErrorUtil.getStackMsg((Exception)e));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCacheToken(String tokenKey, LoginTokenInfo loginTokenInfo) {
        try {
            RBucket tokenRb = redissonLock.getRedissonManager().getRedisson().getBucket("dcs:login:cache:login:token:" + tokenKey);
            tokenRb.set((Object)loginTokenInfo);
            tokenRb.expire((long)(null == loginTokenInfo.getCacheMinutes() || loginTokenInfo.getCacheMinutes() <= IntConstant.ZERO ? Constant.LOGIN_TOKEN_DEFAULT_MINUTES : loginTokenInfo.getCacheMinutes()).intValue(), TimeUnit.MINUTES);
        }
        catch (Exception e) {
            log.error(ErrorUtil.getStackMsg((Exception)e));
        }
        finally {
            redissonLock.release("dcs:common:login:lock:" + tokenKey);
        }
    }
}

