/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.core.resolve;

import cn.hutool.extra.spring.SpringUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.xforceplus.core.config.XxlJobConfig;
import com.xforceplus.core.exception.RemoteCallException;
import com.xforceplus.core.resolve.AbstractFileTypeImportBean;
import com.xforceplus.core.resolve.ResolveTask;
import com.xforceplus.core.resolve.dto.MessageRecordDto;
import com.xforceplus.core.resolve.excel.ExcelImportBean;
import com.xforceplus.core.resolve.html.NodeHtmlImportBean;
import com.xforceplus.core.resolve.json.JsonImportBean;
import com.xforceplus.core.resolve.txt.TxtImportBean;
import com.xforceplus.core.resolve.xml.XmlImportBean;
import com.xforceplus.utils.JavaScriptUtils;
import com.xforceplus.utils.JsonLib;
import com.xforceplus.utils.StringLib;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import kong.unirest.HttpRequestWithBody;
import kong.unirest.HttpResponse;
import kong.unirest.Unirest;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.MutablePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileAnalysisBean {
    private static Logger logger = LoggerFactory.getLogger(FileAnalysisBean.class);
    private ResolveTask dataSource = null;
    private String fileType;
    private String fileName;
    private String filePath;
    private String jsCode;
    private String data = "";
    MessageRecordDto dataSourceRecord = new MessageRecordDto();

    public FileAnalysisBean(String jsCode, ResolveTask dataSource) {
        this.jsCode = jsCode;
        this.dataSource = dataSource;
        this.initialize();
    }

    private void initialize() {
        if (this.jsCode == null) {
            logger.error("\u6ca1\u6709js\u89e3\u6790\u4ee3\u7801");
            throw new RuntimeException("\u6ca1\u6709js\u89e3\u6790\u4ee3\u7801");
        }
        this.filePath = this.dataSource.getFilePath();
        if (StringUtils.isNotEmpty((CharSequence)this.filePath)) {
            this.calcFileParam();
        }
    }

    private void calcFileParam() {
        this.fileName = this.filePath.substring(this.filePath.lastIndexOf("/") + 1);
        int pointIdx = StringLib.lastIndexOf((CharSequence)this.fileName, (CharSequence)".");
        this.fileType = StringLib.substring((String)this.fileName, (int)(pointIdx + 1));
    }

    private AbstractFileTypeImportBean getFileAnalysisBean() {
        AbstractFileTypeImportBean bean = null;
        bean = StringUtils.equalsAnyIgnoreCase((CharSequence)this.fileType, (CharSequence[])new CharSequence[]{"xls", "xlsx", "xlsm"}) ? new ExcelImportBean() : (StringLib.equalsIgnoreCase((CharSequence)this.fileType, (CharSequence)"json") ? new JsonImportBean() : (StringLib.equalsIgnoreCase((CharSequence)this.fileType, (CharSequence)"xml") ? new XmlImportBean() : (StringLib.equalsAnyIgnoreCase((CharSequence)this.fileType, (CharSequence[])new CharSequence[]{"html"}) ? new NodeHtmlImportBean() : new TxtImportBean())));
        return bean;
    }

    private boolean readDataFromFile(InputStream inputStream) throws Exception {
        logger.info("\u51c6\u5907\u89e3\u6790\u6570\u636e...");
        this.dataSourceRecord.appendContent("\u51c6\u5907\u89e3\u6790\u6570\u636e...");
        AbstractFileTypeImportBean importBean = this.getFileAnalysisBean();
        if (importBean == null) {
            logger.error("\u672a\u5339\u914d\u5230\u6587\u4ef6\u89e3\u6790\u89c4\u5219");
            this.dataSourceRecord.setSuccess(false);
            this.dataSourceRecord.appendContent("\u672a\u5339\u914d\u5230\u6587\u4ef6\u89e3\u6790\u89c4\u5219");
            return false;
        }
        importBean.handle(inputStream, this.dataSource);
        this.dataSourceRecord.appendContent("readDataFromFile improt handler");
        String js_code = StringLib.trim((String)this.jsCode);
        if (StringLib.isEmpty((CharSequence)js_code)) {
            js_code = "return data1;";
        }
        if (importBean instanceof NodeHtmlImportBean) {
            Map<String, Object> params = importBean.getDatas();
            String htmlContent = StringLib.toString(params.get("data1"));
            importBean = new NodeHtmlImportBean(htmlContent, js_code, this.dataSource);
            this.data = ((NodeHtmlImportBean)importBean).parseData();
        } else {
            Map<String, Object> params = importBean.getDatas();
            params.put("task", BeanUtils.describe((Object)this.dataSource));
            MutablePair<Object, String> pair = JavaScriptUtils.runAsFunc(js_code, params);
            Object result = pair.getLeft();
            if (StringLib.isNotEmpty((CharSequence)((CharSequence)pair.getRight()))) {
                this.dataSourceRecord.appendContent("JS\u4ee3\u7801:" + (String)pair.getRight());
                this.dataSourceRecord.appendContent("JS\u4ee3\u7801\u5f02\u5e38:" + js_code);
                throw new RuntimeException("js\u4ee3\u7801\u5f02\u5e38" + (String)pair.getRight());
            }
            if (result != null) {
                if (result instanceof JsonNode) {
                    if (result instanceof ArrayNode) {
                        List<JSONObject> parseList = JsonLib.parseArray((JsonNode)((ArrayNode)result), JSONObject.class);
                        if (CollectionUtils.isNotEmpty(parseList)) {
                            this.data = JSON.toJSONString(parseList, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
                        }
                    } else {
                        this.data = result.toString();
                    }
                } else {
                    this.data = result.toString();
                }
            }
            result = null;
            pair = null;
        }
        importBean = null;
        this.dataSourceRecord.appendContent("\u6570\u636e\u89e3\u6790\u5b8c\u6210");
        return true;
    }

    public void analysis() {
        File file = new File(this.filePath);
        if (file != null && file.exists() && StringUtils.isNotEmpty((CharSequence)this.filePath)) {
            try (FileInputStream inputStream = new FileInputStream(file);){
                this.analysisFile(inputStream);
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error(String.format("\u89e3\u6790\u6587\u4ef6\u51fa\u73b0\u5f02\u5e38:%s", e.getMessage()));
            }
        } else {
            logger.error("\u89e3\u6790\u6587\u4ef6\u4e0d\u5b58\u5728");
            throw new RuntimeException("\u89e3\u6790\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
    }

    private void save() {
        XxlJobConfig jobConfig = (XxlJobConfig)SpringUtil.getBean(XxlJobConfig.class);
        String adminAddresses = jobConfig.getAdminAddresses();
        HttpResponse httpResponse = ((HttpRequestWithBody)Unirest.post((String)(adminAddresses + "/api/fileSourceRecord")).header("Content-Type", "application/json")).body((Object)this.dataSourceRecord).asString();
        logger.debug("request fileSourceRecord status = {}, body = {}", (Object)httpResponse.getStatus(), httpResponse.getBody());
        if (!httpResponse.isSuccess()) {
            throw new RemoteCallException("\u4fdd\u5b58\u6587\u4ef6\u89e3\u6790\u8bb0\u5f55\u5931\u8d25! " + httpResponse.getStatusText());
        }
    }

    private void analysisFile(InputStream inputStream) {
        boolean flag = false;
        this.dataSourceRecord.appendContent("exec_step - 1");
        try {
            this.dataSourceRecord.appendContent("exec_step - 2");
            flag = this.readDataFromFile(inputStream);
        }
        catch (Exception e) {
            String msg = "\u8bfb\u53d6\u6587\u4ef6\u9519\u8bef";
            String stackTarce = String.format("\u8bfb\u53d6\u6587\u4ef6\u5f02\u5e38:%s", e.getMessage());
            this.dataSourceRecord.appendContent("exec_step - 3");
            logger.error(stackTarce);
            this.dataSourceRecord.setSuccess(false);
            this.dataSourceRecord.appendContent("error:" + stackTarce);
        }
        if (!flag) {
            return;
        }
        this.dataSourceRecord.appendContent("exec_step - 4");
        this.dataSourceRecord.setSuccess(true);
        this.dataSourceRecord.appendContent("data : " + this.data.substring(0, Math.min(100, this.data.length())));
        this.dataSourceRecord.appendContent("\u6587\u4ef6\u6570\u636e\u8bfb\u53d6\u5b8c\u6210");
    }

    public String getData() {
        return this.data;
    }
}

