/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.core.resolve;

import com.xforceplus.bean.JobBillTypeBean;
import com.xforceplus.janus.config.core.config.HttpConfig;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class JsManager {
    @Value(value="${janus.cloud.config:true}")
    private boolean janusConfigEnabled;

    public String getJs(String projectKey, String retailKey, JobBillTypeBean jobBillType) {
        if (!this.janusConfigEnabled) {
            return this.readJs(jobBillType);
        }
        return (String)HttpConfig.getConfig((String)String.format("resolver.js.%s.%s", jobBillType.getBillType().getKey(), jobBillType.getVersion()));
    }

    private String readJs(JobBillTypeBean jobBillType) {
        String name = String.format("%s.%s.js", jobBillType.getBillType().getKey(), jobBillType.getVersion());
        StringBuilder content = new StringBuilder();
        try (InputStream is = JsManager.class.getResourceAsStream("/js/" + name);
             BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));){
            String line;
            while ((line = reader.readLine()) != null) {
                content.append(line).append("\n");
            }
        }
        catch (IOException e) {
            throw new RuntimeException("\u672a\u83b7\u53d6\u5230\u672c\u5730js\u6587\u4ef6");
        }
        return content.toString();
    }
}

