/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.utils;

import com.gargoylesoftware.htmlunit.Page;
import com.xforceplus.account.domain.AccountTemplateDO;
import com.xforceplus.apollo.utils.ErrorUtil;
import com.xforceplus.core.config.CommonConfig;
import com.xforceplus.core.enums.BillsTypeEnum;
import com.xforceplus.exception.XxlCrawlerException;
import com.xforceplus.lock.redisson.RedissonLock;
import com.xforceplus.utils.BaseUtils;
import com.xforceplus.utils.DateUtil;
import com.xforceplus.utils.HtmlStrUtil;
import com.xforceplus.utils.SpringContext;
import com.xforceplus.utils.selenium.SeleniumUtils;
import com.xxl.job.core.log.XxlJobLogger;
import com.xxl.rpc.util.IpUtil;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipInputStream;
import javax.imageio.stream.FileImageOutputStream;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;
import org.springframework.core.env.Environment;
import sun.misc.BASE64Decoder;

public class FileUtil {
    static final Environment environment = SpringContext.getBean(Environment.class);
    public static final String TYPE_JPG = "jpg";
    public static final String TYPE_GIF = "gif";
    public static final String TYPE_PNG = "png";
    public static final String TYPE_BMP = "bmp";
    public static final String TYPE_UNKNOWN = "unknown";
    public static final String FORMAT_FILE_NAME = "%d.%s";
    private static byte[] b;
    private static String skipPdf;
    private static Logger logger;

    public static String saveFile(AccountTemplateDO account, String str, String extName, String suffix) {
        account.setFileSuffix(suffix);
        String filePath = FileUtil.getFilePath(account);
        String supplierCode = account.getSupplierCode();
        if (StringUtils.isNotBlank((CharSequence)extName)) {
            account.setSupplierCode(extName);
        }
        String fileName = FileUtil.getFileName(account);
        account.setSupplierCode(supplierCode);
        return FileUtil.saveFile(str, filePath, fileName, account);
    }

    public static String saveFile(AccountTemplateDO account, InputStream inputStream, String extName, String suffix) {
        account.setFileSuffix(suffix);
        String filePath = FileUtil.getFilePath(account);
        String supplierCode = account.getSupplierCode();
        if (StringUtils.isNotBlank((CharSequence)extName)) {
            account.setSupplierCode(extName);
        }
        String fileName = FileUtil.getFileName(account);
        account.setSupplierCode(supplierCode);
        return FileUtil.saveFile(inputStream, filePath, fileName, account);
    }

    public static void saveFileYonghui(AccountTemplateDO account, InputStream inputStream, String extName, String suffix) throws IOException {
        int available = inputStream.available();
        XxlJobLogger.log((String)("\u83b7\u53d6\u7f51\u7ad9\u6587\u4ef6\u7684\u6d41\u7684\u5927\u5c0f\u4e3a" + available), (Object[])new Object[0]);
        account.setFileSuffix(suffix);
        String filePath = FileUtil.getFilePath(account);
        String supplierCode = account.getSupplierCode();
        if (StringUtils.isNotBlank((CharSequence)extName)) {
            account.setSupplierCode(extName);
        }
        String fileName = FileUtil.getFileName(account);
        account.setSupplierCode(supplierCode);
        FileUtil.createDir(filePath);
        File file = new File(filePath, fileName + "_tmp");
        XxlJobLogger.log((String)("\u6587\u4ef6\u751f\u6210\u8def\u5f84:" + file.toString()), (Object[])new Object[0]);
        try {
            FileUtil.fileStreamWrite(inputStream, file);
            XxlJobLogger.log((String)("\u751f\u6210\u5b8c\u6587\u4ef6\u4e4b\u540e\u7684\u5927\u5c0f\u4e3a" + file.length()), (Object[])new Object[0]);
            if (file.exists() && file.length() == 0L) {
                file.delete();
                XxlJobLogger.log((String)">>>>>>>>>>> filePath : {} \u4e3a\u7a7a\uff0c\u79fb\u9664", (Object[])new Object[]{filePath.concat(File.separator).concat(fileName)});
            } else if ((long)available != file.length()) {
                file.delete();
                XxlJobLogger.log((String)("\u751f\u6210\u5b8c\u6587\u4ef6\u4e4b\u540e\u7684\u5927\u5c0f\u4e3a\u548c\u83b7\u53d6\u7f51\u7ad9\u6d41\u7684\u5927\u5c0f\u4e0d\u4e00\u81f4\uff0c\u5220\u9664" + filePath.concat(File.separator).concat(fileName)), (Object[])new Object[0]);
                for (int j = 0; j < 3; ++j) {
                    XxlJobLogger.log((String)("\u9012\u5f52\u8c03\u7528\u7b2c" + j + "\u6b21"), (Object[])new Object[0]);
                    FileUtil.saveFileYonghui(account, inputStream, extName, suffix);
                }
            } else {
                FileUtil.fileSaveByWhere(account, filePath, file);
            }
        }
        catch (IOException var10) {
            XxlJobLogger.log((String)var10.getMessage(), (Object[])new Object[0]);
        }
    }

    public static void saveFileYonghui(AccountTemplateDO account, InputStream inputStream, String extName, String batchNo, String suffix) throws IOException {
        int available = inputStream.available();
        XxlJobLogger.log((String)("\u83b7\u53d6\u7f51\u7ad9\u6587\u4ef6\u7684\u6d41\u7684\u5927\u5c0f\u4e3a" + available), (Object[])new Object[0]);
        account.setFileSuffix(suffix);
        String filePath = FileUtil.getFilePath(account);
        String supplierCode = account.getSupplierCode();
        if (StringUtils.isNotBlank((CharSequence)extName)) {
            account.setSupplierCode(extName);
        }
        String fileName = FileUtil.getFileNameBySuffix(account, batchNo);
        account.setSupplierCode(supplierCode);
        FileUtil.createDir(filePath);
        File file = new File(filePath, fileName + "_tmp");
        XxlJobLogger.log((String)("\u6587\u4ef6\u751f\u6210\u8def\u5f84:" + file.toString()), (Object[])new Object[0]);
        try {
            FileUtil.fileStreamWrite(inputStream, file);
            XxlJobLogger.log((String)("\u751f\u6210\u5b8c\u6587\u4ef6\u4e4b\u540e\u7684\u5927\u5c0f\u4e3a" + file.length()), (Object[])new Object[0]);
            if (file.exists() && file.length() == 0L) {
                file.delete();
                XxlJobLogger.log((String)">>>>>>>>>>> filePath : {} \u4e3a\u7a7a\uff0c\u79fb\u9664", (Object[])new Object[]{filePath.concat(File.separator).concat(fileName)});
            } else if ((long)available != file.length()) {
                file.delete();
                XxlJobLogger.log((String)("\u751f\u6210\u5b8c\u6587\u4ef6\u4e4b\u540e\u7684\u5927\u5c0f\u4e3a\u548c\u83b7\u53d6\u7f51\u7ad9\u6d41\u7684\u5927\u5c0f\u4e0d\u4e00\u81f4\uff0c\u5220\u9664" + filePath.concat(File.separator).concat(fileName)), (Object[])new Object[0]);
                for (int j = 0; j < 3; ++j) {
                    XxlJobLogger.log((String)("\u9012\u5f52\u8c03\u7528\u7b2c" + j + "\u6b21"), (Object[])new Object[0]);
                    FileUtil.saveFileYonghui(account, inputStream, extName, batchNo, suffix);
                }
            } else {
                FileUtil.fileSaveByWhere(account, filePath, file);
            }
        }
        catch (IOException var10) {
            XxlJobLogger.log((String)var10.getMessage(), (Object[])new Object[0]);
        }
    }

    public static String saveFile(String fileData, String filePath, String fileName, AccountTemplateDO account) {
        return FileUtil.saveFile(fileData, filePath, fileName, StandardCharsets.UTF_8, account);
    }

    public static String saveFile(String fileData, String filePath, String fileName, Charset charset, AccountTemplateDO account) {
        FileUtil.createDir(filePath);
        File file = new File(filePath, fileName + "_tmp");
        XxlJobLogger.log((String)("\u6587\u4ef6\u751f\u6210\u8def\u5f84:" + file.toString()), (Object[])new Object[0]);
        try {
            int i = 1;
            boolean flg = false;
            while (i <= 3 && !flg) {
                ++i;
                try {
                    OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(file), charset);
                    Throwable throwable = null;
                    try {
                        out.write(fileData);
                        out.flush();
                        out.close();
                        if (!file.exists() || file.length() <= 0L) continue;
                        flg = true;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (out == null) continue;
                        if (throwable != null) {
                            try {
                                out.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        out.close();
                    }
                }
                catch (Exception e) {
                    XxlJobLogger.log((String)("\u6587\u4ef6\u751f\u6210\u5f02\u5e38:" + ExceptionUtils.getMessage((Throwable)e)), (Object[])new Object[0]);
                }
            }
            FileUtil.fileSaveByWhere(filePath, fileName, account, file);
        }
        catch (Exception var4) {
            XxlJobLogger.log((String)("\u6587\u4ef6\u751f\u6210\u5f02\u5e38:" + ExceptionUtils.getMessage((Throwable)var4)), (Object[])new Object[0]);
        }
        return String.format("%s/%s", filePath, fileName);
    }

    private static void fileSaveByWhere(String filePath, String fileName, AccountTemplateDO account, File file) {
        if (file.exists() && file.length() == 0L) {
            file.delete();
            XxlJobLogger.log((String)">>>>>>>>>>> filePath : {} \u4e3a\u7a7a\uff0c\u79fb\u9664", (Object[])new Object[]{filePath.concat(File.separator).concat(fileName)});
        } else {
            Integer isBatchRename = account.getIsBatchRename();
            if (isBatchRename == null || isBatchRename == 0) {
                FileUtil.fileSaveByWhere(account, filePath, file);
            } else {
                FileUtil.fileSaveByWhereEntire(account, filePath, file);
            }
        }
    }

    private static void fileSaveByWhereEntire(AccountTemplateDO account, String filePath, File file) {
        if (file.exists()) {
            File nf = new File(filePath + "/" + file.getName());
            String fileName = nf.getName();
            FileUtil.isRepeatFile(account, filePath, fileName, nf);
        }
    }

    public static int getFileCount(AccountTemplateDO account) {
        File folder = new File(FileUtil.getFilePath(account));
        File[] list = folder.listFiles();
        int fileCount = 0;
        for (File file : list) {
            if (!file.isFile()) continue;
            ++fileCount;
        }
        return fileCount;
    }

    public static void renFile(AccountTemplateDO account) {
        File folder = new File(FileUtil.getFilePath(account));
        File[] list = folder.listFiles();
        if (list == null) {
            XxlJobLogger.log((String)(folder + "\u6587\u4ef6\u5939\u4e3a\u7a7a"), (Object[])new Object[0]);
        } else {
            for (File file : list) {
                if (!file.getName().contains("_tmp")) continue;
                String fileName = file.getName().replace("_tmp", "");
                File nf = new File(folder + "/" + fileName);
                file.renameTo(nf);
                XxlJobLogger.log((String)("\u6587\u4ef6\u540d\u6539\u4e3a" + nf.getName()), (Object[])new Object[0]);
            }
        }
    }

    public static void deleteFile(AccountTemplateDO account) {
        File[] list;
        File folder = new File(FileUtil.getFilePath(account));
        for (File file : list = folder.listFiles()) {
            XxlJobLogger.log((String)("\u6587\u4ef6\u540d\u6539\u4e3a" + file.getName() + "\u88ab\u5220\u9664\u4e86"), (Object[])new Object[0]);
            file.delete();
        }
    }

    public static void deleteFile(String filePath) {
        File file = new File(filePath);
        if (file.exists()) {
            boolean flag = file.delete();
            XxlJobLogger.log((String)("\u672c\u5730\u6587\u4ef6" + filePath + "\u5220\u9664\u72b6\u6001:" + flag), (Object[])new Object[0]);
        }
    }

    private static void fileSaveByWhere(AccountTemplateDO account, String filePath, File file) {
        if (file.exists()) {
            String tmp = file.getName().replace("_tmp", "");
            File nf = new File(filePath + "/" + tmp);
            boolean b = file.renameTo(nf);
            if (!b) {
                XxlJobLogger.log((String)"\u6587\u4ef6\u6539\u540d\u5931\u8d25oldName={},newName={},\u91cd\u8bd5\u4e2d...", (Object[])new Object[]{file.getName(), nf.getName()});
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (nf.exists()) {
                    nf.delete();
                    XxlJobLogger.log((String)"\u91cd\u8bd5\uff0c\u65e7\u6587\u4ef6\u5b58\u5728\uff0c\u5220\u9664\u65e7\u6587\u4ef6\uff0coldName={},newName={}", (Object[])new Object[]{file.getName(), nf.getName()});
                }
                if (file.renameTo(nf)) {
                    XxlJobLogger.log((String)"\u91cd\u8bd5\u6587\u4ef6\u6539\u540d\u6210\u529foldName={},newName={}", (Object[])new Object[]{file.getName(), nf.getName()});
                }
            }
            XxlJobLogger.log((String)("\u6587\u4ef6\u540d\u6539\u4e3a" + nf.getName()), (Object[])new Object[0]);
            String fileName = nf.getName();
            FileUtil.isRepeatFile(account, filePath, fileName, nf);
        }
    }

    private static void isRepeatFile(AccountTemplateDO account, String filePath, String fileName, File nf) {
        Integer repeatFile = account.getRepeatFile();
        if (repeatFile == null || repeatFile == 0) {
            String fileMd5 = FileUtil.getFileMd5(nf);
            String lockName = "pdp:file_md5:md5_" + fileMd5;
            RedissonLock redissonLock = SpringContext.getBean(RedissonLock.class);
            Boolean lock1 = redissonLock.isLock(lockName);
            if (lock1.booleanValue()) {
                nf.delete();
                XxlJobLogger.log((String)">>>>>>>>>>> \u6587\u4ef6\u5df2\u5b58\u5728,\u6839\u636e\u6587\u4ef6MD5\u8fc7\u6ee4\u89c4\u5219,\u5220\u9664\u6587\u4ef6. filePath: {}", (Object[])new Object[]{filePath.concat(File.separator).concat(fileName)});
                boolean flag = BooleanUtils.toBooleanDefaultIfNull((Boolean)account.getPrintStatus(), (boolean)false);
                if (flag) {
                    FileUtil.markPDF(account);
                }
            } else {
                XxlJobLogger.log((String)">>>>>>>>>>> filePath: {}", (Object[])new Object[]{filePath.concat(File.separator).concat(fileName)});
            }
        } else {
            XxlJobLogger.log((String)">>>>>>>>>>> \u91c7\u96c6\u914d\u7f6e\u5141\u8bb8\u6587\u4ef6MD5\u91cd\u590d\u4e5f\u751f\u6210\u65b0\u6587\u4ef6,repeatFile:{},-->filePath: {}", (Object[])new Object[]{repeatFile, filePath.concat(File.separator).concat(fileName)});
        }
    }

    @Deprecated
    private static void sendMessageHandle(String msgTmp, String billsType) {
        String billType = billsType.toLowerCase();
        if (billType.equals(BillsTypeEnum.PO.getKey())) {
            XxlJobLogger.log((String)"MQ\u53d1\u9001,msg:{} ", (Object[])new Object[]{msgTmp});
        } else {
            XxlJobLogger.log((String)"MQ\u53d1\u9001,msg:{} ", (Object[])new Object[]{msgTmp});
        }
    }

    public static String getFileMd5(File file) {
        byte[] bytes_ = new byte[]{};
        try {
            if (file.exists()) {
                bytes_ = FileUtils.readFileToByteArray((File)file);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return DigestUtils.md5Hex((byte[])bytes_);
    }

    public static String saveFile(InputStream inputStream, String filePath, String fileName, AccountTemplateDO account) {
        FileUtil.createDir(filePath);
        File file = new File(filePath, fileName + "_tmp");
        XxlJobLogger.log((String)("\u6587\u4ef6\u751f\u6210\u8def\u5f84:" + file.toString()), (Object[])new Object[0]);
        try {
            FileUtil.fileStreamWrite(inputStream, file);
            FileUtil.fileSaveByWhere(filePath, fileName, account, file);
        }
        catch (Exception var10) {
            XxlJobLogger.log((String)var10.getMessage(), (Object[])new Object[0]);
        }
        return String.format("%s/%s", filePath, fileName);
    }

    public static void saveFile(File oldFile, String filePath, String fileName, AccountTemplateDO account) {
        FileUtil.createDir(filePath);
        File file = new File(filePath, fileName + "_tmp");
        XxlJobLogger.log((String)("\u6587\u4ef6\u751f\u6210\u8def\u5f84:" + file.toString()), (Object[])new Object[0]);
        try {
            boolean b = oldFile.renameTo(file);
            if (!b) {
                XxlJobLogger.log((String)"\u6587\u4ef6\u6539\u540d\u5931\u8d25oldName={},newName={},\u91cd\u8bd5\u4e2d...", (Object[])new Object[]{oldFile.getName(), file.getName()});
                Thread.sleep(1000L);
                if (oldFile.renameTo(file)) {
                    XxlJobLogger.log((String)"\u91cd\u8bd5\u6587\u4ef6\u6539\u540d\u6210\u529foldName={},newName={}", (Object[])new Object[]{oldFile.getName(), file.getName()});
                }
            }
            FileUtil.fileSaveByWhere(filePath, fileName, account, file);
        }
        catch (Exception var10) {
            XxlJobLogger.log((String)var10.getMessage(), (Object[])new Object[0]);
        }
    }

    private static void fileStreamWrite(InputStream inputStream, File file) {
        int i = 1;
        boolean flg = false;
        while (i <= 3 && !flg) {
            ++i;
            try {
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                Throwable throwable = null;
                try {
                    int size;
                    byte[] buf = new byte[1024];
                    while (-1 != (size = inputStream.read(buf))) {
                        bufferedOutputStream.write(buf, 0, size);
                        bufferedOutputStream.flush();
                    }
                    bufferedOutputStream.close();
                    inputStream.close();
                    if (!file.exists() || file.length() <= 0L) continue;
                    flg = true;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (bufferedOutputStream == null) continue;
                    if (throwable != null) {
                        try {
                            bufferedOutputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    bufferedOutputStream.close();
                }
            }
            catch (Exception e) {
                XxlJobLogger.log((String)("\u6587\u4ef6\u751f\u6210\u5f02\u5e38:" + ExceptionUtils.getMessage((Throwable)e)), (Object[])new Object[0]);
            }
        }
    }

    public static void byte2image(byte[] picture_data, String filePath, String fileName) {
        if (picture_data.length < 3 || filePath.equals("")) {
            return;
        }
        try {
            FileImageOutputStream imageOutput = new FileImageOutputStream(new File(filePath.concat(fileName)));
            imageOutput.write(picture_data, 0, picture_data.length);
            imageOutput.close();
            XxlJobLogger.log((String)("Make Picture success,Please find image in " + filePath), (Object[])new Object[0]);
        }
        catch (Exception ex) {
            XxlJobLogger.log((String)("Exception: " + ex), (Object[])new Object[0]);
            ex.printStackTrace();
        }
    }

    public static String saveFile(InputStream inputStream, AccountTemplateDO account) {
        String filePath = FileUtil.getFilePath(account);
        String fileName = FileUtil.getFileName(account);
        return FileUtil.saveFile(inputStream, filePath, fileName, account);
    }

    public static void createDir(String filePath) {
        try {
            File file = new File(filePath);
            if (!file.exists()) {
                boolean i = file.mkdirs();
                if (i) {
                    XxlJobLogger.log((String)"\u5c42\u7ea7\u6587\u4ef6\u5939\u521b\u5efa\u6210\u529f\uff01", (Object[])new Object[0]);
                } else {
                    XxlJobLogger.log((String)"\u5c42\u7ea7\u6587\u4ef6\u5939\u521b\u5efa\u5931\u8d25\uff01", (Object[])new Object[0]);
                }
            }
            file = null;
        }
        catch (Exception e) {
            Object file = null;
            e.printStackTrace();
        }
    }

    public static String getFilePath(AccountTemplateDO account) {
        String projectKey = account.getProjectKey();
        String retailKey = account.getRetailKey();
        String accountName = account.getAccountName();
        String billsType = account.getBillsType();
        return CommonConfig.DCS_FILE_ROOT_PATH + "/bk/" + projectKey + "/" + retailKey + "/" + accountName + "/" + billsType;
    }

    public static String getRetailFilePath(AccountTemplateDO account) {
        String projectKey = account.getProjectKey();
        String retailKey = account.getRetailKey();
        return CommonConfig.DCS_FILE_ROOT_PATH + "/bk/" + projectKey + "/" + retailKey;
    }

    public static String getSameFileName(AccountTemplateDO account) {
        return String.format("%s_%s_%s_%s_Capture_data_%s", FileUtil.handlePathVal(account.getProjectKey()), FileUtil.handlePathVal(account.getRetailKey()), FileUtil.handlePathVal(account.getOrderNo()), new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()), FileUtil.getFileName(account));
    }

    private static String handlePathVal(String val) {
        if (StringUtils.isBlank((CharSequence)val)) {
            return null == val ? "null" : "";
        }
        return val.replaceAll("[_-]", ",");
    }

    public static String getFileName(AccountTemplateDO account) {
        String projectKey = account.getProjectKey();
        String retailKey = account.getRetailKey();
        String accountName = account.getAccountName();
        String area = account.getArea();
        accountName = StringUtils.isNotEmpty((CharSequence)area) ? accountName + "," + area : accountName;
        String billsType = account.getBillsType();
        String fileSuffix = account.getFileSuffix();
        String supplierCode = account.getSupplierCode();
        supplierCode = StringUtils.isNotEmpty((CharSequence)supplierCode) ? supplierCode + "-" : "";
        String storeCode = account.getStoreCode();
        storeCode = StringUtils.isNotEmpty((CharSequence)storeCode) ? storeCode + "-" : "";
        String orderNo = account.getOrderNo();
        orderNo = StringUtils.isNotEmpty((CharSequence)orderNo) ? orderNo + "-" : "";
        Integer isGenerateBatch = account.getIsGenerateBatch();
        if (isGenerateBatch != null && isGenerateBatch == 1) {
            String parentCode = account.getParentCode();
            if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{projectKey, retailKey, billsType, parentCode})) {
                throw new RuntimeException("\u6587\u4ef6\u540d\u6279\u6b21\u53f7\u9519\u8bef!");
            }
            return projectKey + retailKey + billsType + "-" + accountName + "-" + supplierCode + storeCode + orderNo + System.currentTimeMillis() + FileUtil.getBatchNo(projectKey, retailKey, billsType, parentCode) + fileSuffix;
        }
        return projectKey + retailKey + billsType + "-" + accountName + "-" + supplierCode + storeCode + orderNo + System.currentTimeMillis() + fileSuffix;
    }

    private static String getBatchNo(String projectKey, String retailKey, String billsType, String parentCode) {
        String content = projectKey + retailKey + billsType + parentCode;
        String md = DigestUtils.md5Hex((String)content).substring(8, 24);
        return "$" + md;
    }

    public static String getFileNameBySuffix(AccountTemplateDO account, String suffix) {
        String projectKey = account.getProjectKey();
        String retailKey = account.getRetailKey();
        String accountName = account.getAccountName();
        String area = account.getArea();
        accountName = StringUtils.isNotEmpty((CharSequence)area) ? accountName + "," + area : accountName;
        String billsType = account.getBillsType();
        String fileSuffix = account.getFileSuffix();
        String supplierCode = account.getSupplierCode();
        supplierCode = StringUtils.isNotEmpty((CharSequence)supplierCode) ? supplierCode + "-" : "";
        String storeCode = account.getStoreCode();
        storeCode = StringUtils.isNotEmpty((CharSequence)storeCode) ? storeCode + "-" : "";
        String orderNo = account.getOrderNo();
        orderNo = StringUtils.isNotEmpty((CharSequence)orderNo) ? orderNo + "-" : "";
        return projectKey + retailKey + billsType + "-" + accountName + "-" + supplierCode + storeCode + orderNo + suffix + fileSuffix;
    }

    public static String getPDFFileName(AccountTemplateDO account, String orderId) {
        String projectKey = account.getProjectKey();
        String retailKey = account.getRetailKey();
        String billsType = account.getBillsType();
        String accountName = account.getAccountName();
        String area = account.getArea();
        accountName = StringUtils.isNotEmpty((CharSequence)area) ? accountName + "," + area : accountName;
        String supplierCode = account.getSupplierCode();
        supplierCode = StringUtils.isNotEmpty((CharSequence)supplierCode) ? supplierCode + "-" : "";
        String storeCode = account.getStoreCode();
        storeCode = StringUtils.isNotEmpty((CharSequence)storeCode) ? storeCode + "-" : "";
        Map<String, String> postParam = account.getPostParam();
        if (postParam != null && !postParam.isEmpty() && postParam.containsKey("timestamps") && postParam.get("timestamps").equals("1")) {
            orderId = orderId + "-" + System.currentTimeMillis();
        }
        return projectKey + retailKey + billsType + "-" + accountName + "-" + supplierCode + storeCode + orderId;
    }

    public static String getPDFFilePath(AccountTemplateDO account) {
        String projectKey = account.getProjectKey();
        String retailKey = account.getRetailKey();
        String accountName = account.getAccountName();
        String billsType = account.getBillsType();
        return CommonConfig.DCS_FILE_ROOT_PATH + "/success/" + LocalDate.now() + "/PDF/" + projectKey + "/" + retailKey + "/" + accountName + "/" + billsType;
    }

    public static String getPDFFilePath(AccountTemplateDO account, int minusDays) {
        String projectKey = account.getProjectKey();
        String retailKey = account.getRetailKey();
        String accountName = account.getAccountName();
        String billsType = account.getBillsType();
        return CommonConfig.DCS_FILE_ROOT_PATH + "/success/" + LocalDate.now().minusDays(minusDays) + "/PDF/" + projectKey + "/" + retailKey + "/" + accountName + "/" + billsType;
    }

    public static String checksumMD5(String filepath) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("MD5");
            FileInputStream fis = new FileInputStream(filepath);
            Object object = null;
            try {
                int nread;
                byte[] buffer = new byte[1024];
                while ((nread = ((InputStream)fis).read(buffer)) != -1) {
                    md.update(buffer, 0, nread);
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (fis != null) {
                    if (object != null) {
                        try {
                            ((InputStream)fis).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        ((InputStream)fis).close();
                    }
                }
            }
        }
        catch (IOException | NoSuchAlgorithmException e) {
            e.printStackTrace();
            XxlJobLogger.log((String)"FileCheckSumMD5Util{}", (Object[])new Object[]{e.getMessage()});
        }
        StringBuilder result = new StringBuilder();
        for (Object b : (Object)md.digest()) {
            result.append(String.format("%02x", (byte)b));
        }
        return result.toString();
    }

    public static String recoding(Page page) {
        String content = "";
        String newContent = "";
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            String charset = page.getWebResponse().getContentCharset().name();
            InputStream inputStream = page.getWebResponse().getContentAsStream();
            byte[] buffer = new byte[2048];
            int length = 0;
            while ((length = inputStream.read(buffer)) != -1) {
                bos.write(buffer, 0, length);
            }
            inputStream.close();
            content = new String(bos.toByteArray(), charset);
            newContent = HtmlStrUtil.replaceStyAndScrAndLinkAndImg(content);
        }
        catch (Exception e) {
            throw new XxlCrawlerException(e.getMessage());
        }
        return newContent;
    }

    public static String renameFile(File file, AccountTemplateDO account) {
        String filePath = FileUtil.getFilePath(account);
        String fileName = FileUtil.getFileName(account);
        FileUtil.renameFile(file, filePath, fileName, account);
        return filePath + File.separator + fileName;
    }

    public static Boolean isDirectoryList(File file) {
        File[] fs;
        Boolean bl = false;
        for (File o : fs = file.listFiles()) {
            if (!o.isDirectory()) continue;
            bl = true;
        }
        return bl;
    }

    public static void renameFile(File file, String filePath, String fileName, AccountTemplateDO account) {
        FileUtil.createDir(filePath);
        File nf = new File(filePath.concat(File.separator).concat(fileName));
        boolean bool = file.renameTo(nf);
        XxlJobLogger.log((String)">>>>>>>>>>> filePath : {}, success : {}", (Object[])new Object[]{filePath.concat(File.separator).concat(fileName), bool});
        if (bool) {
            FileUtil.isRepeatFile(account, filePath, fileName, nf);
        }
    }

    public static String getIpproxyFilePath(String path) {
        return CommonConfig.DCS_FILE_ROOT_PATH + path;
    }

    public static String getIpproxyFileName() {
        return "ipproxy-" + DateUtil.format(new Date(), "yyyyMM") + ".log";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void appendLog(String filePath, String logFileName, String appendLog) {
        if (logFileName != null && logFileName.trim().length() != 0) {
            FileOutputStream fos = null;
            try {
                FileUtil.createDir(filePath);
                File logFile = new File(logFileName);
                if (!logFile.exists()) {
                    logFile.createNewFile();
                }
                if (appendLog == null) {
                    appendLog = "";
                }
                appendLog = appendLog + "\r\n";
                fos = new FileOutputStream(logFile, true);
                fos.write(appendLog.getBytes("utf-8"));
                fos.flush();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private static void markPDF(AccountTemplateDO account) {
        boolean flag = BooleanUtils.toBooleanDefaultIfNull((Boolean)account.getPrintStatus(), (boolean)false);
        if (flag) {
            Map<Object, Object> otherConfig = account.getOtherConfig();
            if (otherConfig == null) {
                otherConfig = new HashMap<Object, Object>();
            }
            otherConfig.put(skipPdf, true);
            account.setOtherConfig(otherConfig);
        }
    }

    public static Boolean skipPdf(AccountTemplateDO account) {
        Map<Object, Object> otherConfig = account.getOtherConfig();
        return otherConfig != null && BooleanUtils.toBooleanDefaultIfNull((Boolean)((Boolean)otherConfig.remove(skipPdf)), (boolean)false);
    }

    public static void saveFileLog(String path, String appendLogPattern, Object ... appendLogArguments) {
        FormattingTuple ft = MessageFormatter.arrayFormat((String)appendLogPattern, (Object[])appendLogArguments);
        String appendLog = ft.getMessage();
        String filePath = FileUtil.getIpproxyFilePath(path);
        String fileName = FileUtil.getIpproxyFileName();
        StringBuilder sb = new StringBuilder();
        sb.append(DateUtil.formatDateTime(new Date())).append("   ").append(IpUtil.getIp()).append("  ").append(environment.getProperty("server.port")).append("   ").append(appendLog);
        FileUtil.appendLog(filePath, filePath + File.separator + fileName, sb.toString());
    }

    public static InputStream captureElement(String img, String accountName, String imgType, AccountTemplateDO account) throws Exception {
        String projectKey = account.getProjectKey();
        String retailKey = account.getRetailKey();
        String billsType = account.getBillsType();
        String tempFile = SeleniumUtils.USER_DOWNLOAD_DIR + File.separator + projectKey + File.separator + retailKey + File.separator + accountName + File.separator + billsType + File.separator;
        boolean b = FileUtil.GenerateImage(img, tempFile + accountName + "." + imgType);
        if (b) {
            XxlJobLogger.log((String)"\u56fe\u7247\u751f\u6210\u6210\u529f", (Object[])new Object[0]);
            FileInputStream inputStream = new FileInputStream(tempFile + accountName + "." + imgType);
            return inputStream;
        }
        XxlJobLogger.log((String)"\u56fe\u7247\u751f\u6210\u5931\u8d25", (Object[])new Object[0]);
        return null;
    }

    public static boolean GenerateImage(String base64str, String savepath) {
        if (base64str == null) {
            return false;
        }
        BASE64Decoder decoder = new BASE64Decoder();
        try {
            byte[] b = decoder.decodeBuffer(base64str);
            for (int i = 0; i < b.length; ++i) {
                if (b[i] >= 0) continue;
                int n = i;
                b[n] = (byte)(b[n] + 256);
            }
            File imgFile = new File(savepath);
            if (!imgFile.getParentFile().exists()) {
                imgFile.getParentFile().mkdirs();
            }
            FileOutputStream out = new FileOutputStream(savepath);
            ((OutputStream)out).write(b);
            out.flush();
            ((OutputStream)out).close();
            return true;
        }
        catch (Exception e) {
            XxlJobLogger.log((String)ErrorUtil.getStackMsg((Exception)e), (Object[])new Object[0]);
            return false;
        }
    }

    public static String bytesToHexString(byte[] src) {
        StringBuilder stringBuilder = new StringBuilder();
        if (src == null || src.length <= 0) {
            return null;
        }
        for (int i = 0; i < src.length; ++i) {
            int v = src[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(hv);
        }
        return stringBuilder.toString();
    }

    public static String getPicType(InputStream fis) {
        b = new byte[4];
        try {
            fis.read(b, 0, b.length);
            String type = FileUtil.bytesToHexString(b).toUpperCase();
            if (type.contains("FFD8FF")) {
                return TYPE_JPG;
            }
            if (type.contains("89504E47")) {
                return TYPE_PNG;
            }
            if (type.contains("47494638")) {
                return TYPE_GIF;
            }
            if (type.contains("424D")) {
                return TYPE_BMP;
            }
            return TYPE_UNKNOWN;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void isDirPathExist(File dir) {
        if (dir.isDirectory()) {
            XxlJobLogger.log((String)(dir + "\u6587\u4ef6\u5939\u5df2\u5b58\u5728"), (Object[])new Object[0]);
        } else {
            XxlJobLogger.log((String)(dir + "\u6587\u4ef6\u5939\u4e0d\u5b58\u5728"), (Object[])new Object[0]);
            dir.mkdir();
            XxlJobLogger.log((String)("\u521b\u5efa\u6587\u4ef6\u5939" + dir), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveImageToDisk(InputStream inputStream, String diskPath, String type, String name) {
        String picType = FileUtil.getPicType(inputStream);
        XxlJobLogger.log((String)("\u56fe\u7247\u683c\u5f0f\u4e3a\uff1a" + type), (Object[])new Object[0]);
        String fileName = name + type;
        XxlJobLogger.log((String)("\u56fe\u7247\u540d\u5b57\u4e3a\uff1a" + fileName), (Object[])new Object[0]);
        byte[] data = new byte[1024];
        int len = 0;
        FileOutputStream fileOutputStream = null;
        try {
            File dirFile = new File(diskPath);
            FileUtil.isDirPathExist(dirFile);
            fileOutputStream = new FileOutputStream(new File(dirFile, fileName));
            fileOutputStream.write(b, 0, b.length);
            while ((len = inputStream.read(data)) != -1) {
                fileOutputStream.write(data, 0, len);
            }
            fileOutputStream.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        XxlJobLogger.log((String)(fileName + "\u5199\u5230\u672c\u5730\u78c1\u76d8\u5b8c\u6210"), (Object[])new Object[0]);
    }

    public static boolean isZipEmpty(InputStream inputStream) {
        boolean flag = true;
        try {
            ZipInputStream zin = new ZipInputStream(inputStream);
            flag = zin.getNextEntry() == null;
            zin.closeEntry();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFileContent(File file, byte[] data) {
        if (!file.exists()) {
            file.getParentFile().mkdirs();
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            fos.write(data);
            fos.flush();
        }
        catch (Exception var12) {
            logger.error(var12.getMessage(), (Throwable)var12);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException var11) {
                    logger.error(var11.getMessage(), (Throwable)var11);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFileContent(File file) {
        Long filelength = file.length();
        byte[] filecontent = new byte[filelength.intValue()];
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            in.read(filecontent);
            in.close();
        }
        catch (Exception var13) {
            logger.error(var13.getMessage(), (Throwable)var13);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException var12) {
                    logger.error(var12.getMessage(), (Throwable)var12);
                }
            }
        }
        return filecontent;
    }

    public static boolean deleteRecursively(File root) {
        if (root != null && root.exists()) {
            File[] children;
            if (root.isDirectory() && (children = root.listFiles()) != null) {
                File[] var2 = children;
                int var3 = children.length;
                for (int var4 = 0; var4 < var3; ++var4) {
                    File child = var2[var4];
                    FileUtil.deleteRecursively(child);
                }
            }
            return root.delete();
        }
        return false;
    }

    public static String extractLastPart(String filename, String fix) {
        int lastDashIndex = filename.lastIndexOf(45);
        int dotIndex = filename.lastIndexOf(46);
        if (lastDashIndex != -1 && dotIndex != -1 && lastDashIndex < dotIndex) {
            return filename.substring(lastDashIndex + 1, dotIndex);
        }
        Pattern pattern = Pattern.compile(".*-([^-.]+)\\//" + fix + "$");
        Matcher matcher = pattern.matcher(filename);
        if (matcher.find()) {
            return matcher.group(1);
        }
        throw new IllegalArgumentException("\u6587\u4ef6\u540d\u683c\u5f0f\u4e0d\u7b26\u5408\u8981\u6c42");
    }

    public static boolean isTimestamp(String str) {
        if (!str.matches("\\d+")) {
            return false;
        }
        if (str.length() != 10 && str.length() != 13) {
            return false;
        }
        try {
            long timestamp = Long.parseLong(str);
            long minTimestampSec = 946684800L;
            long maxTimestampSec = 1924991999L;
            if (str.length() == 10) {
                return timestamp >= minTimestampSec && timestamp <= maxTimestampSec;
            }
            long minTimestampMs = minTimestampSec * 1000L;
            long maxTimestampMs = maxTimestampSec * 1000L;
            return timestamp >= minTimestampMs && timestamp <= maxTimestampMs;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean waitForDownloadComplete(String downloadDir, int timeoutSeconds) throws Exception {
        File dir = new File(downloadDir);
        long timeoutMillis = (long)timeoutSeconds * 1000L;
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime < timeoutMillis) {
            File[] files = dir.listFiles();
            if (files != null) {
                HashSet<String> fs = new HashSet<String>();
                for (File file : files) {
                    if (!file.isFile()) continue;
                    fs.add(file.getAbsolutePath());
                }
                if (CollectionUtils.isEmpty(fs)) {
                    Thread.sleep(BaseUtils.randomLong(10, 5));
                    continue;
                }
                for (File file : files) {
                    if (!file.isFile()) continue;
                    long initialSize = file.length();
                    Thread.sleep(BaseUtils.randomLong(15, 10));
                    long currentSize = file.length();
                    if (initialSize != currentSize || currentSize <= 0L) continue;
                    String finalFilePath = file.getAbsolutePath();
                    try (FileInputStream ignored = new FileInputStream(file);){
                        fs.remove(finalFilePath);
                    }
                    catch (IOException e) {
                        XxlJobLogger.log((String)"\u6587\u4ef6\u53ef\u80fd\u6b63\u5728\u88ab\u5199\u5165\uff0c\u7ee7\u7eed\u7b49\u5f85", (Object[])new Object[0]);
                    }
                }
                if (CollectionUtils.isEmpty(fs)) {
                    XxlJobLogger.log((String)"\u6587\u4ef6\u68c0\u6d4b\u5b8c\u6210\uff0c\u6587\u4ef6\u5df2\u5c31\u7eea", (Object[])new Object[0]);
                    Thread.sleep(BaseUtils.randomLong(5, 3));
                    return true;
                }
            }
            Thread.sleep(BaseUtils.randomLong(5, 3));
        }
        XxlJobLogger.log((String)"\u6587\u4ef6\u68c0\u6d4b\u5931\u8d25\uff0c\u8fd4\u56de", (Object[])new Object[0]);
        return false;
    }

    public static boolean waitForDownloadCompleteBySuffix(String downloadDir, int timeoutSeconds, String suffix) throws Exception {
        File dir = new File(downloadDir);
        long timeoutMillis = (long)timeoutSeconds * 1000L;
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime < timeoutMillis) {
            File[] files = dir.listFiles((dirFile, name) -> name.endsWith(suffix));
            if (files != null) {
                HashSet<String> fs = new HashSet<String>();
                for (File file : files) {
                    if (!file.isFile()) continue;
                    fs.add(file.getAbsolutePath());
                }
                if (CollectionUtils.isEmpty(fs)) {
                    Thread.sleep(BaseUtils.randomLong(10, 5));
                    continue;
                }
                for (File file : files) {
                    XxlJobLogger.log((String)"waitForDownloadCompleteBySuffix:{}", (Object[])new Object[]{file.getAbsolutePath()});
                    if (!file.isFile()) continue;
                    long initialSize = file.length();
                    Thread.sleep(BaseUtils.randomLong(15, 10));
                    long currentSize = file.length();
                    if (initialSize != currentSize || currentSize <= 0L) continue;
                    String finalFilePath = file.getAbsolutePath();
                    try (FileInputStream ignored = new FileInputStream(file);){
                        fs.remove(finalFilePath);
                        XxlJobLogger.log((String)"waitForDownloadCompleteBySuffix:{}-ok", (Object[])new Object[]{file.getAbsolutePath()});
                    }
                    catch (IOException e) {
                        XxlJobLogger.log((String)"\u6587\u4ef6\u53ef\u80fd\u6b63\u5728\u88ab\u5199\u5165\uff0c\u7ee7\u7eed\u7b49\u5f85", (Object[])new Object[0]);
                    }
                }
                if (CollectionUtils.isEmpty(fs)) {
                    XxlJobLogger.log((String)"\u6587\u4ef6\u68c0\u6d4b\u5b8c\u6210\uff0c\u6587\u4ef6\u5df2\u5c31\u7eea", (Object[])new Object[0]);
                    Thread.sleep(BaseUtils.randomLong(5, 3));
                    return true;
                }
            }
            Thread.sleep(BaseUtils.randomLong(5, 3));
        }
        XxlJobLogger.log((String)"\u6587\u4ef6\u68c0\u6d4b\u5931\u8d25\uff0c\u8fd4\u56de", (Object[])new Object[0]);
        return false;
    }

    public static boolean ensureDirectoryExists(String directoryPath) {
        try {
            Path path = Paths.get(directoryPath, new String[0]);
            if (!Files.exists(path, new LinkOption[0])) {
                Files.createDirectories(path, new FileAttribute[0]);
                XxlJobLogger.log((String)("\u521b\u5efa\u76ee\u5f55: " + directoryPath), (Object[])new Object[0]);
            }
            return true;
        }
        catch (IOException e) {
            XxlJobLogger.log((String)("\u521b\u5efa\u76ee\u5f55\u5931\u8d25: " + directoryPath + ", \u9519\u8bef: " + ErrorUtil.getStackMsg((Exception)e)), (Object[])new Object[0]);
            return false;
        }
    }

    public static void main(String[] args) {
        try {
            String filePath = "/Users/gongjianfeng/Downloads/logo-yh.png";
            String base64String = FileUtil.encodePngToBase64(filePath);
            System.out.println("data:image/png;base64," + base64String);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String encodePngToBase64(String filePath) throws IOException {
        byte[] fileContent = Files.readAllBytes(Paths.get(filePath, new String[0]));
        return Base64.getEncoder().encodeToString(fileContent);
    }

    static {
        skipPdf = "skipNextPDF";
        logger = LoggerFactory.getLogger(FileUtil.class);
    }
}

