/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.utils;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.HttpMethod;
import com.gargoylesoftware.htmlunit.HttpWebConnection;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.ProxyConfig;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebConnection;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.util.Cookie;
import com.xforceplus.account.AbstractLoginSys;
import com.xforceplus.account.domain.AccountTemplateDO;
import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.apollo.utils.MD5Util;
import com.xforceplus.proxy.ProxyIpFactory;
import com.xforceplus.proxy.domain.IpResponse;
import com.xforceplus.utils.PageUtil;
import com.xforceplus.utils.selenium.SeleniumUtils;
import com.xxl.job.core.log.XxlJobLogger;
import java.lang.reflect.Field;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public class WebClientUtil {
    public static WebClient getWebClient(String pluginName, boolean forbidden) {
        WebClient webClient = new WebClient(BrowserVersion.CHROME);
        webClient.getOptions().setThrowExceptionOnFailingStatusCode(false);
        webClient.getOptions().setThrowExceptionOnScriptError(false);
        webClient.getOptions().setCssEnabled(false);
        if (forbidden) {
            webClient.getOptions().setJavaScriptEnabled(false);
        }
        webClient.getOptions().setUseInsecureSSL(true);
        webClient.getOptions().setTimeout(600000);
        webClient.getOptions().setPrintContentOnFailingStatusCode(false);
        webClient.getOptions().setMaxInMemory(0x6400000);
        return webClient;
    }

    public static WebClient getWebClient(String pluginName) {
        return WebClientUtil.getWebClient(pluginName, true);
    }

    public static WebClient getWebClient(String pluginName, boolean forbidden, AccountTemplateDO account) {
        IpResponse remoteIpProxy;
        WebClient webClient = WebClientUtil.getWebClient(pluginName, forbidden);
        if (null != account && account.getIpProxy() != null && account.getIpProxy() == 1 && (SeleniumUtils.ENV.contains("prod") || SeleniumUtils.ENV.contains("sit")) && null != (remoteIpProxy = ProxyIpFactory.getRemoteIpProxy(account.getAccountId(), account.getProxyArea(), MD5Util.getHexMD5Str((String)(StringUtils.isNotBlank((CharSequence)account.getRetailKey()) ? account.getRetailKey() : account.getSiteUrl()), (int)32), account.getProxyForm(), "local_ip_proxy_key_" + AbstractLoginSys.loginCacheKey(account))) && StringUtils.isNotBlank((CharSequence)remoteIpProxy.getIp())) {
            String proxyIp = remoteIpProxy.getIp();
            String proxyPort = remoteIpProxy.getPort();
            XxlJobLogger.log((String)"\u4f7f\u7528\u7f13\u5b58\u4e2d\u6709\u6548\u4ee3\u7406{}:{}", (Object[])new Object[]{proxyIp, proxyPort});
            webClient.getOptions().setProxyConfig(new ProxyConfig(proxyIp, Integer.parseInt(proxyPort)));
            XxlJobLogger.log((String)"\u8ba4\u8bc1\u4fe1\u606f\uff1a{}", (Object[])new Object[]{remoteIpProxy.getBasicProxy()});
            if (StringUtils.isNotBlank((CharSequence)remoteIpProxy.getBasicProxy())) {
                webClient.addRequestHeader("Proxy-Authorization", remoteIpProxy.getBasicProxy());
            }
        }
        return webClient;
    }

    public static void ipProxyRenew(WebClient webClient, AccountTemplateDO account) throws Exception {
        if (null != account && account.getIpProxy() != null && account.getIpProxy() == 1 && (SeleniumUtils.ENV.contains("prod") || SeleniumUtils.ENV.contains("sit"))) {
            String ipProxyCacheKey = "local_ip_proxy_key_" + AbstractLoginSys.loginCacheKey(account);
            IpResponse remoteIpProxy = ProxyIpFactory.getRemoteIpProxyWithRenew(account.getAccountId(), account.getProxyArea(), MD5Util.getHexMD5Str((String)(StringUtils.isNotBlank((CharSequence)account.getRetailKey()) ? account.getRetailKey() : account.getSiteUrl()), (int)32), account.getProxyForm(), ipProxyCacheKey);
            if (null != remoteIpProxy && StringUtils.isNotBlank((CharSequence)remoteIpProxy.getIp())) {
                String proxyIp = remoteIpProxy.getIp();
                String proxyPort = remoteIpProxy.getPort();
                XxlJobLogger.log((String)"\u91cd\u65b0\u83b7\u53d6\u4ee3\u7406{}:{}", (Object[])new Object[]{proxyIp, proxyPort});
                webClient.getOptions().setProxyConfig(new ProxyConfig(proxyIp, Integer.parseInt(proxyPort)));
                XxlJobLogger.log((String)"\u6784\u5efa\u4ee3\u7406\u7ed3\u675f\uff1a{}", (Object[])new Object[]{JacksonUtil.getInstance().toJson((Object)webClient.getOptions().getProxyConfig())});
                PageUtil.cache.put((Object)(webClient.hashCode() + ""), (Object)webClient.getOptions().getProxyConfig());
            }
        }
    }

    private static void refreshHttpConnection(WebClient webClient, String proxyIp, int proxyPort) {
        try {
            WebConnection webConnection = webClient.getWebConnection();
            if (webConnection instanceof HttpWebConnection) {
                HttpWebConnection httpWebConnection = (HttpWebConnection)webConnection;
                Field connManagerField = HttpWebConnection.class.getDeclaredField("connectionManager_");
                connManagerField.setAccessible(true);
                PoolingHttpClientConnectionManager connManager = (PoolingHttpClientConnectionManager)connManagerField.get(httpWebConnection);
                HttpClientBuilder builder = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)connManager).setProxy(new HttpHost(proxyIp, proxyPort));
                Field builderField = HttpWebConnection.class.getDeclaredField("httpClientBuilder_");
                builderField.setAccessible(true);
                Map builderMap = (Map)builderField.get(httpWebConnection);
                builderMap.put(Thread.currentThread(), builder);
                XxlJobLogger.log((String)("\u4ee3\u7406\u5df2\u66f4\u65b0\u81f3: " + proxyIp + ":" + proxyPort), (Object[])new Object[0]);
            }
        }
        catch (Exception e) {
            XxlJobLogger.log((String)("\u66f4\u65b0\u4ee3\u7406\u5931\u8d25: " + e.getMessage()), (Object[])new Object[0]);
            throw new RuntimeException("\u65e0\u6cd5\u66f4\u65b0\u4ee3\u7406\u914d\u7f6e", e);
        }
    }

    public static WebClient recreateWebClientWithOld(WebClient oldWebClient, String proxyIp, int proxyPort) throws Exception {
        Map<String, String> headers;
        XxlJobLogger.log((String)"\u5f00\u59cb\u6784\u5efa\u65b0WebClient", (Object[])new Object[0]);
        try {
            oldWebClient.close();
        }
        catch (Exception e) {
            XxlJobLogger.log((String)("\u5173\u95ed\u65e7WebClient\u5931\u8d25: " + e.getMessage()), (Object[])new Object[0]);
        }
        WebClient newWebClient = WebClientUtil.getWebClient("", false);
        XxlJobLogger.log((String)"\u6784\u5efa\u65b0WebClient\u590d\u5236\u65e7webclient\u5c5e\u6027", (Object[])new Object[0]);
        Set cookies = oldWebClient.getCookieManager().getCookies();
        if (CollectionUtils.isNotEmpty((Collection)cookies)) {
            newWebClient.getCookieManager().clearCookies();
            for (Cookie cookie : cookies) {
                newWebClient.getCookieManager().addCookie(cookie);
            }
        }
        if (MapUtils.isNotEmpty(headers = WebClientUtil.getRequestHeaders(oldWebClient))) {
            headers.forEach((arg_0, arg_1) -> ((WebClient)newWebClient).addRequestHeader(arg_0, arg_1));
        }
        WebClientUtil.copyOptions(newWebClient, oldWebClient);
        newWebClient.getOptions().setProxyConfig(new ProxyConfig(proxyIp, proxyPort));
        XxlJobLogger.log((String)"\u6784\u5efa\u65b0WebClient\u7ed3\u675f", (Object[])new Object[0]);
        return newWebClient;
    }

    private static void copyOptions(WebClient newWebClient, WebClient oldWebClient) {
        newWebClient.getOptions().setTimeout(oldWebClient.getOptions().getTimeout());
        newWebClient.getOptions().setJavaScriptEnabled(oldWebClient.getOptions().isJavaScriptEnabled());
        newWebClient.getOptions().setCssEnabled(oldWebClient.getOptions().isCssEnabled());
        newWebClient.getOptions().setPrintContentOnFailingStatusCode(oldWebClient.getOptions().isPrintContentOnFailingStatusCode());
        newWebClient.getOptions().setMaxInMemory(oldWebClient.getOptions().getMaxInMemory());
        newWebClient.getOptions().setActiveXNative(oldWebClient.getOptions().isActiveXNative());
        newWebClient.getOptions().setThrowExceptionOnFailingStatusCode(oldWebClient.getOptions().isThrowExceptionOnFailingStatusCode());
        newWebClient.getOptions().setAppletEnabled(oldWebClient.getOptions().isAppletEnabled());
        newWebClient.getOptions().setConnectionTimeToLive(oldWebClient.getOptions().getConnectionTimeToLive());
        newWebClient.getOptions().setDoNotTrackEnabled(oldWebClient.getOptions().isDoNotTrackEnabled());
        newWebClient.getOptions().setGeolocationEnabled(oldWebClient.getOptions().isGeolocationEnabled());
        newWebClient.getOptions().setHistoryPageCacheLimit(oldWebClient.getOptions().getHistoryPageCacheLimit());
        newWebClient.getOptions().setHistorySizeLimit(oldWebClient.getOptions().getHistorySizeLimit());
        newWebClient.getOptions().setDownloadImages(oldWebClient.getOptions().isDownloadImages());
        newWebClient.getOptions().setHomePage(oldWebClient.getOptions().getHomePage());
        newWebClient.getOptions().setLocalAddress(oldWebClient.getOptions().getLocalAddress());
        newWebClient.getOptions().setPopupBlockerEnabled(oldWebClient.getOptions().isPopupBlockerEnabled());
        newWebClient.getOptions().setScreenHeight(oldWebClient.getOptions().getScreenHeight());
        newWebClient.getOptions().setScreenWidth(oldWebClient.getOptions().getScreenWidth());
        newWebClient.getOptions().setRedirectEnabled(oldWebClient.getOptions().isRedirectEnabled());
        newWebClient.getOptions().setUseInsecureSSL(true);
    }

    private static Map<String, String> getRequestHeaders(WebClient webClient) throws Exception {
        Field headersField = WebClient.class.getDeclaredField("requestHeaders_");
        if (null == headersField) {
            return null;
        }
        headersField.setAccessible(true);
        return (Map)headersField.get(webClient);
    }

    public static WebClient getWebClient(BrowserVersion browserVersion, AccountTemplateDO account) {
        IpResponse remoteIpProxy;
        WebClient webClient = new WebClient(browserVersion);
        if (null != account && account.getIpProxy() != null && account.getIpProxy() == 1 && (SeleniumUtils.ENV.contains("prod") || SeleniumUtils.ENV.contains("sit")) && null != (remoteIpProxy = ProxyIpFactory.getRemoteIpProxy(account.getAccountId(), account.getProxyArea(), MD5Util.getHexMD5Str((String)(StringUtils.isNotBlank((CharSequence)account.getRetailKey()) ? account.getRetailKey() : account.getSiteUrl()), (int)32), account.getProxyForm(), "local_ip_proxy_key_" + AbstractLoginSys.loginCacheKey(account))) && StringUtils.isNotBlank((CharSequence)remoteIpProxy.getIp())) {
            String proxyIp = remoteIpProxy.getIp();
            String proxyPort = remoteIpProxy.getPort();
            XxlJobLogger.log((String)"\u4f7f\u7528\u7f13\u5b58\u4e2d\u6709\u6548\u4ee3\u7406{}:{}", (Object[])new Object[]{proxyIp, proxyPort});
            webClient.getOptions().setProxyConfig(new ProxyConfig(proxyIp, Integer.parseInt(proxyPort)));
            XxlJobLogger.log((String)"\u8ba4\u8bc1\u4fe1\u606f\uff1a{}", (Object[])new Object[]{remoteIpProxy.getBasicProxy()});
            if (StringUtils.isNotBlank((CharSequence)remoteIpProxy.getBasicProxy())) {
                webClient.addRequestHeader("Proxy-Authorization", remoteIpProxy.getBasicProxy());
            }
        }
        return webClient;
    }

    private static <P extends Page> P getDiyPage(WebClient webClient, String url, HttpMethod httpMethod, String requestBody, Map<String, String> headers, Charset charset) {
        Page page = null;
        WebRequest webRequest = null;
        try {
            webRequest = new WebRequest(new URL(url), httpMethod);
            webRequest.setRequestBody(requestBody);
            if (headers != null) {
                webRequest.setAdditionalHeaders(headers);
            }
            if (charset != null) {
                webRequest.setCharset(charset);
            } else {
                webRequest.setCharset(StandardCharsets.UTF_8);
            }
            page = webClient.getPage(webRequest);
            XxlJobLogger.log((String)"\u8bf7\u6c42{}", (Object[])new Object[]{url});
            return (P)page;
        }
        catch (Throwable e) {
            String eMessage = e.getMessage();
            XxlJobLogger.log((String)"\u8bf7\u6c42{}-\u62a5\u9519{}", (Object[])new Object[]{url, eMessage});
            return null;
        }
    }
}

