/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.utils.properties;

import com.xxl.job.core.log.XxlJobLogger;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.stereotype.Component;

@Component
public class PropsUtils {
    @Value(value="${custom.config.properties:}")
    private String customFileName;
    private ResourceLoader resourceLoader = new DefaultResourceLoader();
    private static HashMap<String, Properties> propsMap = new HashMap();

    private PropsUtils() {
    }

    @PostConstruct
    private void loadProperties() {
        String[] fileNames;
        Properties props = new Properties();
        for (String fileName : fileNames = this.customFileName.replace(";", ",").split(",")) {
            Resource resource = this.resourceLoader.getResource(fileName);
            try (InputStreamReader is = new InputStreamReader(resource.getInputStream());
                 BufferedReader reader = new BufferedReader(is);){
                props.load(reader);
                propsMap.put(fileName, props);
            }
            catch (Exception e) {
                String msg = "\u81ea\u5b9a\u4e49\u914d\u7f6e\u6587\u4ef6" + fileName + "\u8bfb\u53d6\u5931\u8d25";
                System.err.println(msg);
                XxlJobLogger.log((String)msg, (Object[])new Object[]{e});
            }
        }
    }

    public Properties getPropsByFile(String fileName) {
        Properties properties = propsMap.get(fileName);
        Properties pro = new Properties();
        if (properties != null) {
            pro.putAll((Map<?, ?>)properties);
        }
        return pro;
    }

    public Object getPropObject(String fileName, String key) {
        Properties properties = this.getPropsByFile(fileName);
        return properties == null ? null : properties.get(key);
    }

    public String getPropString(String fileName, String key) {
        Object obj = this.getPropObject(fileName, key);
        return obj == null ? null : obj.toString();
    }

    public String getPropStrDefaultEmpty(String fileName, String key) {
        return StringUtils.defaultString((String)this.getPropString(fileName, key));
    }
}

