/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.service.handler;

import com.xforceplus.apollo.utils.DateFormatUtil;
import com.xforceplus.apollo.utils.ErrorUtil;
import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.core.domain.CollectSubParam;
import com.xforceplus.core.domain.CollectSubParams;
import com.xforceplus.janus.config.core.config.HttpConfig;
import com.xforceplus.janus.config.core.util.JanusHttpUtil;
import com.xforceplus.utils.BaseUtils;
import com.xforceplus.utils.CountUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectSubRecordHandler {
    private static final Logger logger = LoggerFactory.getLogger(CollectSubRecordHandler.class);
    private static AtomicBoolean init = new AtomicBoolean(false);
    private static ExecutorService executorService = new ThreadPoolExecutor(1, 1, 90L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    private static AtomicBoolean running = new AtomicBoolean(false);
    private static BlockingQueue<CollectSubParam> queue = new LinkedBlockingQueue<CollectSubParam>(10000);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void init() {
        if (init.get()) {
            return;
        }
        AtomicBoolean atomicBoolean = init;
        synchronized (atomicBoolean) {
            if (init.get()) {
                return;
            }
            if (!running.get()) {
                CollectSubRecordHandler.start();
            }
            init.set(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void start() {
        AtomicBoolean atomicBoolean = running;
        synchronized (atomicBoolean) {
            if (running.get()) {
                return;
            }
            running.set(true);
            executorService.execute(() -> {
                ArrayList<CollectSubParam> params = new ArrayList<CollectSubParam>();
                HashMap<String, Object> headers = new HashMap<String, Object>();
                while (running.get()) {
                    try {
                        headers.put("Authentication", HttpConfig.getConfig((String)"common.authentication"));
                        headers.put("action", HttpConfig.getConfig((String)"common.retry.action"));
                        String janusUrl = BaseUtils.JANUS_URL;
                        if (StringUtils.isBlank((CharSequence)janusUrl)) {
                            Thread.sleep(5000L);
                            continue;
                        }
                        CollectSubParam param = queue.take();
                        queue.drainTo(params, 10);
                        params.add(param);
                        if (StringUtils.isBlank((CharSequence)((CharSequence)headers.get("action")))) continue;
                        headers.put("serialNo", System.currentTimeMillis() + "");
                        JanusHttpUtil.ResponseCus responseCus = JanusHttpUtil.doPostJsonEntire((String)janusUrl, (String)JacksonUtil.getInstance().toJson((Object)new CollectSubParams(params)), headers, new HashMap());
                        if (null != responseCus && Objects.equals(responseCus.getStatus(), 200)) continue;
                        Thread.sleep(3000L);
                        params.forEach(CollectSubRecordHandler::doHoldData);
                    }
                    catch (Exception e) {
                        logger.error(ErrorUtil.getStackMsg((Exception)e));
                    }
                    catch (Error error) {
                        logger.error(ErrorUtil.getStackMsg((Throwable)error));
                    }
                    finally {
                        params.clear();
                    }
                }
            });
        }
    }

    public static boolean doHoldData(CollectSubParam message) {
        if (null == message || StringUtils.isBlank((CharSequence)message.getRecordId())) {
            return false;
        }
        if (StringUtils.isBlank((CharSequence)message.getCreatedTime())) {
            message.setCreatedTime(DateFormatUtil.getCurrentFormatDateTime());
        }
        if (StringUtils.isBlank((CharSequence)message.getModifiedTime())) {
            message.setModifiedTime(DateFormatUtil.getCurrentFormatDateTime());
        }
        if (!Objects.equals(message.getStatus(), "1")) {
            CountUtils.threadLocalStatus.set(Boolean.FALSE);
        }
        message.setTimes(message.getTimes() + 1);
        if (message.getTimes() > 5) {
            return false;
        }
        return CollectSubRecordHandler.offer(message);
    }

    private static boolean offer(CollectSubParam item) {
        if (!init.get()) {
            CollectSubRecordHandler.init();
        }
        return queue.offer(item);
    }
}

