/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.utils.warn.sender;

import com.alibaba.fastjson.JSONArray;
import com.xforceplus.account.domain.AccountTemplateDO;
import com.xforceplus.core.enums.RetailConstantEnum;
import com.xforceplus.core.enums.SupplierConstantEnum;
import com.xforceplus.core.message.WarningMessageBo;
import com.xforceplus.core.message.constant.Developer;
import com.xforceplus.core.message.constant.Platform;
import com.xforceplus.core.message.constant.PlatformMenu;
import com.xforceplus.core.message.constant.PlatformModules;
import com.xforceplus.core.message.constant.PlatformService;
import com.xforceplus.core.message.constant.SendChannel;
import com.xforceplus.core.message.constant.WarnType;
import com.xforceplus.lock.redisson.RedissonLock;
import com.xforceplus.utils.DateUtils;
import com.xforceplus.utils.Sha256Utils;
import com.xforceplus.utils.warn.sender.SendWarnMessage;
import com.xxl.job.core.log.XxlJobLogger;
import com.xxl.rpc.util.IpUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.redisson.api.RBucket;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ChangePasswordProcesser {
    private static final String CHANGE_PASSWORD_SUFFIX = "job:changepassword:";
    private static final String CHANGE_PASSWORD_TOKEN_SUFFIX = "job:changepwdtoken:";
    @Autowired
    SendWarnMessage sendWarnMessage;
    @Autowired
    RedissonLock redissonLock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void changePassword(AccountTemplateDO account) {
        String key;
        boolean lock;
        block23: {
            block22: {
                block21: {
                    block20: {
                        XxlJobLogger.log((String)"\u89e6\u53d1\u5bc6\u7801\u9519\u8bef\u53d1\u9001\u4fee\u6539\u673a\u5236", (Object[])new Object[0]);
                        lock = false;
                        key = null;
                        String projectKey = account.getProjectKey();
                        String retailKey = account.getRetailKey();
                        String accountName = account.getAccountName();
                        int sendCountLimit = 2;
                        int sendSpace = 4;
                        int expireTime = 24;
                        try {
                            Map<String, String> postParam = account.getPostParam();
                            if (postParam != null && !postParam.isEmpty()) {
                                if (postParam.containsKey("sendCountLimit")) {
                                    sendCountLimit = Integer.parseInt(postParam.get("sendCountLimit"));
                                }
                                if (postParam.containsKey("sendSpace")) {
                                    sendSpace = Integer.parseInt(postParam.get("sendSpace"));
                                }
                                if (postParam.containsKey("expireTime")) {
                                    expireTime = Integer.parseInt(postParam.get("expireTime"));
                                }
                            }
                            key = CHANGE_PASSWORD_SUFFIX + projectKey + "-" + retailKey + "-" + accountName;
                            lock = this.redissonLock.lock(key);
                            XxlJobLogger.log((String)"\u4fee\u6539\u5bc6\u7801\u52a0\u9501\uff0cRedissonKey={},Status={}.", (Object[])new Object[]{key, lock});
                            if (!lock) {
                                if (!lock) return;
                                this.redissonLock.release(key);
                                return;
                            }
                            Map<String, Object> tokenMap = new HashMap<String, Object>();
                            tokenMap.put("projectKey", projectKey);
                            tokenMap.put("retailKey", retailKey);
                            tokenMap.put("accountName", accountName);
                            String token = Sha256Utils.getSignCommon(tokenMap, null);
                            RBucket cacheKey = this.redissonLock.getRedissonManager().getRedisson().getBucket(CHANGE_PASSWORD_TOKEN_SUFFIX + token);
                            if (cacheKey.get() == null) {
                                int count = 1;
                                tokenMap.put("sendCount", count);
                                tokenMap.put("lastSendTime", System.currentTimeMillis());
                                tokenMap.put("updateStatus", 0);
                                cacheKey.set(tokenMap);
                                cacheKey.expire((long)expireTime, TimeUnit.HOURS);
                            } else {
                                tokenMap = (Map)cacheKey.get();
                                int updateStatus = (Integer)tokenMap.get("updateStatus");
                                if (updateStatus == 1) {
                                    XxlJobLogger.log((String)"\u5f53\u524d\u91c7\u96c6\u8d26\u53f7\u5bc6\u7801\u5df2\u4fee\u6539\u6210\u529f", (Object[])new Object[0]);
                                    if (!lock) return;
                                    break block20;
                                }
                                int count = (Integer)tokenMap.get("sendCount");
                                if (count >= sendCountLimit) {
                                    XxlJobLogger.log((String)"\u5f53\u5929\u53d1\u9001\u6b21\u6570\u5df2\u8d85\u8fc7{}\u6b21", (Object[])new Object[]{sendCountLimit});
                                    if (!lock) return;
                                    break block21;
                                }
                                long lastSendTime = (Long)tokenMap.get("lastSendTime");
                                long hourTime = sendSpace * 60 * 60 * 1000;
                                long differ = System.currentTimeMillis() - lastSendTime;
                                if (hourTime > differ) {
                                    XxlJobLogger.log((String)"\u53d1\u9001\u65f6\u95f4\u95f4\u9694\u4e0d\u6ee1{}\u5c0f\u65f6,\u9000\u51fa", (Object[])new Object[]{sendSpace});
                                    if (!lock) return;
                                    break block22;
                                }
                                tokenMap.put("sendCount", ++count);
                                tokenMap.put("lastSendTime", System.currentTimeMillis());
                                cacheKey.set(tokenMap);
                            }
                            WarningMessageBo warningMessage = new WarningMessageBo();
                            warningMessage.setPlatform(Platform.DCS.getIndex());
                            warningMessage.setIp(IpUtil.getIp());
                            warningMessage.setService(PlatformService.BILLS.getIndex());
                            warningMessage.setModules(PlatformModules.ORDERCONTER.getIndex());
                            warningMessage.setMenuOrButton(PlatformMenu.ZZ.getIndex());
                            warningMessage.setSendChannel(SendChannel.SMS.getIndex());
                            warningMessage.setDeveloper(Developer.LIYANG.getIndex());
                            warningMessage.setWarnType(WarnType.USERERROR.getIndex());
                            warningMessage.setSupplier(SupplierConstantEnum.getIndexByKey(projectKey));
                            String storeName = RetailConstantEnum.geLabelByKey(retailKey);
                            String pswd = account.getAccountPassword();
                            Long mobilePhone = account.getMobilePhone();
                            String pwsdUrl = "powere2e-job-admin/update_kapwd?token=" + token + "&pwsd=";
                            XxlJobLogger.log((String)"\u4fee\u6539\u5bc6\u7801\u94fe\u63a5\u4e3a:{}", (Object[])new Object[]{pwsdUrl});
                            JSONArray array = new JSONArray();
                            array.add((Object)storeName);
                            array.add((Object)accountName);
                            array.add(this.formatPwd(pswd));
                            array.add((Object)pwsdUrl);
                            array.add((Object)(expireTime + ""));
                            array.add((Object)(mobilePhone + ""));
                            warningMessage.setMsgText(array.toJSONString());
                            warningMessage.setMsgCreateTime(DateUtils.dateToLongString(new Date()));
                            warningMessage.setMessageAccepter(9999);
                            warningMessage.setCustomAccepter(mobilePhone + "");
                            this.sendWarnMessage.sendMessage(warningMessage);
                            if (!lock) return;
                            break block23;
                        }
                        catch (Exception e) {
                            XxlJobLogger.log((String)("\u51fa\u73b0\u5f02\u5e38" + ExceptionUtils.getMessage((Throwable)e)), (Object[])new Object[0]);
                            return;
                        }
                    }
                    this.redissonLock.release(key);
                    return;
                }
                this.redissonLock.release(key);
                return;
            }
            this.redissonLock.release(key);
            return;
        }
        this.redissonLock.release(key);
        return;
        finally {
            if (lock) {
                this.redissonLock.release(key);
            }
        }
    }

    private Object formatPwd(String pswd) {
        int length = pswd.length();
        if (length == 1) {
            return pswd;
        }
        if (length == 2) {
            return pswd.substring(0, 1) + "*";
        }
        if (length == 3) {
            return pswd.substring(0, 1) + "*" + pswd.substring(2);
        }
        int len = pswd.length() / 2;
        pswd = pswd.substring(0, len - 1) + "**" + pswd.substring(len + 1);
        return pswd;
    }
}

