/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.utils;

import com.xforceplus.core.config.XxlCrawlerConf;
import com.xforceplus.utils.UrlUtil;
import com.xuxueli.crawler.model.PageRequest;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsoupUtil {
    private static Logger logger = LoggerFactory.getLogger(JsoupUtil.class);

    public static Document load(PageRequest pageRequest) {
        if (!UrlUtil.isUrl(pageRequest.getUrl())) {
            return null;
        }
        try {
            Connection conn = Jsoup.connect((String)pageRequest.getUrl());
            if (pageRequest.getParamMap() != null && !pageRequest.getParamMap().isEmpty()) {
                conn.data(pageRequest.getParamMap());
            }
            if (pageRequest.getCookieMap() != null && !pageRequest.getCookieMap().isEmpty()) {
                conn.cookies(pageRequest.getCookieMap());
            }
            if (pageRequest.getHeaderMap() != null && !pageRequest.getHeaderMap().isEmpty()) {
                conn.headers(pageRequest.getHeaderMap());
            }
            if (pageRequest.getUserAgent() != null) {
                conn.userAgent(pageRequest.getUserAgent());
            }
            if (pageRequest.getReferrer() != null) {
                conn.referrer(pageRequest.getReferrer());
            }
            conn.timeout(pageRequest.getTimeoutMillis());
            conn.validateTLSCertificates(pageRequest.isValidateTLSCertificates());
            conn.maxBodySize(0);
            if (pageRequest.getProxy() != null) {
                conn.proxy(pageRequest.getProxy());
            }
            Document html = null;
            html = pageRequest.isIfPost() ? conn.post() : conn.get();
            return html;
        }
        catch (IOException var3) {
            logger.error(var3.getMessage(), (Throwable)var3);
            return null;
        }
    }

    public static String loadPageSource(PageRequest pageRequest) {
        if (!UrlUtil.isUrl(pageRequest.getUrl())) {
            return null;
        }
        try {
            Connection conn = Jsoup.connect((String)pageRequest.getUrl());
            if (pageRequest.getParamMap() != null && !pageRequest.getParamMap().isEmpty()) {
                conn.data(pageRequest.getParamMap());
            }
            if (pageRequest.getCookieMap() != null && !pageRequest.getCookieMap().isEmpty()) {
                conn.cookies(pageRequest.getCookieMap());
            }
            if (pageRequest.getHeaderMap() != null && !pageRequest.getHeaderMap().isEmpty()) {
                conn.headers(pageRequest.getHeaderMap());
            }
            if (pageRequest.getUserAgent() != null) {
                conn.userAgent(pageRequest.getUserAgent());
            }
            if (pageRequest.getReferrer() != null) {
                conn.referrer(pageRequest.getReferrer());
            }
            conn.timeout(pageRequest.getTimeoutMillis());
            conn.validateTLSCertificates(pageRequest.isValidateTLSCertificates());
            conn.maxBodySize(0);
            if (pageRequest.getProxy() != null) {
                conn.proxy(pageRequest.getProxy());
            }
            conn.ignoreContentType(true);
            conn.method(pageRequest.isIfPost() ? Connection.Method.POST : Connection.Method.GET);
            Connection.Response resp = conn.execute();
            String pageSource = resp.body();
            return pageSource;
        }
        catch (IOException var4) {
            logger.error(var4.getMessage(), (Throwable)var4);
            return null;
        }
    }

    public static String parseElement(Element fieldElement, XxlCrawlerConf.SelectType selectType, String selectVal) {
        String fieldElementOrigin = null;
        fieldElementOrigin = XxlCrawlerConf.SelectType.HTML == selectType ? fieldElement.html() : (XxlCrawlerConf.SelectType.VAL == selectType ? fieldElement.val() : (XxlCrawlerConf.SelectType.TEXT == selectType ? fieldElement.text() : (XxlCrawlerConf.SelectType.ATTR == selectType ? fieldElement.attr(selectVal) : (XxlCrawlerConf.SelectType.HAS_CLASS == selectType ? String.valueOf(fieldElement.hasClass(selectVal)) : fieldElement.toString()))));
        return fieldElementOrigin;
    }

    public static Set<String> findLinks(Document html) {
        if (html == null) {
            return null;
        }
        Elements hrefElements = html.select("a[href]");
        HashSet<String> links = new HashSet<String>();
        if (hrefElements != null && hrefElements.size() > 0) {
            for (Element item : hrefElements) {
                String href = item.attr("abs:href");
                if (!UrlUtil.isUrl(href)) continue;
                links.add(href);
            }
        }
        return links;
    }

    public static Set<String> findImages(Document html) {
        Elements imgs = html.getElementsByTag("img");
        HashSet<String> images = new HashSet<String>();
        if (imgs != null && imgs.size() > 0) {
            for (Element element : imgs) {
                String imgSrc = element.attr("abs:src");
                images.add(imgSrc);
            }
        }
        return images;
    }
}

