/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.utils.selenium;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xforceplus.apollo.utils.ErrorUtil;
import com.xforceplus.utils.selenium.ResponseBodyVo;
import com.xforceplus.utils.selenium.ResponseReceivedEvent;
import com.xxl.job.core.log.XxlJobLogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeDriverService;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.logging.LogEntries;
import org.openqa.selenium.logging.LogEntry;
import org.openqa.selenium.logging.Logs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChromeDriverProxy
extends ChromeDriver {
    private static final Logger log = LoggerFactory.getLogger(ChromeDriverProxy.class);
    public static final String NETWORK_RESPONSE_RECEIVED = "Network.responseReceived";
    private static final int COMMAND_TIMEOUT = 20000;
    private int CHROME_DRIVER_PORT;
    private final ChromeDriverService driverService;
    private boolean loginFailure = true;

    public ChromeDriverProxy(ChromeOptions options, ChromeDriverService driverService, int port) {
        super(driverService, options);
        this.CHROME_DRIVER_PORT = port;
        this.driverService = driverService;
    }

    public String getResponseBody(String requestId) {
        try {
            String url = String.format("http://localhost:%s/session/%s/goog/cdp/execute", this.CHROME_DRIVER_PORT, this.getSessionId());
            HttpPost httpPost = new HttpPost(url);
            JSONObject object = new JSONObject();
            JSONObject params = new JSONObject();
            params.put("requestId", (Object)requestId);
            object.put("cmd", (Object)"Network.getResponseBody");
            object.put("params", (Object)params);
            httpPost.setEntity((HttpEntity)new StringEntity(object.toString()));
            RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(20000).setConnectTimeout(20000).build();
            CloseableHttpClient httpClient = HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).build();
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            String s = EntityUtils.toString((HttpEntity)response.getEntity());
            return this.getResponseValue(s);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private String getResponseValue(String data) {
        JSONObject json = JSONObject.parseObject((String)data);
        ResponseBodyVo responseBodyVo = (ResponseBodyVo)JSONObject.toJavaObject((JSON)json, ResponseBodyVo.class);
        if (0 == responseBodyVo.getStatus()) {
            return responseBodyVo.getValue();
        }
        XxlJobLogger.log((String)("status error:" + data), (Object[])new Object[0]);
        return "";
    }

    public void saveHttpTransferDataIfNecessary(ChromeDriverProxy driver, Map<String, String> map) {
        Logs logs = driver.manage().logs();
        Set availableLogTypes = logs.getAvailableLogTypes();
        if (availableLogTypes.contains("performance")) {
            LogEntries logEntries = logs.get("performance");
            ArrayList<ResponseReceivedEvent> responseReceivedEvents = new ArrayList<ResponseReceivedEvent>();
            for (LogEntry entry : logEntries) {
                JSONObject jsonObj = JSON.parseObject((String)entry.getMessage()).getJSONObject("message");
                String method = jsonObj.getString("method");
                String params = jsonObj.getString("params");
                if (!method.equals(NETWORK_RESPONSE_RECEIVED)) continue;
                ResponseReceivedEvent response = (ResponseReceivedEvent)JSON.parseObject((String)params, ResponseReceivedEvent.class);
                responseReceivedEvents.add(response);
            }
            this.doSaveHttpTransferDataIfNecessary(driver, responseReceivedEvents, map);
        }
    }

    private void doSaveHttpTransferDataIfNecessary(ChromeDriverProxy driver, List<ResponseReceivedEvent> responses, Map<String, String> map) {
        for (ResponseReceivedEvent responseReceivedEvent : responses) {
            String url = JSONObject.parseObject((String)responseReceivedEvent.getResponse()).getString("url");
            boolean staticFiles = url.endsWith(".png") || url.endsWith(".jpg") || url.endsWith(".css") || url.endsWith(".ico") || url.endsWith(".js") || url.endsWith(".gif");
            if (staticFiles || !url.startsWith("http") && !url.startsWith("https")) continue;
            String bodyx = driver.getResponseBody(responseReceivedEvent.getRequestId());
            map.put(url, bodyx);
        }
    }

    public void quit() {
        super.quit();
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            log.error(ErrorUtil.getStackMsg((Exception)e));
        }
        this.driverService.stop();
    }

    public boolean isLoginFailure() {
        return this.loginFailure;
    }

    public void setLoginFailure(boolean loginFailure) {
        this.loginFailure = loginFailure;
    }
}

