/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.core.resolve.executor;

import com.xforceplus.core.enums.IntConstant;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitorExecutorService
extends ThreadPoolExecutor {
    private static Logger logger = LoggerFactory.getLogger((String)MonitorExecutorService.class.getName());
    private ThreadLocal<Long> TIME_THREADLOCAL = ThreadLocal.withInitial(() -> System.nanoTime());
    private String poolName;

    public MonitorExecutorService(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, String poolName, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, handler);
        this.poolName = poolName;
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        super.beforeExecute(t, r);
        this.TIME_THREADLOCAL.set(System.nanoTime());
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        long period = System.nanoTime() - this.TIME_THREADLOCAL.get();
        long seconds = TimeUnit.NANOSECONDS.toSeconds(period);
        int activeCount = this.getActiveCount();
        int queueSize = this.getQueue().size();
        logger.info("executor monitor poolname:{},seconds:{},activeCount:{},queueSize:{}", new Object[]{this.poolName, seconds, activeCount, queueSize});
    }

    @Override
    public void shutdown() {
        logger.info(String.format(this.poolName + " Going to shutdown. Executed tasks: %d, Running tasks: %d, Pending tasks: %d", this.getCompletedTaskCount(), this.getActiveCount(), this.getQueue().size()));
        super.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        logger.info(String.format(this.poolName + " Going to immediately shutdown. Executed tasks: %d, Running tasks: %d, Pending tasks: %d", this.getCompletedTaskCount(), this.getActiveCount(), this.getQueue().size()));
        return super.shutdownNow();
    }

    public static ExecutorService newFixedThreadPool(int nThreads, String poolName) {
        ThreadPoolExecutor.AbortPolicy handler = new ThreadPoolExecutor.AbortPolicy();
        long keepAliveTime = TimeUnit.SECONDS.toNanos(IntConstant.SIXTY);
        int DEFAULT_QUEUE_CAPACITY = IntConstant.ONE_THOUSAND;
        LinkedBlockingQueue<Runnable> workQueue = new LinkedBlockingQueue<Runnable>(DEFAULT_QUEUE_CAPACITY);
        return new MonitorExecutorService(nThreads, nThreads, keepAliveTime, TimeUnit.NANOSECONDS, workQueue, poolName, (RejectedExecutionHandler)handler);
    }

    public static ExecutorService newFixedThreadPool(int nThreads, String poolName, int capacity) {
        ThreadPoolExecutor.AbortPolicy handler = new ThreadPoolExecutor.AbortPolicy();
        long keepAliveTime = TimeUnit.SECONDS.toNanos(IntConstant.SIXTY);
        LinkedBlockingQueue<Runnable> workQueue = new LinkedBlockingQueue<Runnable>(capacity);
        return new MonitorExecutorService(nThreads, nThreads, keepAliveTime, TimeUnit.NANOSECONDS, workQueue, poolName, (RejectedExecutionHandler)handler);
    }
}

