/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.proxy.service;

import com.xforceplus.lock.redisson.RedissonLock;
import com.xforceplus.proxy.IpTracker;
import com.xforceplus.proxy.ProxyIpFactory;
import com.xforceplus.proxy.domain.IpTrackerDo;
import com.xforceplus.utils.DateUtils;
import com.xforceplus.utils.FileUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.redisson.api.RBucket;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IpPoolProxyConfigService {
    @Autowired
    RedissonLock redissonLock;
    private static final String LOCK_RECOVERY_IP_POOL_KEY = "job:ipproxy:pool:lock_recovery_ip_pool";
    private static final ThreadPoolExecutor threadPool = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(1), Executors.defaultThreadFactory(), new ThreadPoolExecutor.DiscardPolicy());

    public void saveFileLog(String appendLogPattern, Object ... appendLogArguments) {
        FileUtil.saveFileLog("/ippoolproxy/", appendLogPattern, appendLogArguments);
    }

    public static void mapCopy(Map paramsMap, Map resultMap) {
        if (resultMap == null) {
            resultMap = new HashMap();
        }
        if (paramsMap == null) {
            return;
        }
        for (Map.Entry entry : paramsMap.entrySet()) {
            Object key;
            resultMap.put(key, (String)(paramsMap.get(key = entry.getKey()) != null ? paramsMap.get(key) : ""));
        }
    }

    public void recoveryIpPool() {
        threadPool.execute(() -> {
            block10: {
                this.saveFileLog("------\u7f13\u5b58\u4ee3\u7406ip\u6c60\u56de\u6536\u5229\u7528\u6267\u884c\u5f00\u59cb-------", new Object[0]);
                List<IpTrackerDo> oks = IpTracker.getInstance().getRecentIps("proxyIpSuccessList");
                this.saveFileLog("+++++++++++++++++\u53ef\u7528ip\u6570proxyIpSuccessList.size:{}", oks.size());
                boolean lock = this.redissonLock.lock(LOCK_RECOVERY_IP_POOL_KEY, 60L);
                try {
                    if (lock) {
                        this.saveFileLog("------\u7f13\u5b58\u4ee3\u7406ip\u6c60\u56de\u6536\u5229\u7528\u52a0\u9501\u6210\u529flock\uff1a{},key\uff1a{}-------", lock, LOCK_RECOVERY_IP_POOL_KEY);
                        RBucket ipPoolRBucket = this.redissonLock.getRedissonManager().getRedisson().getBucket("job:ipproxy:pool:ip_cache_all");
                        Map ipPoolMap = (Map)ipPoolRBucket.get();
                        this.saveFileLog("------\u7f13\u5b58\u4ee3\u7406ip\u6c60ipPoolMap\uff1a{}-------", ipPoolMap.size());
                        HashMap ipPoolMap_ = new HashMap();
                        IpPoolProxyConfigService.mapCopy(ipPoolMap, ipPoolMap_);
                        if (ipPoolMap != null && ipPoolMap.size() >= 5) {
                            for (String key : ipPoolMap_.keySet()) {
                                String proxyIp = key.split(",")[0];
                                String proxyPort = key.split(",")[1];
                                Map proxyIpMap = (Map)ipPoolMap.get(key);
                                String expire = (String)proxyIpMap.get("expire");
                                String createTime = (String)proxyIpMap.get("createTime");
                                Date date = DateUtils.stringToDate(createTime, "yyyy-MM-dd HH:mm:ss:SSS");
                                long offMinutes = DateUtils.getOffMinutes(System.currentTimeMillis(), date.getTime());
                                if (offMinutes > (long)Integer.valueOf(expire).intValue()) {
                                    this.saveFileLog("\u5220\u9664\u53ef\u7528\u65f6\u95f4\u5df2\u8fc7\u671f\u7684ip\uff0cip:{},expire:{},createTime:{}", key, expire, createTime);
                                    ipPoolMap.remove(key);
                                    continue;
                                }
                                this.saveFileLog("\u672a\u8fc7\u671fip:{}", key);
                                if (!ProxyIpFactory.validateProxy(proxyIp, proxyPort, "")) continue;
                                this.saveFileLog("\u672a\u8fc7\u671f\u53ef\u7528ip:{},expire:{},createTime:{}", key, expire, createTime);
                                IpTracker.getInstance().addOrUpdateIpIn("proxyIpSuccessList", key);
                            }
                            ipPoolMap_.clear();
                            ipPoolMap_ = null;
                            ipPoolRBucket.delete();
                            ipPoolRBucket.set((Object)ipPoolMap);
                        }
                    } else {
                        this.saveFileLog("------\u7f13\u5b58\u4ee3\u7406ip\u6c60\u56de\u6536\u5229\u7528\u52a0\u9501\u5931\u8d25lock\uff1a{},key\uff1a{}-------", lock, LOCK_RECOVERY_IP_POOL_KEY);
                    }
                    oks = IpTracker.getInstance().getRecentIps("proxyIpSuccessList");
                    this.saveFileLog("------\u7f13\u5b58\u4ee3\u7406ip\u6c60\u56de\u6536\u5229\u7528\u6267\u884c\u7ed3\u675f-------", new Object[0]);
                    this.saveFileLog("------\u56de\u6536\u53ef\u7528\u4ee3\u7406ip\u6570\u91cf:{}", oks.size());
                    if (!lock) break block10;
                    this.redissonLock.release(LOCK_RECOVERY_IP_POOL_KEY);
                }
                catch (Exception e) {
                    try {
                        this.saveFileLog("------\u7f13\u5b58\u4ee3\u7406ip\u6c60\u56de\u6536\u5229\u7528\u6267\u884c\u5f02\u5e38-------e:{}", ExceptionUtils.getStackTrace((Throwable)e));
                        if (!lock) break block10;
                        this.redissonLock.release(LOCK_RECOVERY_IP_POOL_KEY);
                    }
                    catch (Throwable throwable) {
                        if (lock) {
                            this.redissonLock.release(LOCK_RECOVERY_IP_POOL_KEY);
                            this.saveFileLog("------\u7f13\u5b58\u4ee3\u7406ip\u6c60\u56de\u6536\u5229\u7528\u91ca\u653e\u9501lock\uff1a{},key\uff1a{}-------", lock, LOCK_RECOVERY_IP_POOL_KEY);
                        }
                        throw throwable;
                    }
                    this.saveFileLog("------\u7f13\u5b58\u4ee3\u7406ip\u6c60\u56de\u6536\u5229\u7528\u91ca\u653e\u9501lock\uff1a{},key\uff1a{}-------", lock, LOCK_RECOVERY_IP_POOL_KEY);
                }
                this.saveFileLog("------\u7f13\u5b58\u4ee3\u7406ip\u6c60\u56de\u6536\u5229\u7528\u91ca\u653e\u9501lock\uff1a{},key\uff1a{}-------", lock, LOCK_RECOVERY_IP_POOL_KEY);
            }
        });
    }
}

