/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.service.handler;

import com.xforceplus.apollo.utils.ErrorUtil;
import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.core.domain.CollectSubParam;
import com.xforceplus.core.domain.CollectSubResponse;
import com.xforceplus.janus.config.core.config.HttpConfig;
import com.xforceplus.janus.config.core.util.JanusHttpUtil;
import com.xforceplus.utils.BaseUtils;
import com.xxl.job.core.log.XxlJobLogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryDataHandler {
    private static final Logger log = LoggerFactory.getLogger(RetryDataHandler.class);
    private static final int pageSize = 100;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<CollectSubParam> fetchRetryData(String recordId, String subTaskId, String status) {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("Authentication", HttpConfig.getConfig((String)"common.authentication"));
        headers.put("action", HttpConfig.getConfig((String)"common.pull.action"));
        headers.put("serialNo", recordId);
        HashMap<String, Object> bodyMap = new HashMap<String, Object>();
        bodyMap.put("recordId", recordId);
        bodyMap.put("subTaskId", subTaskId);
        bodyMap.put("status", status);
        bodyMap.put("pageSize", 100);
        int page = 1;
        ArrayList<CollectSubParam> params = new ArrayList<CollectSubParam>();
        while (true) {
            try {
                bodyMap.put("page", page);
                JanusHttpUtil.ResponseCus responseCus = JanusHttpUtil.doPostJsonEntire((String)BaseUtils.JANUS_URL, (String)JacksonUtil.getInstance().toJson(bodyMap), headers, new HashMap());
                if (null == responseCus || !Objects.equals(responseCus.getStatus(), 200)) {
                    Thread.sleep(3000L);
                    responseCus = JanusHttpUtil.doPostJsonEntire((String)BaseUtils.JANUS_URL, (String)JacksonUtil.getInstance().toJson(bodyMap), headers, new HashMap());
                }
                if (null == responseCus || !Objects.equals(responseCus.getStatus(), 200)) {
                    XxlJobLogger.log((String)"\u83b7\u53d6\u8fdc\u7a0b\u91cd\u8bd5\u4efb\u52a1\u5931\u8d25,recordId:{},subTaskId:{},page:{}", (Object[])new Object[]{recordId, subTaskId, page});
                    params.clear();
                    break;
                }
                String result = responseCus.getBody();
                if (StringUtils.isBlank((CharSequence)result)) break;
                CollectSubResponse subResponse = (CollectSubResponse)JacksonUtil.getInstance().fromJson(result, CollectSubResponse.class);
                if (null == subResponse || null == subResponse.getResult()) {
                    params.clear();
                    break;
                }
                if (!CollectionUtils.isNotEmpty(subResponse.getResult())) break;
                params.addAll(subResponse.getResult());
                if (subResponse.getResult().size() >= 100) continue;
            }
            catch (Exception e) {
                log.error(ErrorUtil.getStackMsg((Exception)e));
                params.clear();
            }
            finally {
                ++page;
                continue;
            }
            break;
        }
        return params;
    }
}

