/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.utils;

import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.StringWebResponse;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.html.parser.neko.HtmlUnitNekoHtmlParser;
import com.xforceplus.core.enums.CharSetEnum;
import com.xxl.job.core.log.XxlJobLogger;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class StringConvertUtils {
    public static String getEncoding(String str) {
        String encode = "UTF-16";
        try {
            if (str.equals(new String(str.getBytes(), encode))) {
                return encode;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        encode = CharSetEnum.ASCII.getCharSet();
        try {
            if (str.equals(new String(str.getBytes(), encode))) {
                return "\u5b57\u7b26\u4e32<< " + str + " >>\u4e2d\u4ec5\u7531\u6570\u5b57\u548c\u82f1\u6587\u5b57\u6bcd\u7ec4\u6210\uff0c\u65e0\u6cd5\u8bc6\u522b\u5176\u7f16\u7801\u683c\u5f0f";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        encode = CharSetEnum.ISO88591.getCharSet();
        try {
            if (str.equals(new String(str.getBytes(), encode))) {
                return encode;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        encode = CharSetEnum.GB2312.getCharSet();
        try {
            if (str.equals(new String(str.getBytes(), encode))) {
                return encode;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        encode = CharSetEnum.UTF8.getCharSet();
        try {
            if (str.equals(new String(str.getBytes(), encode))) {
                return encode;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "\u672a\u8bc6\u522b\u7f16\u7801\u683c\u5f0f";
    }

    public static List<Charset> getStrEncoding(String str) {
        ArrayList<Charset> list = new ArrayList<Charset>();
        Charset.availableCharsets().values().forEach(e -> {
            if (str.equals(new String(str.getBytes(), (Charset)e))) {
                list.add((Charset)e);
            }
        });
        return list;
    }

    public static boolean isMessyCode(String strName) {
        Pattern p = Pattern.compile("\\s*|t*|r*|n*");
        Matcher m = p.matcher(strName);
        String after = m.replaceAll("");
        String temp = after.replaceAll("p\\{P\\}", "");
        char[] ch = temp.trim().toCharArray();
        float chLength = ch.length;
        float count = 0.0f;
        for (int i = 0; i < ch.length; ++i) {
            char c = ch[i];
            if (Character.isLetterOrDigit(c) || StringConvertUtils.isChinese(c)) continue;
            count += 1.0f;
        }
        float result = count / chLength;
        return (double)result > 0.4;
    }

    public static boolean isChinese(char c) {
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(c);
        return ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || ub == Character.UnicodeBlock.GENERAL_PUNCTUATION || ub == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS;
    }

    public static boolean isContainChinese(String str) {
        Pattern p = Pattern.compile("[\u4e00-\u9fa5]");
        Matcher m = p.matcher(str);
        return m.find();
    }

    public static boolean loading(String str) {
        String htmlLoading = "</html>";
        String bodyLoading = "</body>";
        String lowerCaseStr = str.toLowerCase();
        return !lowerCaseStr.contains(htmlLoading) || !lowerCaseStr.contains(bodyLoading);
    }

    private static boolean isContainPeculiarCode(String str) {
        return str.replaceAll("[\u4e00-\u9fa5]*[a-z]*[A-Z]*\\d*-*_*\\s*", "").length() == 0;
    }

    public static Page judjeAndConvertString(Page page, Charset customCharset, Charset ... targetCharset) {
        Page p = page;
        String content = null;
        try {
            content = page.getWebResponse().getContentAsString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (StringUtils.isNotBlank((CharSequence)content) && targetCharset != null && StringConvertUtils.isMessyCode(content)) {
            for (Charset tset : targetCharset) {
                try {
                    Charset charset = page.getWebResponse().getContentCharset();
                    XxlJobLogger.log((String)("\u4f7f\u7528\u9875\u9762" + charset.name() + "\u7f16\u7801\u8f6c\u7801---"), (Object[])new Object[0]);
                    content = StringConvertUtils.convertString(content, tset, targetCharset);
                }
                catch (Exception charset) {
                    // empty catch block
                }
                try {
                    if (StringConvertUtils.isMessyCode(content)) {
                        List<Charset> encode = StringConvertUtils.getStrEncoding(content);
                        XxlJobLogger.log((String)("\u4f7f\u7528\u6587\u672c" + encode + "\u7f16\u7801\u8f6c\u7801"), (Object[])new Object[0]);
                        content = StringConvertUtils.convertString(content, tset, encode.toArray(new Charset[0]));
                    }
                }
                catch (Exception encode) {
                    // empty catch block
                }
                try {
                    if (StringConvertUtils.isMessyCode(content) && customCharset != null) {
                        XxlJobLogger.log((String)("\u4f7f\u7528\u6307\u5b9a" + customCharset.name() + "\u7f16\u7801\u8f6c\u7801"), (Object[])new Object[0]);
                        content = StringConvertUtils.convertString(content, customCharset, targetCharset);
                    }
                }
                catch (Exception encode) {
                    // empty catch block
                }
                if (!StringConvertUtils.isMessyCode(content)) {
                    HtmlUnitNekoHtmlParser parser = new HtmlUnitNekoHtmlParser();
                    try {
                        p = parser.parseHtml((WebResponse)new StringWebResponse(content, page.getUrl()), page.getEnclosingWindow());
                    }
                    catch (Exception e) {
                        XxlJobLogger.log((String)("\u9875\u9762\u8f6c\u6362\u5f02\u5e38" + ExceptionUtils.getMessage((Throwable)e)), (Object[])new Object[0]);
                    }
                    break;
                }
                XxlJobLogger.log((String)"\u591a\u6b21\u8f6c\u7801\u540e\u4f9d\u7136\u5305\u542b\u4e71\u7801", (Object[])new Object[0]);
            }
        }
        return p;
    }

    public static String convertString(String str, Charset srcCharset, Charset targetCharset) {
        String tmp = str;
        if (StringUtils.isNotBlank((CharSequence)str) && targetCharset != null) {
            byte[] bytes = srcCharset == null ? str.getBytes() : str.getBytes(srcCharset);
            tmp = new String(bytes, targetCharset);
        }
        return tmp;
    }

    public static String convertString(String str, Charset targetCharset, Charset ... srcCharset) {
        String tmp = str;
        if (StringUtils.isNotBlank((CharSequence)str) && targetCharset != null) {
            for (Charset charset : srcCharset) {
                String s = StringConvertUtils.convertString(str, charset, targetCharset);
                if (StringConvertUtils.isMessyCode(s)) continue;
                tmp = s;
                break;
            }
        }
        return tmp;
    }
}

