/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.eccpsupplierportal.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.eccpsupplierportal.entity.Store;
import com.xforceplus.eccpsupplierportal.service.IStoreService;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class StoreController {
    @Autowired
    private IStoreService storeServiceImpl;

    @GetMapping(value={"/stores"})
    public XfR getStores(XfPage page, Store store) {
        return XfR.ok((Object)this.storeServiceImpl.page((IPage)page, (Wrapper)Wrappers.query((Object)store)));
    }

    @GetMapping(value={"/stores/{id}"})
    public XfR getById(@PathVariable Long id) {
        return XfR.ok((Object)this.storeServiceImpl.getById(id));
    }

    @PostMapping(value={"/stores"})
    public XfR save(@RequestBody Store store) {
        return XfR.ok((Object)this.storeServiceImpl.save(store));
    }

    @PutMapping(value={"/stores/{id}"})
    public XfR putUpdate(@RequestBody Store store, @PathVariable Long id) {
        store.setId(id);
        return XfR.ok((Object)this.storeServiceImpl.updateById(store));
    }

    @PatchMapping(value={"/stores/{id}"})
    public XfR patchUpdate(@RequestBody Store store, @PathVariable Long id) {
        Store upstore = (Store)this.storeServiceImpl.getById(id);
        if (upstore != null) {
            upstore = (Store)ObjectCopyUtils.copyProperties((Object)store, (Object)upstore, (boolean)true);
        }
        return XfR.ok((Object)this.storeServiceImpl.updateById(upstore));
    }

    @DeleteMapping(value={"/stores/{id}"})
    public XfR removeById(@PathVariable Long id) {
        return XfR.ok((Object)this.storeServiceImpl.removeById(id));
    }

    @PostMapping(value={"/stores/query"})
    public XfR querys(@RequestBody ConditionQueryRequest condition) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("tableName", "store");
        params.put("request", condition);
        return XfR.ok(this.storeServiceImpl.querys(params));
    }
}

