package com.xforceplus.eccpsupplierportal.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.eccpsupplierportal.entity.Acceptance;
import com.xforceplus.eccpsupplierportal.service.IAcceptanceService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author wangzheng
 * @date 2020-08-26
 */
@RestController
public class AcceptanceController {

  @Autowired
  private IAcceptanceService acceptanceServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param acceptance ${table.comment}
   * @return
   */
  @GetMapping("/acceptances" )
  public XfR getAcceptances(XfPage page, Acceptance acceptance) {
    return XfR.ok(acceptanceServiceImpl.page(page, Wrappers.query(acceptance)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/acceptances/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(acceptanceServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param acceptance ${table.comment}
   * @return XfR
   */
  @PostMapping("/acceptances")
  public XfR save(@RequestBody Acceptance acceptance) {
     return XfR.ok(acceptanceServiceImpl.save(acceptance));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param acceptance ${table.comment}
   * @return XfR
   */
  @PutMapping("/acceptances/{id}")
  public XfR putUpdate(@RequestBody Acceptance acceptance,@PathVariable Long id) {
      acceptance.setId(id);
      return XfR.ok(acceptanceServiceImpl.updateById(acceptance));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param acceptance ${table.comment}
   * @return XfR
   */
  @PatchMapping("/acceptances/{id}")
  public XfR patchUpdate(@RequestBody Acceptance acceptance,@PathVariable Long id) {
      Acceptance upacceptance = acceptanceServiceImpl.getById(id);
      if(upacceptance != null){
        upacceptance = ObjectCopyUtils.copyProperties(acceptance,upacceptance,true);
      }
      return XfR.ok(acceptanceServiceImpl.updateById(upacceptance));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/acceptances/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(acceptanceServiceImpl.removeById(id));
  }

  @PostMapping("/acceptances/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
      Map<String, Object> params = new HashMap();
      params.put("tableName", "acceptance");
      params.put("request", condition);

     return XfR.ok(acceptanceServiceImpl.querys(params));
  }

}
