package com.xforceplus.eccpsupplierportal.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.eccpsupplierportal.entity.Bank;
import com.xforceplus.eccpsupplierportal.service.IBankService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author wangzheng
 * @date 2020-08-26
 */
@RestController
public class BankController {

  @Autowired
  private IBankService bankServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param bank ${table.comment}
   * @return
   */
  @GetMapping("/banks" )
  public XfR getBanks(XfPage page, Bank bank) {
    return XfR.ok(bankServiceImpl.page(page, Wrappers.query(bank)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/banks/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(bankServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param bank ${table.comment}
   * @return XfR
   */
  @PostMapping("/banks")
  public XfR save(@RequestBody Bank bank) {
     return XfR.ok(bankServiceImpl.save(bank));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param bank ${table.comment}
   * @return XfR
   */
  @PutMapping("/banks/{id}")
  public XfR putUpdate(@RequestBody Bank bank,@PathVariable Long id) {
      bank.setId(id);
      return XfR.ok(bankServiceImpl.updateById(bank));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param bank ${table.comment}
   * @return XfR
   */
  @PatchMapping("/banks/{id}")
  public XfR patchUpdate(@RequestBody Bank bank,@PathVariable Long id) {
      Bank upbank = bankServiceImpl.getById(id);
      if(upbank != null){
        upbank = ObjectCopyUtils.copyProperties(bank,upbank,true);
      }
      return XfR.ok(bankServiceImpl.updateById(upbank));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/banks/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(bankServiceImpl.removeById(id));
  }

  @PostMapping("/banks/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
      Map<String, Object> params = new HashMap();
      params.put("tableName", "bank");
      params.put("request", condition);

     return XfR.ok(bankServiceImpl.querys(params));
  }

}
