package com.xforceplus.eccpsupplierportal.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.eccpsupplierportal.entity.CostumeReservationOrder;
import com.xforceplus.eccpsupplierportal.service.ICostumeReservationOrderService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author wangzheng
 * @date 2020-08-26
 */
@RestController
public class CostumeReservationOrderController {

  @Autowired
  private ICostumeReservationOrderService costumeReservationOrderServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param costumeReservationOrder ${table.comment}
   * @return
   */
  @GetMapping("/costumereservationorders" )
  public XfR getCostumeReservationOrders(XfPage page, CostumeReservationOrder costumeReservationOrder) {
    return XfR.ok(costumeReservationOrderServiceImpl.page(page, Wrappers.query(costumeReservationOrder)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/costumereservationorders/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(costumeReservationOrderServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param costumeReservationOrder ${table.comment}
   * @return XfR
   */
  @PostMapping("/costumereservationorders")
  public XfR save(@RequestBody CostumeReservationOrder costumeReservationOrder) {
     return XfR.ok(costumeReservationOrderServiceImpl.save(costumeReservationOrder));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param costumeReservationOrder ${table.comment}
   * @return XfR
   */
  @PutMapping("/costumereservationorders/{id}")
  public XfR putUpdate(@RequestBody CostumeReservationOrder costumeReservationOrder,@PathVariable Long id) {
      costumeReservationOrder.setId(id);
      return XfR.ok(costumeReservationOrderServiceImpl.updateById(costumeReservationOrder));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param costumeReservationOrder ${table.comment}
   * @return XfR
   */
  @PatchMapping("/costumereservationorders/{id}")
  public XfR patchUpdate(@RequestBody CostumeReservationOrder costumeReservationOrder,@PathVariable Long id) {
      CostumeReservationOrder upcostumeReservationOrder = costumeReservationOrderServiceImpl.getById(id);
      if(upcostumeReservationOrder != null){
        upcostumeReservationOrder = ObjectCopyUtils.copyProperties(costumeReservationOrder,upcostumeReservationOrder,true);
      }
      return XfR.ok(costumeReservationOrderServiceImpl.updateById(upcostumeReservationOrder));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/costumereservationorders/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(costumeReservationOrderServiceImpl.removeById(id));
  }

  @PostMapping("/costumereservationorders/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
      Map<String, Object> params = new HashMap();
      params.put("tableName", "costumereservationorder");
      params.put("request", condition);

     return XfR.ok(costumeReservationOrderServiceImpl.querys(params));
  }

}
