package com.xforceplus.eccpsupplierportal.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.eccpsupplierportal.entity.OrderNotice;
import com.xforceplus.eccpsupplierportal.service.IOrderNoticeService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author wangzheng
 * @date 2020-08-26
 */
@RestController
public class OrderNoticeController {

  @Autowired
  private IOrderNoticeService orderNoticeServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param orderNotice ${table.comment}
   * @return
   */
  @GetMapping("/ordernotices" )
  public XfR getOrderNotices(XfPage page, OrderNotice orderNotice) {
    return XfR.ok(orderNoticeServiceImpl.page(page, Wrappers.query(orderNotice)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/ordernotices/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(orderNoticeServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param orderNotice ${table.comment}
   * @return XfR
   */
  @PostMapping("/ordernotices")
  public XfR save(@RequestBody OrderNotice orderNotice) {
     return XfR.ok(orderNoticeServiceImpl.save(orderNotice));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param orderNotice ${table.comment}
   * @return XfR
   */
  @PutMapping("/ordernotices/{id}")
  public XfR putUpdate(@RequestBody OrderNotice orderNotice,@PathVariable Long id) {
      orderNotice.setId(id);
      return XfR.ok(orderNoticeServiceImpl.updateById(orderNotice));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param orderNotice ${table.comment}
   * @return XfR
   */
  @PatchMapping("/ordernotices/{id}")
  public XfR patchUpdate(@RequestBody OrderNotice orderNotice,@PathVariable Long id) {
      OrderNotice uporderNotice = orderNoticeServiceImpl.getById(id);
      if(uporderNotice != null){
        uporderNotice = ObjectCopyUtils.copyProperties(orderNotice,uporderNotice,true);
      }
      return XfR.ok(orderNoticeServiceImpl.updateById(uporderNotice));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ordernotices/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(orderNoticeServiceImpl.removeById(id));
  }

  @PostMapping("/ordernotices/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
      Map<String, Object> params = new HashMap();
      params.put("tableName", "ordernotice");
      params.put("request", condition);

     return XfR.ok(orderNoticeServiceImpl.querys(params));
  }

}
