package com.xforceplus.eccpsupplierportal.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.eccpsupplierportal.entity.ReservationOrder;
import com.xforceplus.eccpsupplierportal.service.IReservationOrderService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author wangzheng
 * @date 2020-08-26
 */
@RestController
public class ReservationOrderController {

  @Autowired
  private IReservationOrderService reservationOrderServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param reservationOrder ${table.comment}
   * @return
   */
  @GetMapping("/reservationorders" )
  public XfR getReservationOrders(XfPage page, ReservationOrder reservationOrder) {
    return XfR.ok(reservationOrderServiceImpl.page(page, Wrappers.query(reservationOrder)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/reservationorders/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(reservationOrderServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param reservationOrder ${table.comment}
   * @return XfR
   */
  @PostMapping("/reservationorders")
  public XfR save(@RequestBody ReservationOrder reservationOrder) {
     return XfR.ok(reservationOrderServiceImpl.save(reservationOrder));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param reservationOrder ${table.comment}
   * @return XfR
   */
  @PutMapping("/reservationorders/{id}")
  public XfR putUpdate(@RequestBody ReservationOrder reservationOrder,@PathVariable Long id) {
      reservationOrder.setId(id);
      return XfR.ok(reservationOrderServiceImpl.updateById(reservationOrder));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param reservationOrder ${table.comment}
   * @return XfR
   */
  @PatchMapping("/reservationorders/{id}")
  public XfR patchUpdate(@RequestBody ReservationOrder reservationOrder,@PathVariable Long id) {
      ReservationOrder upreservationOrder = reservationOrderServiceImpl.getById(id);
      if(upreservationOrder != null){
        upreservationOrder = ObjectCopyUtils.copyProperties(reservationOrder,upreservationOrder,true);
      }
      return XfR.ok(reservationOrderServiceImpl.updateById(upreservationOrder));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/reservationorders/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(reservationOrderServiceImpl.removeById(id));
  }

  @PostMapping("/reservationorders/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
      Map<String, Object> params = new HashMap();
      params.put("tableName", "reservationorder");
      params.put("request", condition);

     return XfR.ok(reservationOrderServiceImpl.querys(params));
  }

}
