package com.xforceplus.eccpsupplierportal.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.eccpsupplierportal.entity.Store;
import com.xforceplus.eccpsupplierportal.service.IStoreService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author wangzheng
 * @date 2020-08-26
 */
@RestController
public class StoreController {

  @Autowired
  private IStoreService storeServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param store ${table.comment}
   * @return
   */
  @GetMapping("/stores" )
  public XfR getStores(XfPage page, Store store) {
    return XfR.ok(storeServiceImpl.page(page, Wrappers.query(store)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/stores/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(storeServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param store ${table.comment}
   * @return XfR
   */
  @PostMapping("/stores")
  public XfR save(@RequestBody Store store) {
     return XfR.ok(storeServiceImpl.save(store));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param store ${table.comment}
   * @return XfR
   */
  @PutMapping("/stores/{id}")
  public XfR putUpdate(@RequestBody Store store,@PathVariable Long id) {
      store.setId(id);
      return XfR.ok(storeServiceImpl.updateById(store));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param store ${table.comment}
   * @return XfR
   */
  @PatchMapping("/stores/{id}")
  public XfR patchUpdate(@RequestBody Store store,@PathVariable Long id) {
      Store upstore = storeServiceImpl.getById(id);
      if(upstore != null){
        upstore = ObjectCopyUtils.copyProperties(store,upstore,true);
      }
      return XfR.ok(storeServiceImpl.updateById(upstore));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/stores/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(storeServiceImpl.removeById(id));
  }

  @PostMapping("/stores/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
      Map<String, Object> params = new HashMap();
      params.put("tableName", "store");
      params.put("request", condition);

     return XfR.ok(storeServiceImpl.querys(params));
  }

}
