package com.xforceplus.eccpsupplierportal.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.eccpsupplierportal.entity.SupplierPurchaseorg;
import com.xforceplus.eccpsupplierportal.service.ISupplierPurchaseorgService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author wangzheng
 * @date 2020-08-26
 */
@RestController
public class SupplierPurchaseorgController {

  @Autowired
  private ISupplierPurchaseorgService supplierPurchaseorgServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param supplierPurchaseorg ${table.comment}
   * @return
   */
  @GetMapping("/supplierpurchaseorgs" )
  public XfR getSupplierPurchaseorgs(XfPage page, SupplierPurchaseorg supplierPurchaseorg) {
    return XfR.ok(supplierPurchaseorgServiceImpl.page(page, Wrappers.query(supplierPurchaseorg)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/supplierpurchaseorgs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(supplierPurchaseorgServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param supplierPurchaseorg ${table.comment}
   * @return XfR
   */
  @PostMapping("/supplierpurchaseorgs")
  public XfR save(@RequestBody SupplierPurchaseorg supplierPurchaseorg) {
     return XfR.ok(supplierPurchaseorgServiceImpl.save(supplierPurchaseorg));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param supplierPurchaseorg ${table.comment}
   * @return XfR
   */
  @PutMapping("/supplierpurchaseorgs/{id}")
  public XfR putUpdate(@RequestBody SupplierPurchaseorg supplierPurchaseorg,@PathVariable Long id) {
      supplierPurchaseorg.setId(id);
      return XfR.ok(supplierPurchaseorgServiceImpl.updateById(supplierPurchaseorg));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param supplierPurchaseorg ${table.comment}
   * @return XfR
   */
  @PatchMapping("/supplierpurchaseorgs/{id}")
  public XfR patchUpdate(@RequestBody SupplierPurchaseorg supplierPurchaseorg,@PathVariable Long id) {
      SupplierPurchaseorg upsupplierPurchaseorg = supplierPurchaseorgServiceImpl.getById(id);
      if(upsupplierPurchaseorg != null){
        upsupplierPurchaseorg = ObjectCopyUtils.copyProperties(supplierPurchaseorg,upsupplierPurchaseorg,true);
      }
      return XfR.ok(supplierPurchaseorgServiceImpl.updateById(upsupplierPurchaseorg));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/supplierpurchaseorgs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(supplierPurchaseorgServiceImpl.removeById(id));
  }

  @PostMapping("/supplierpurchaseorgs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
      Map<String, Object> params = new HashMap();
      params.put("tableName", "supplierpurchaseorg");
      params.put("request", condition);

     return XfR.ok(supplierPurchaseorgServiceImpl.querys(params));
  }

}
