package com.xforceplus.eccpxdomain.controller;


/**
 * 元数据信息feign客户端
 *
 * @author ultraman
 * @date 2022-11-18
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.eccpxdomain.entity.MetaData;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "eccp-x-domain")
public interface MetaDataFeignApi {

  /**
   * 通过id查询元数据信息
   * @param  id
   * @return R
   */
  @GetMapping("/metaData/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增元数据信息
   * @param metaData 元数据信息
   * @return R
   */
  @PostMapping("/metaData/add")
  public R save(@RequestBody MetaData metaData);

  /**
   * 修改元数据信息
   * @param metaData 元数据信息
   * @return R
   */
  @PostMapping("/metaData/update")
  public R updateById(@RequestBody MetaData metaData);

  /**
   * 通过id删除元数据信息
   * @param  id
   * @return R
   */
  @DeleteMapping("/metaData/del/{id}" )
  public R removeById(@PathVariable Long id);

}