package com.xforceplus.eccpxdomain.controller;


/**
 * 订单行feign客户端
 *
 * @author ultraman
 * @date 2022-11-18
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.eccpxdomain.entity.OrderBillLine;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "eccp-x-domain")
public interface OrderBillLineFeignApi {

  /**
   * 通过id查询订单行
   * @param  id
   * @return R
   */
  @GetMapping("/orderBillLine/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增订单行
   * @param orderBillLine 订单行
   * @return R
   */
  @PostMapping("/orderBillLine/add")
  public R save(@RequestBody OrderBillLine orderBillLine);

  /**
   * 修改订单行
   * @param orderBillLine 订单行
   * @return R
   */
  @PostMapping("/orderBillLine/update")
  public R updateById(@RequestBody OrderBillLine orderBillLine);

  /**
   * 通过id删除订单行
   * @param  id
   * @return R
   */
  @DeleteMapping("/orderBillLine/del/{id}" )
  public R removeById(@PathVariable Long id);

}