package com.xforceplus.eccpxdomain.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.eccpxdomain.entity.BillVersion;
import com.xforceplus.eccpxdomain.service.IBillVersionService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-09-28
 */
@RestController
public class BillVersionController {

  @Autowired
  private IBillVersionService billVersionServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param billVersion ${table.comment}
   * @return
   */
  @GetMapping("/billversions" )
  public XfR getBillVersions(XfPage page, BillVersion billVersion) {
    return XfR.ok(billVersionServiceImpl.page(page, Wrappers.query(billVersion)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/billversions/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(billVersionServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param billVersion ${table.comment}
   * @return XfR
   */
  @PostMapping("/billversions")
  public XfR save(@RequestBody BillVersion billVersion) {
     return XfR.ok(billVersionServiceImpl.save(billVersion));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param billVersion ${table.comment}
   * @return XfR
   */
  @PutMapping("/billversions/{id}")
  public XfR putUpdate(@RequestBody BillVersion billVersion,@PathVariable Long id) {
      billVersion.setId(id);
      return XfR.ok(billVersionServiceImpl.updateById(billVersion));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param billVersion ${table.comment}
   * @return XfR
   */
  @PatchMapping("/billversions/{id}")
  public XfR patchUpdate(@RequestBody BillVersion billVersion,@PathVariable Long id) {
      BillVersion upbillVersion = billVersionServiceImpl.getById(id);
      if(upbillVersion != null){
        upbillVersion = ObjectCopyUtils.copyProperties(billVersion,upbillVersion,true);
      }
      return XfR.ok(billVersionServiceImpl.updateById(upbillVersion));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/billversions/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(billVersionServiceImpl.removeById(id));
  }

  @PostMapping("/billversions/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "bill_version");
     params.put("request", condition);

     return XfR.ok(billVersionServiceImpl.querys(params));
  }

}
