package com.xforceplus.eccpxdomain.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.eccpxdomain.entity.PriceBillHead;
import com.xforceplus.eccpxdomain.service.IPriceBillHeadService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-09-28
 */
@RestController
public class PriceBillHeadController {

  @Autowired
  private IPriceBillHeadService priceBillHeadServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param priceBillHead ${table.comment}
   * @return
   */
  @GetMapping("/pricebillheads" )
  public XfR getPriceBillHeads(XfPage page, PriceBillHead priceBillHead) {
    return XfR.ok(priceBillHeadServiceImpl.page(page, Wrappers.query(priceBillHead)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/pricebillheads/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(priceBillHeadServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param priceBillHead ${table.comment}
   * @return XfR
   */
  @PostMapping("/pricebillheads")
  public XfR save(@RequestBody PriceBillHead priceBillHead) {
     return XfR.ok(priceBillHeadServiceImpl.save(priceBillHead));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param priceBillHead ${table.comment}
   * @return XfR
   */
  @PutMapping("/pricebillheads/{id}")
  public XfR putUpdate(@RequestBody PriceBillHead priceBillHead,@PathVariable Long id) {
      priceBillHead.setId(id);
      return XfR.ok(priceBillHeadServiceImpl.updateById(priceBillHead));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param priceBillHead ${table.comment}
   * @return XfR
   */
  @PatchMapping("/pricebillheads/{id}")
  public XfR patchUpdate(@RequestBody PriceBillHead priceBillHead,@PathVariable Long id) {
      PriceBillHead uppriceBillHead = priceBillHeadServiceImpl.getById(id);
      if(uppriceBillHead != null){
        uppriceBillHead = ObjectCopyUtils.copyProperties(priceBillHead,uppriceBillHead,true);
      }
      return XfR.ok(priceBillHeadServiceImpl.updateById(uppriceBillHead));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/pricebillheads/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(priceBillHeadServiceImpl.removeById(id));
  }

  @PostMapping("/pricebillheads/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "price_bill_head");
     params.put("request", condition);

     return XfR.ok(priceBillHeadServiceImpl.querys(params));
  }

}
