package com.xforceplus.eccpxdomain.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.eccpxdomain.entity.DeliverBillLine;
import com.xforceplus.eccpxdomain.service.IDeliverBillLineService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-04-28
 */
@RestController
public class DeliverBillLineController {

  @Autowired
  private IDeliverBillLineService deliverBillLineServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param deliverBillLine ${table.comment}
   * @return
   */
  @GetMapping("/deliverbilllines" )
  public XfR getDeliverBillLines(XfPage page, DeliverBillLine deliverBillLine) {
    return XfR.ok(deliverBillLineServiceImpl.page(page, Wrappers.query(deliverBillLine)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/deliverbilllines/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(deliverBillLineServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param deliverBillLine ${table.comment}
   * @return XfR
   */
  @PostMapping("/deliverbilllines")
  public XfR save(@RequestBody DeliverBillLine deliverBillLine) {
     return XfR.ok(deliverBillLineServiceImpl.save(deliverBillLine));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param deliverBillLine ${table.comment}
   * @return XfR
   */
  @PutMapping("/deliverbilllines/{id}")
  public XfR putUpdate(@RequestBody DeliverBillLine deliverBillLine,@PathVariable Long id) {
      deliverBillLine.setId(id);
      return XfR.ok(deliverBillLineServiceImpl.updateById(deliverBillLine));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param deliverBillLine ${table.comment}
   * @return XfR
   */
  @PatchMapping("/deliverbilllines/{id}")
  public XfR patchUpdate(@RequestBody DeliverBillLine deliverBillLine,@PathVariable Long id) {
      DeliverBillLine updeliverBillLine = deliverBillLineServiceImpl.getById(id);
      if(updeliverBillLine != null){
        updeliverBillLine = ObjectCopyUtils.copyProperties(deliverBillLine,updeliverBillLine,true);
      }
      return XfR.ok(deliverBillLineServiceImpl.updateById(updeliverBillLine));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/deliverbilllines/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(deliverBillLineServiceImpl.removeById(id));
  }

  @PostMapping("/deliverbilllines/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "deliver_bill_line");
     params.put("request", condition);

     return XfR.ok(deliverBillLineServiceImpl.querys(params));
  }

}
