package com.xforceplus.eccpxdomain.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.eccpxdomain.entity.PreBill;
import com.xforceplus.eccpxdomain.service.IPreBillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-04-28
 */
@RestController
public class PreBillController {

  @Autowired
  private IPreBillService preBillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param preBill ${table.comment}
   * @return
   */
  @GetMapping("/prebills" )
  public XfR getPreBills(XfPage page, PreBill preBill) {
    return XfR.ok(preBillServiceImpl.page(page, Wrappers.query(preBill)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/prebills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(preBillServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param preBill ${table.comment}
   * @return XfR
   */
  @PostMapping("/prebills")
  public XfR save(@RequestBody PreBill preBill) {
     return XfR.ok(preBillServiceImpl.save(preBill));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param preBill ${table.comment}
   * @return XfR
   */
  @PutMapping("/prebills/{id}")
  public XfR putUpdate(@RequestBody PreBill preBill,@PathVariable Long id) {
      preBill.setId(id);
      return XfR.ok(preBillServiceImpl.updateById(preBill));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param preBill ${table.comment}
   * @return XfR
   */
  @PatchMapping("/prebills/{id}")
  public XfR patchUpdate(@RequestBody PreBill preBill,@PathVariable Long id) {
      PreBill uppreBill = preBillServiceImpl.getById(id);
      if(uppreBill != null){
        uppreBill = ObjectCopyUtils.copyProperties(preBill,uppreBill,true);
      }
      return XfR.ok(preBillServiceImpl.updateById(uppreBill));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/prebills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(preBillServiceImpl.removeById(id));
  }

  @PostMapping("/prebills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "pre_bill");
     params.put("request", condition);

     return XfR.ok(preBillServiceImpl.querys(params));
  }

}
