package com.xforceplus.eccpxdomain.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.eccpxdomain.entity.MetaData;
import com.xforceplus.eccpxdomain.service.IMetaDataService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-06-28
 */
@RestController
public class MetaDataController {

  @Autowired
  private IMetaDataService metaDataServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param metaData ${table.comment}
   * @return
   */
  @GetMapping("/metadatas" )
  public XfR getMetaDatas(XfPage page, MetaData metaData) {
    return XfR.ok(metaDataServiceImpl.page(page, Wrappers.query(metaData)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/metadatas/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(metaDataServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param metaData ${table.comment}
   * @return XfR
   */
  @PostMapping("/metadatas")
  public XfR save(@RequestBody MetaData metaData) {
     return XfR.ok(metaDataServiceImpl.save(metaData));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param metaData ${table.comment}
   * @return XfR
   */
  @PutMapping("/metadatas/{id}")
  public XfR putUpdate(@RequestBody MetaData metaData,@PathVariable Long id) {
      metaData.setId(id);
      return XfR.ok(metaDataServiceImpl.updateById(metaData));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param metaData ${table.comment}
   * @return XfR
   */
  @PatchMapping("/metadatas/{id}")
  public XfR patchUpdate(@RequestBody MetaData metaData,@PathVariable Long id) {
      MetaData upmetaData = metaDataServiceImpl.getById(id);
      if(upmetaData != null){
        upmetaData = ObjectCopyUtils.copyProperties(metaData,upmetaData,true);
      }
      return XfR.ok(metaDataServiceImpl.updateById(upmetaData));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/metadatas/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(metaDataServiceImpl.removeById(id));
  }

  @PostMapping("/metadatas/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "meta_data");
     params.put("request", condition);

     return XfR.ok(metaDataServiceImpl.querys(params));
  }

}
